/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.model.capture.Bookmark;
import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.FrameProvider;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.capturedata.Region;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.stream.Stream;

public class UserRegionsProvider
extends Provider {
    private static final String INVALID_FORMAT = "Region file is an invalid format.";
    private List<Region> regions;
    private Optional<UserProvidedPath> customRegions;
    private Optional<Double> minRegionLength;
    private FrameProvider frameProvider;

    public UserRegionsProvider(CaptureData captureData, Optional<UserProvidedPath> customRegions, Optional<Double> minRegionLength) {
        super(captureData);
        this.customRegions = customRegions;
        this.minRegionLength = minRegionLength;
    }

    @Override
    public ProblemList initialise() {
        ProblemList problemList = new ProblemList();
        this.frameProvider = this.captureData.getFrameProvider();
        this.regions = new ArrayList<Region>();
        if (this.frameProvider.getFrames().isEmpty()) {
            return problemList;
        }
        this.regions.addAll(this.initialiseRegionsFromCapture(problemList));
        this.regions.addAll(this.initialiseRegionsFromArgs(this.regions, problemList));
        this.minimumRegionLengthFilter(this.regions, problemList);
        if (this.regions.isEmpty()) {
            problemList.addWarning("User regions not provided.", "You can add this using annotation instrumentation in the application. Consult the user guide for more information.");
        } else {
            Region.calculateStackLevels(this.regions);
        }
        return problemList;
    }

    private List<Region> initialiseRegionsFromCapture(ProblemList problemList) {
        Stream<Bookmark> regionBookmarks = this.captureData.getBookmarks("Region ");
        ArrayList<Region> captureRegions = new ArrayList<Region>();
        if (regionBookmarks != null) {
            ArrayList halfRegions = new ArrayList();
            regionBookmarks.forEachOrdered(b -> UserRegionsProvider.processRegionBookmark(b, problemList, captureRegions, halfRegions));
            halfRegions.forEach(r -> {
                boolean bl = captureRegions.add(new Region(r.tag, r.pos, this.captureData.getBinCount()));
            });
        }
        Application.LOG.info(() -> captureRegions.size() + " regions in capture.");
        return captureRegions;
    }

    private static void processRegionBookmark(Bookmark b, ProblemList problemList, List<Region> captureRegions, List<HalfRegion> halfRegions) {
        String title = b.getTitle();
        Application.LOG.fine(() -> "Found " + title);
        boolean isStart = title.startsWith("Region Start");
        String tag = title.substring(isStart ? "Region Start ".length() : "Region End ".length());
        int time = (int)(b.getTimestamp() / 1000000L);
        Optional<HalfRegion> half = halfRegions.stream().filter(r -> r.getTag().equals(tag)).findFirst();
        if (half.isPresent()) {
            assert (half.get().getPos() <= time);
            if (isStart) {
                problemList.addWarning("Duplicate 'Region Start' annotations found for region '" + tag + "'", "Second region start will be ignored");
            } else if (half.get().getPos() == time) {
                problemList.addWarning("Region '" + tag + "' is empty (length 0)", "It is being ignored");
            } else {
                captureRegions.add(new Region(tag, half.get().getPos(), time));
                halfRegions.remove(half.get());
            }
        } else if (isStart) {
            halfRegions.add(new HalfRegion(time, tag));
        } else {
            captureRegions.add(new Region(tag, 0, time));
        }
    }

    /*
     * Exception decompiling
     */
    private List<Region> initialiseRegionsFromArgs(List<Region> captureRegions, ProblemList problemList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Region makeRegion(String name, RegionBoundary start, RegionBoundary end) {
        return new Region(name, start.getPos(), end.getPos(), start.getIsWildcard(), end.getIsWildcard());
    }

    private static String warningPrefix(String name) {
        return "Region '" + name + "' ";
    }

    private static String getRegionNameAndCheckUnique(Scanner lineScanner, List<Region> captureRegions, List<Region> argRegions) {
        String name;
        if (lineScanner.hasNext()) {
            name = lineScanner.next();
            for (Region region : captureRegions) {
                if (!region.getName().equals(name)) continue;
                throw new FatalError("Duplicate region name '" + name + "' found.");
            }
            for (Region region : argRegions) {
                if (!region.getName().equals(name)) continue;
                throw new FatalError("Duplicate region name '" + name + "' found.");
            }
        } else {
            throw new FatalError(INVALID_FORMAT);
        }
        return name;
    }

    private void minimumRegionLengthFilter(List<Region> regions, ProblemList problemList) {
        if (this.minRegionLength.isPresent()) {
            double minLength = this.minRegionLength.get();
            Iterator<Region> iter = regions.iterator();
            while (iter.hasNext()) {
                Region region = iter.next();
                if (!((double)region.getLength() * 0.001 < minLength)) continue;
                problemList.addWarning(UserRegionsProvider.warningPrefix(region.getName()) + "length is under the minimum.");
                iter.remove();
            }
        }
    }

    private RegionBoundary getRegionBoundary(Scanner lineScanner, int wildcardValue) {
        RegionBoundary bndry = null;
        if (lineScanner.hasNext()) {
            String str = lineScanner.next().replaceAll("\\s", "");
            if (str.length() > 1 && str.substring(str.length() - 1).equals("f")) {
                String frameStr = str.substring(0, str.length() - 1);
                if (UserRegionsProvider.canParseInt(frameStr)) {
                    bndry = this.makeBoundaryFromFrame(Integer.parseInt(frameStr));
                }
            } else if (str.equals("*")) {
                bndry = new RegionBoundary(wildcardValue, true);
            } else if (UserRegionsProvider.canParseInt(str)) {
                bndry = new RegionBoundary(Integer.parseInt(str), false);
            }
        }
        if (bndry == null) {
            throw new FatalError(INVALID_FORMAT);
        }
        return bndry;
    }

    private RegionBoundary makeBoundaryFromFrame(int frame) {
        RegionBoundary bndry = frame < 0 ? new RegionBoundary(-1, false) : (frame < this.frameProvider.getNumFrames() ? new RegionBoundary(this.frameProvider.getStartIndex(frame), false) : new RegionBoundary(this.captureData.getBinCount() + 1, false));
        return bndry;
    }

    private ProblemList validateBoundaries(RegionBoundary regionStart, RegionBoundary regionEnd, String name) {
        ProblemList problemList = new ProblemList();
        int start = regionStart.getPos();
        int end = regionEnd.getPos();
        if (start < 0 || end < 0) {
            problemList.addWarning(UserRegionsProvider.warningPrefix(name) + "not used because start/end contain negative values.", "Make sure the start and end values are not negative.");
        } else if (start > end) {
            problemList.addWarning(UserRegionsProvider.warningPrefix(name) + "not used as start value is larger than end value.", "Make sure the start value is less than the end value.");
        } else if (start > this.captureData.getBinCount()) {
            problemList.addWarning(UserRegionsProvider.warningPrefix(name) + "not used as start value exceeds capture length.", "Make sure the start value is within the capture.");
        } else if (start == end) {
            problemList.addWarning(UserRegionsProvider.warningPrefix(name) + "not used as start value is equal to end value.", "Make sure the start value is less than the end value.");
        }
        return problemList;
    }

    private static boolean canParseInt(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void execute() {
    }

    public Region getUserRegion(int index) {
        return this.regions.get(index);
    }

    public List<Region> getUserRegions() {
        return this.regions;
    }

    private static /* synthetic */ String lambda$5(String string) {
        return "Added custom region " + string;
    }

    private static /* synthetic */ String lambda$6(List list) {
        return list.size() + " regions in region file.";
    }

    private static class HalfRegion {
        private int pos;
        private String tag;

        public HalfRegion(int pos, String tag) {
            this.pos = pos;
            this.tag = tag;
        }

        public int getPos() {
            return this.pos;
        }

        public String getTag() {
            return this.tag;
        }
    }

    private static class RegionBoundary {
        private int pos;
        private boolean isWildcard;

        public RegionBoundary(int pos, boolean isWildcard) {
            this.pos = pos;
            this.isWildcard = isWildcard;
        }

        public int getPos() {
            return this.pos;
        }

        public boolean getIsWildcard() {
            return this.isWildcard;
        }
    }
}

