/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.model.capture.IProcessDataProvider;
import com.arm.streamline.model.timeline.ProcessData;
import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.common.ResourceProblem;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import java.io.File;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ProcessProvider
extends Provider {
    static final int NO_PROCESS_FOUND = -1;
    private final String inputRegex;
    private ProcessData processDatum;
    private final @NonNull Supplier<@Nullable ProcessData> camModelProcessFinder;

    public ProcessProvider(CaptureData captureData, String inputRegex, @NonNull Supplier<@Nullable ProcessData> camModelProcessFinder) {
        super(captureData);
        this.inputRegex = inputRegex;
        this.processDatum = null;
        this.camModelProcessFinder = camModelProcessFinder;
    }

    @Override
    public ProblemList initialise() {
        if (this.inputRegex != null) {
            return this.findProcessByRegex(this.inputRegex);
        }
        return this.handleNoInputRegex();
    }

    private ProblemList handleNoInputRegex() {
        ProcessData camModelProcess = this.camModelProcessFinder.get();
        if (camModelProcess == null) {
            return this.deriveProcessFromCapturedXml();
        }
        this.selectProcess(camModelProcess);
        return new ProblemList();
    }

    private ProblemList deriveProcessFromCapturedXml() {
        File xmlFile = new File(this.captureData.getCaptureDir(), "captured.xml");
        if (!xmlFile.exists()) {
            return new ProblemList(new ResourceProblem(ResourceProblem.Severity.ERROR, "No captured.xml file found", "It is likely the capture does not contain one and is invalid, try creating a new capture."));
        }
        String processName = ProcessProvider.processNameFromCapturedXml(xmlFile);
        @NonNull List<@NonNull ProcessData> processes = this.captureData.getProcessDataProvider().getProcessData(IProcessDataProvider.ThreadMode.PROCESS_ONLY);
        if (processes.isEmpty()) {
            return new ProblemList(new ResourceProblem(ResourceProblem.Severity.ERROR, "Cannot find process information in the capture", "Try launching your application before launching the gator daemon"));
        }
        if (processes.size() == 1) {
            this.selectProcess(processes.get(0));
            return new ProblemList();
        }
        String processListString = ProcessProvider.processesAsString(processes);
        if (processName == null) {
            return new ProblemList(new ResourceProblem(ResourceProblem.Severity.ERROR, "More than one process found in capture but no process name specified", String.format("Use the -p option to specify a single process to analyse. Processes in capture:%n%s", processListString)));
        }
        List<@NonNull T> matchedProcs = processes.stream().filter(p -> processName.contains(p.getProcessName())).collect(Collectors.toList());
        if (matchedProcs.size() == 1) {
            this.selectProcess((ProcessData)matchedProcs.get(0));
            return new ProblemList();
        }
        if (matchedProcs.size() == 0) {
            return new ProblemList(new ResourceProblem(ResourceProblem.Severity.ERROR, String.format("Process name (%s) does not match any of the processes in the capture", processName), String.format("Use the -p option to specify the process to use.  Processes in the capture:%n%s", processListString)));
        }
        this.selectProcess((ProcessData)matchedProcs.get(0));
        return new ProblemList();
    }

    private void selectProcess(@NonNull ProcessData selected) {
        this.processDatum = selected;
        Application.LOG.config(() -> "Selected process is '" + ProcessProvider.nameAndPidString(selected) + "'");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private ProblemList findProcessByRegex(@NonNull String regex) {
        IProcessDataProvider processDataProvider = (IProcessDataProvider)NullChecking.neverNull((Object)this.captureData.getProcessDataProvider());
        Pair<List<ProcessData>, ProblemList> result = ProcessProvider.tryFilterProcesses(processDataProvider, regex);
        if (result.first == null) {
            return (ProblemList)result.second;
        }
        assert (result.first != null);
        @NonNull List matched = (List)result.first;
        if (matched.size() == 1) {
            ProcessData matchedProc = (ProcessData)matched.get(0);
            ProcessData camProcess = this.camModelProcessFinder.get();
            if (camProcess != null && camProcess.getUID() != matchedProc.getUID()) {
                this.selectProcess(camProcess);
                return new ProblemList(new ResourceProblem(ResourceProblem.Severity.WARNING, String.format("Process matched with '%s', '%s' is different to the process rendering graphics '%s'", regex, ProcessProvider.nameAndPidString(matchedProc), ProcessProvider.nameAndPidString(camProcess)), String.format("Using process '%s' instead to generate report", ProcessProvider.nameAndPidString(camProcess))));
            }
            this.selectProcess(matchedProc);
            return new ProblemList();
        }
        if (matched.size() == 0) {
            return new ProblemList(new ResourceProblem(ResourceProblem.Severity.ERROR, String.format("Specified process regex (%s) does not match any of the processes in the capture", regex), String.format("Processes in capture:%n%s", ProcessProvider.processesAsString(processDataProvider.getProcessData(IProcessDataProvider.ThreadMode.PROCESS_ONLY)))));
        }
        return new ProblemList(new ResourceProblem(ResourceProblem.Severity.ERROR, String.format("Specified process regex (%s) matched more than one process", regex), String.format("Please correct the regex such that it matches exactly one process.  Processes matched:%n%s", ProcessProvider.processesAsString(matched))));
    }

    private static @NonNull Pair<@Nullable List<@NonNull ProcessData>, @Nullable ProblemList> tryFilterProcesses(@NonNull IProcessDataProvider processDataProvider, @NonNull String processSpecifier) {
        try {
            @NonNull List<@NonNull ProcessData> matched = processDataProvider.getSpecificProcessData(processSpecifier, IProcessDataProvider.ThreadMode.PROCESS_ONLY);
            return new Pair(matched, null);
        }
        catch (PatternSyntaxException ex) {
            return new Pair(null, (Object)new ProblemList(new ResourceProblem(ResourceProblem.Severity.ERROR, "Problem with the regex in process specifier: " + ProcessProvider.exceptionDescription(ex) + System.lineSeparator(), "Please provide a corrected process specifier")));
        }
    }

    private static @NonNull String exceptionDescription(@NonNull Exception ex) {
        String desc = ex.getMessage();
        if (desc == null) {
            return (String)NullChecking.neverNull((Object)ex.getClass().getSimpleName());
        }
        return desc;
    }

    private static @NonNull String processesAsString(@NonNull List<@NonNull ProcessData> processes) {
        return processes.stream().map(p -> ProcessProvider.nameAndPidString(p)).collect(Collectors.joining(System.lineSeparator()));
    }

    private static String nameAndPidString(@NonNull ProcessData process) {
        return process.getProcessName() + " (pid: " + process.getProcessID() + ")";
    }

    /*
     * Exception decompiling
     */
    private static String processNameFromCapturedXml(File xmlFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 14[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void execute() {
    }

    public String getName() {
        if (this.processDatum == null) {
            return null;
        }
        return this.processDatum.getProcessName();
    }

    public int getPid() {
        if (this.processDatum == null) {
            return -1;
        }
        return this.processDatum.getProcessID();
    }

    public int getUid() {
        if (this.processDatum == null) {
            return -1;
        }
        return this.processDatum.getUID();
    }
}

