/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.io.PlatformUtils;
import java.util.logging.Level;

public class PlatformLogProvider
extends Provider {
    private Level logLevel;

    public PlatformLogProvider(CaptureData captureData, Level logLevel) {
        super(captureData);
        this.logLevel = logLevel;
    }

    @Override
    public ProblemList initialise() {
        if (Application.LOG.isLoggable(this.logLevel)) {
            Application.LOG.log(this.logLevel, () -> "System OS name: " + System.getProperty("os.name"));
            StringBuilder macOsMsg = new StringBuilder("This is ");
            if (!PlatformUtils.isMacPlatform()) {
                macOsMsg.append("not ");
            }
            macOsMsg.append("a macOS platform");
            Application.LOG.log(this.logLevel, macOsMsg.toString());
            Application.LOG.log(this.logLevel, () -> "User working directory: " + System.getProperty("user.dir"));
            Application.LOG.log(this.logLevel, () -> "PA current directory: " + String.valueOf(PlatformUtils.getCwd()));
        }
        return new ProblemList();
    }

    @Override
    public void execute() {
    }
}

