/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import java.util.HashSet;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public class GpuTypeProvider
extends Provider {
    private @NonNull GpuType gpuType = GpuType.UNKNOWN;
    private @NonNull GpuFamily gpuFamily = GpuFamily.UNKNOWN;
    private OptionalInt shaderCoreCount = OptionalInt.empty();

    public GpuTypeProvider(CaptureData captureData) {
        super(captureData);
    }

    @Override
    public ProblemList initialise() {
        ProblemList problemList = new ProblemList();
        Set<String> maliTypes = this.findAllSeriesWithMaliDeviceType();
        if (maliTypes.size() > 1) {
            Application.LOG.fine(() -> "Warning: ambiguity when detecting GPU type: " + String.join((CharSequence)",", maliTypes));
        }
        Optional<Object> gpuCodeName = Optional.empty();
        String gpuPublicName = this.captureData.getGPUPublicName();
        if (gpuPublicName != null) {
            gpuCodeName = GpuTypeProvider.getGPUCodenameFromName(this.captureData.getGPUPublicName());
        }
        if (!maliTypes.isEmpty()) {
            String deviceName = maliTypes.iterator().next();
            this.gpuType = GpuTypeProvider.fromCodename(deviceName);
            this.setFamily();
            if (this.gpuFamily == GpuFamily.UNKNOWN) {
                problemList.addError("Unsupported GPU type - " + deviceName, "Please contact Arm in regards to adding support.");
            }
        } else {
            if (gpuCodeName.isPresent()) {
                this.gpuType = GpuTypeProvider.fromCodename((String)gpuCodeName.get());
                this.setFamily();
                if (this.gpuFamily == GpuFamily.UNKNOWN) {
                    problemList.addError("Unsupported GPU type - " + (String)gpuCodeName.get(), "Please contact Arm in regards to adding support.");
                }
                throw new LogicError("Missing charts for GPU type - " + (String)gpuCodeName.get() + "\nPlease ensure you have enabled Mali GPU Profile capture or have selected the appropriate GPU template when performing the capture");
            }
            this.gpuType = GpuType.UNKNOWN;
            this.gpuFamily = GpuFamily.UNKNOWN;
            problemList.addError("Cannot determine GPU type", "Make sure you are using a supported device and included the GPU counters in the capture by setting the relevant template.");
        }
        if (this.shaderCoreCount.isEmpty()) {
            problemList.addWarning("Cannot determine shader core count");
        }
        return problemList;
    }

    private static Optional<String> getGPUCodenameFromName(@NonNull String name) {
        if (name.startsWith("Mali-") || name.startsWith("Mali ")) {
            return Optional.of(name.substring(5));
        }
        if (name.startsWith("Immortalis-")) {
            return Optional.of(name);
        }
        return Optional.empty();
    }

    private @NonNull Set<@NonNull String> findAllSeriesWithMaliDeviceType() {
        HashSet<String> maliTypes = new HashSet<String>();
        for (IChartDataProvider c : this.captureData.getChartList()) {
            for (ISeriesDataProvider s : c.getSeries()) {
                double[] gpuCoresSeries;
                Optional<String> codeName;
                DeviceType deviceType = s.getCoreInformationProvider().getDeviceType();
                if (deviceType != null && (codeName = GpuTypeProvider.getGPUCodenameFromName(deviceType.getName())).isPresent()) {
                    maliTypes.add(codeName.get());
                }
                if (!c.getTitle().equals("Mali Constants") || !s.getName().equals("Shader Core Count") || (gpuCoresSeries = s.getData(0, 0, null)) == null || gpuCoresSeries[0] == 0.0) continue;
                this.shaderCoreCount = OptionalInt.of((int)gpuCoresSeries[0]);
            }
        }
        maliTypes.remove("CONST");
        return maliTypes;
    }

    private static @NonNull GpuType fromCodename(@NonNull String codename) {
        switch (codename) {
            case "T720": {
                return GpuType.MALI_T720;
            }
            case "T760": {
                return GpuType.MALI_T760;
            }
            case "T820": {
                return GpuType.MALI_T820;
            }
            case "T830": {
                return GpuType.MALI_T830;
            }
            case "T860": {
                return GpuType.MALI_T860;
            }
            case "T880": {
                return GpuType.MALI_T880;
            }
            case "G31": {
                return GpuType.MALI_G31;
            }
            case "G51": {
                return GpuType.MALI_G51;
            }
            case "G52": {
                return GpuType.MALI_G52;
            }
            case "G71": {
                return GpuType.MALI_G71;
            }
            case "G72": {
                return GpuType.MALI_G72;
            }
            case "G76": {
                return GpuType.MALI_G76;
            }
            case "G57": {
                return GpuType.MALI_G57;
            }
            case "G68": {
                return GpuType.MALI_G68;
            }
            case "G77": {
                return GpuType.MALI_G77;
            }
            case "G78": {
                return GpuType.MALI_G78;
            }
            case "G78AE": {
                return GpuType.MALI_G78AE;
            }
            case "G310": {
                return GpuType.MALI_G310;
            }
            case "G510": {
                return GpuType.MALI_G510;
            }
            case "G610": {
                return GpuType.MALI_G610;
            }
            case "G710": {
                return GpuType.MALI_G710;
            }
            case "G615": {
                return GpuType.MALI_G615;
            }
            case "G620": {
                return GpuType.MALI_G620;
            }
            case "G625": {
                return GpuType.MALI_G625;
            }
            case "G715": {
                return GpuType.MALI_G715;
            }
            case "Immortalis-G715": {
                return GpuType.IMMORTALIS_G715;
            }
            case "G720": {
                return GpuType.MALI_G720;
            }
            case "Immortalis-G720": {
                return GpuType.IMMORTALIS_G720;
            }
            case "G725": {
                return GpuType.MALI_G725;
            }
            case "G925": 
            case "Immortalis-G925": {
                return GpuType.IMMORTALIS_G925;
            }
            case "G1-Premium": {
                return GpuType.MALI_G1_Premium;
            }
            case "G1-Pro": {
                return GpuType.MALI_G1_Pro;
            }
            case "G1-Ultra": {
                return GpuType.MALI_G1_Ultra;
            }
            case "TMIx": {
                return GpuType.MALI_G71;
            }
            case "THEx": {
                return GpuType.MALI_G72;
            }
            case "TDVx": {
                return GpuType.MALI_G31;
            }
            case "TSIx": {
                return GpuType.MALI_G51;
            }
            case "TGOx": {
                return GpuType.MALI_G52;
            }
            case "TNOx": {
                return GpuType.MALI_G76;
            }
            case "TNAx": {
                return GpuType.MALI_G57;
            }
            case "TTRx": {
                return GpuType.MALI_G77;
            }
            case "TOTx": {
                return GpuType.MALI_G68;
            }
            case "TBOx": {
                return GpuType.MALI_G78;
            }
            case "TVIx": {
                return GpuType.MALI_G610;
            }
            case "TODx": {
                return GpuType.MALI_G710;
            }
            case "TTUx": {
                return GpuType.MALI_G715;
            }
            case "TTUx2": {
                return GpuType.MALI_G615;
            }
            case "T72x": {
                return GpuType.MALI_T720;
            }
            case "T76x": {
                return GpuType.MALI_T720;
            }
            case "T82x": {
                return GpuType.MALI_T820;
            }
            case "T83x": {
                return GpuType.MALI_T830;
            }
            case "T86x": {
                return GpuType.MALI_T860;
            }
            case "T88x": {
                return GpuType.MALI_T880;
            }
        }
        return GpuType.UNKNOWN;
    }

    private void setFamily() {
        switch (this.gpuType) {
            case MALI_T720: 
            case MALI_T760: 
            case MALI_T820: 
            case MALI_T830: 
            case MALI_T860: 
            case MALI_T880: {
                this.gpuFamily = GpuFamily.MIDGARD;
                break;
            }
            case MALI_G71: 
            case MALI_G72: 
            case MALI_G31: 
            case MALI_G51: 
            case MALI_G52: 
            case MALI_G76: {
                this.gpuFamily = GpuFamily.BIFROST;
                break;
            }
            case MALI_G57: 
            case MALI_G77: 
            case MALI_G68: 
            case MALI_G78: 
            case MALI_G78AE: {
                this.gpuFamily = GpuFamily.VALHALL_JM;
                break;
            }
            case MALI_G310: 
            case MALI_G510: 
            case MALI_G610: 
            case MALI_G710: {
                this.gpuFamily = GpuFamily.VALHALL_CSF;
                break;
            }
            case MALI_G615: 
            case MALI_G715: 
            case IMMORTALIS_G715: {
                this.gpuFamily = GpuFamily.VALHALL_RTU;
                break;
            }
            case MALI_G620: 
            case MALI_G720: 
            case IMMORTALIS_G720: 
            case MALI_G625: 
            case MALI_G725: 
            case IMMORTALIS_G925: 
            case MALI_G1_Premium: 
            case MALI_G1_Pro: 
            case MALI_G1_Ultra: {
                this.gpuFamily = GpuFamily.GEN5;
                break;
            }
            case UNKNOWN: {
                this.gpuFamily = GpuFamily.UNKNOWN;
                break;
            }
            default: {
                throw new LogicError("Could not set GPU family for type " + this.gpuType.toString());
            }
        }
    }

    @Override
    public void execute() {
    }

    public GpuFamily getFamily() {
        return this.gpuFamily;
    }

    public GpuType getType() {
        return this.gpuType;
    }

    public String getPrettyType() {
        return this.gpuType.getPrettyName();
    }

    public OptionalInt getShaderCoreCount() {
        return this.shaderCoreCount;
    }

    public static enum GpuFamily {
        UNKNOWN,
        MIDGARD,
        BIFROST,
        VALHALL_JM,
        VALHALL_CSF,
        VALHALL_RTU,
        GEN5;

    }

    public static enum GpuType {
        UNKNOWN("Unknown"),
        MALI_T720("Mali-T720"),
        MALI_T760("Mali-T760"),
        MALI_T820("Mali-T820"),
        MALI_T830("Mali-T830"),
        MALI_T860("Mali-T860"),
        MALI_T880("Mali-T880"),
        MALI_G71("Mali-G71"),
        MALI_G72("Mali-G72"),
        MALI_G31("Mali-G31"),
        MALI_G51("Mali-G51"),
        MALI_G52("Mali-G52"),
        MALI_G76("Mali-G76"),
        MALI_G57("Mali-G57"),
        MALI_G77("Mali-G77"),
        MALI_G68("Mali-G68"),
        MALI_G78("Mali-G78"),
        MALI_G78AE("Mali-G78AE"),
        MALI_G310("Mali-G310"),
        MALI_G510("Mali-G510"),
        MALI_G610("Mali-G610"),
        MALI_G710("Mali-G710"),
        MALI_G615("Mali-G615"),
        MALI_G715("Mali-G715"),
        IMMORTALIS_G715("Immortalis-G715"),
        MALI_G620("Mali-G620"),
        MALI_G720("Mali-G720"),
        IMMORTALIS_G720("Immortalis-G720"),
        MALI_G625("Mali-G625"),
        MALI_G725("Mali-G725"),
        IMMORTALIS_G925("Immortalis-G925"),
        MALI_G1_Premium("Mali G1-Premium"),
        MALI_G1_Pro("Mali G1-Pro"),
        MALI_G1_Ultra("Mali G1-Ultra");

        private @NonNull String prettyName;

        private GpuType(String prettyName) {
            this.prettyName = prettyName;
        }

        public @NonNull String getPrettyName() {
            return this.prettyName;
        }
    }
}

