/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.Frame;
import com.arm.streamline.performanceadvisor.capturedata.FrameProvider;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.common.TargetFrameRate;
import com.arm.streamline.performanceadvisor.counterseries.FrameMetricSeries;
import java.util.ArrayList;
import java.util.List;

public class FpsProvider
extends Provider {
    private FrameProvider frameProvider;
    private FrameMetricSeries perFrame;
    private FrameMetricSeries perBin;
    private static final double MS_PER_SECOND = 1000.0;
    private static final int WINDOW_EXTENTS = 5;
    private TargetFrameRate targetFrameRate;

    public FpsProvider(CaptureData captureData, TargetFrameRate vsync) {
        super(captureData);
        this.frameProvider = captureData.getFrameProvider();
        this.targetFrameRate = vsync;
    }

    @Override
    public ProblemList initialise() {
        return new ProblemList();
    }

    @Override
    public void execute() {
        List<Frame> frames = this.frameProvider.getFrames();
        this.perFrame = this.calculatePerFrameFpsValues(frames);
        assert (this.perFrame.getLength() == frames.size());
        this.perBin = this.calculatePerBinFpsValues(frames, this.captureData.getBinCount());
        assert (this.perBin.getLength() == this.captureData.getBinCount());
    }

    public FrameMetricSeries getPerFrame() {
        return this.perFrame;
    }

    public FrameMetricSeries getPerBin() {
        return this.perBin;
    }

    private FrameMetricSeries calculatePerBinFpsValues(List<Frame> frames, int numBins) {
        int numFrames = frames.size();
        assert (numFrames > 0);
        double[] fps = new double[numBins];
        int firstFrameStart = frames.get(0).getStart();
        int i = 0;
        while (i < firstFrameStart) {
            fps[i] = 0.0;
            ++i;
        }
        int binIndex = firstFrameStart;
        int frameIdx = 0;
        for (Frame f : frames) {
            double length = f.getDrawTime();
            double fpsStart = this.perFrame.getFpsAt(frameIdx);
            double fpsEnd = this.perFrame.getFpsAt(frameIdx + 1);
            double fpsDelta = (fpsEnd - fpsStart) / length;
            double minimumFps = 1.0E-4;
            if (fpsStart < minimumFps || fpsEnd < minimumFps) {
                fpsDelta = 0.0;
            }
            int i2 = 0;
            while ((double)i2 < length) {
                fps[binIndex + i2] = fpsStart + (double)i2 * fpsDelta;
                ++i2;
            }
            binIndex = (int)((double)binIndex + length);
            ++frameIdx;
        }
        int i3 = binIndex;
        while (i3 < numBins) {
            fps[i3] = 0.0;
            ++i3;
        }
        return new FrameMetricSeries("Interpolated FPS", fps, this.targetFrameRate.getDisplayAsFrameTime());
    }

    private FrameMetricSeries calculatePerFrameFpsValues(List<Frame> frames) {
        double frameRate;
        String seriesName = "Frames Per Second Per Frame";
        double accumulator = 0.0;
        int windowSize = this.getWindowSize();
        if (windowSize >= frames.size() / 2) {
            return new FrameMetricSeries(seriesName, frames.stream().mapToDouble(f -> 1000.0 / f.getScreenTime()).toArray(), this.targetFrameRate.getDisplayAsFrameTime());
        }
        int i = 0;
        while (i < windowSize) {
            double frameRate2 = 1000.0 / frames.get(i).getScreenTime();
            accumulator += frameRate2;
            ++i;
        }
        ArrayList<Double> fps = new ArrayList<Double>();
        i = windowSize;
        while (i < frames.size() - 1) {
            frameRate = 1000.0 / frames.get(i).getScreenTime();
            accumulator -= 1000.0 / frames.get(i - windowSize).getScreenTime();
            fps.add((accumulator += frameRate) / (double)windowSize);
            ++i;
        }
        frameRate = 1000.0 / frames.get(i).getScreenTime();
        accumulator -= 1000.0 / frames.get(i - windowSize).getScreenTime();
        double lastFps = (accumulator += frameRate) / (double)windowSize;
        if (lastFps < (Double)fps.get(i - 1 - windowSize)) {
            fps.add(lastFps);
        } else {
            fps.add((Double)fps.get(i - 1 - windowSize));
        }
        accumulator = 0.0;
        i = 0;
        while (i < windowSize) {
            accumulator += ((Double)fps.get(i)).doubleValue();
            ++i;
        }
        i = windowSize - 1;
        while (i >= 0) {
            frameRate = 1000.0 / frames.get(i).getScreenTime();
            accumulator -= 1000.0 / frames.get(i + windowSize).getScreenTime();
            fps.add(0, (accumulator += frameRate) / (double)windowSize);
            --i;
        }
        return new FrameMetricSeries(seriesName, fps.stream().mapToDouble(Double::doubleValue).toArray(), this.targetFrameRate.getDisplayAsFrameTime());
    }

    public int getWindowSize() {
        return 5;
    }

    public TargetFrameRate getTargetFrameRate() {
        return this.targetFrameRate;
    }
}

