/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.CpuClusterProcessor;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.common.ResourceProblem;
import com.arm.streamline.performanceadvisor.common.VectorUtils;
import com.arm.streamline.performanceadvisor.counterseries.ArraySeries;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import com.arm.streamline.performanceadvisor.counterseries.EmptySeries;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class CpuCyclesProcessor {
    static final String SERIES_NAME = "CPU usage";
    CaptureData captureData;
    List<CpuClusterProcessor> clusters = new ArrayList<CpuClusterProcessor>();
    ProblemList problemList = new ProblemList();
    private ProcessedSeries cyclesSeries;
    private ProcessedSeries criticalSeries;
    private ProcessedSeries averageUtilSeries;
    private boolean executed;

    public void executeOnce() {
        if (this.executed) {
            return;
        }
        this.executed = true;
        double[] criticalUsage = new double[this.captureData.getBinCount()];
        double[] cyclesAggregate = new double[this.captureData.getBinCount()];
        double[] averageUsage = new double[this.captureData.getBinCount()];
        boolean allCyclesPresent = true;
        for (CpuClusterProcessor cluster : this.clusters) {
            Optional<double[]> clusterCritical = cluster.getCriticalUtilisation();
            if (clusterCritical.isPresent()) {
                criticalUsage = VectorUtils.max(clusterCritical.get(), criticalUsage);
            }
            Optional<double[]> clusterAccumulate = cluster.getCyclesAccumulate();
            Optional<double[]> clusterFrequencies = cluster.getCycleFrequencies();
            if (clusterAccumulate.isPresent() && allCyclesPresent) {
                cyclesAggregate = VectorUtils.add(cyclesAggregate, clusterAccumulate.get());
            } else {
                allCyclesPresent = false;
            }
            if (clusterFrequencies.isPresent()) {
                double[] clusterAverage = VectorUtils.divZeroNan(clusterFrequencies.get(), cluster.getPredictedClockspeed() * (double)cluster.getCoreCount());
                averageUsage = VectorUtils.max(clusterAverage, averageUsage);
                continue;
            }
            Optional<double[]> avgActivity = cluster.getAvgActivity();
            if (!avgActivity.isPresent()) continue;
            averageUsage = VectorUtils.max(averageUsage, avgActivity.get());
        }
        this.criticalSeries.setContent(criticalUsage);
        this.averageUtilSeries.setContent(averageUsage);
        if (!allCyclesPresent) {
            Application.LOG.fine("CPU Cycles data was not populated due to partial or missing cycles data.");
            this.problemList.add(new ResourceProblem(ResourceProblem.Severity.WARNING, "CPU cycles data was not used.", "Cycles data is missing or unreliable. Use --force-cycles to force usage of this data."));
            return;
        }
        this.cyclesSeries.setContent(cyclesAggregate);
        Application.LOG.fine("CPU cycles data populated");
    }

    public ProblemList initialise(CaptureData captureData, boolean forceCycles) {
        this.captureData = captureData;
        this.criticalSeries = new ProcessedSeries(SERIES_NAME);
        this.cyclesSeries = new ProcessedSeries(SERIES_NAME);
        this.averageUtilSeries = new ProcessedSeries(SERIES_NAME);
        this.criticalSeries.initialise(captureData);
        this.cyclesSeries.initialise(captureData);
        this.averageUtilSeries.initialise(captureData);
        captureData.getChartList().stream().filter(c -> c.getTitle().contains("CPU Cycles")).forEach(d -> {
            boolean bl2 = this.clusters.add(new CpuClusterProcessor(captureData, (IChartDataProvider)d, forceCycles));
        });
        if (this.clusters.isEmpty()) {
            this.problemList.add(new ResourceProblem(ResourceProblem.Severity.ERROR, "Cannot find CPU cycles counter", "Please refer to the user guide for methods of getting CPU cycles"));
        }
        return this.problemList;
    }

    public CounterSeries getAggregateCycles() {
        if (this.cyclesSeries.isPresent()) {
            return this.cyclesSeries;
        }
        return new EmptySeries();
    }

    public CounterSeries getCriticalUsage() {
        return this.criticalSeries;
    }

    public CounterSeries getAverageUsage() {
        return this.averageUtilSeries;
    }

    private class ProcessedSeries
    extends ArraySeries {
        private boolean present;

        public ProcessedSeries(String name) {
            super(name);
            this.present = false;
        }

        @Override
        public double[] toArray() {
            CpuCyclesProcessor.this.executeOnce();
            return super.toArray();
        }

        @Override
        public boolean isPresent() {
            CpuCyclesProcessor.this.executeOnce();
            return this.present;
        }

        @Override
        public void setContent(double[] data) {
            super.setContent(data);
            this.present = true;
        }
    }
}

