/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.performanceadvisor.capturedata.ClipIndicator;
import com.arm.streamline.performanceadvisor.capturedata.ClipIndicatorParseException;
import com.arm.streamline.performanceadvisor.capturedata.FrameClipIndicator;
import com.arm.streamline.performanceadvisor.capturedata.RegionClipIndicator;
import com.arm.streamline.performanceadvisor.capturedata.TimeClipIndicator;

public class ClipIndicatorParser {
    private ClipIndicatorParser() {
        throw new IllegalStateException("ClipIndicatorParser should not be instantiated");
    }

    public static ClipIndicator parse(String str) throws ClipIndicatorParseException {
        if (str.contains(":")) {
            return ClipIndicatorParser.parseRegion(str);
        }
        if (str.charAt(str.length() - 1) == 'f') {
            return ClipIndicatorParser.parseFrame(str.substring(0, str.length() - 1));
        }
        return ClipIndicatorParser.parseTimestamp(str);
    }

    private static ClipIndicator parseFrame(String str) throws ClipIndicatorParseException {
        int i = ClipIndicatorParser.parseInt(str, 1);
        return new FrameClipIndicator(i);
    }

    private static ClipIndicator parseRegion(String str) throws ClipIndicatorParseException {
        int colonIndex = str.lastIndexOf(58);
        String regionName = str.substring(0, colonIndex);
        String startOrEndStr = str.substring(colonIndex + 1);
        if (!startOrEndStr.equals("start") && !startOrEndStr.equals("end")) {
            throw new ClipIndicatorParseException();
        }
        boolean isStart = startOrEndStr.equals("start");
        return new RegionClipIndicator(regionName, isStart);
    }

    private static ClipIndicator parseTimestamp(String str) throws ClipIndicatorParseException {
        int i = ClipIndicatorParser.parseInt(str, 0);
        return new TimeClipIndicator(i);
    }

    private static int parseInt(String str, int minIntValue) throws ClipIndicatorParseException {
        try {
            int i = Integer.parseInt(str);
            if (i < minIntValue) {
                throw new NumberFormatException();
            }
            return i;
        }
        catch (NumberFormatException e) {
            throw new ClipIndicatorParseException();
        }
    }
}

