/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.pa.StreamlineDataRepository;
import gnu.trove.set.TIntSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CachedDataSource
implements ISeriesDataProvider {
    private StreamlineDataRepository cache;
    private ISeriesDataProvider dataProvider;

    public CachedDataSource(ISeriesDataProvider dataProvider, StreamlineDataRepository cache) {
        this.cache = cache;
        this.dataProvider = dataProvider;
    }

    @Override
    public double[] getData(int start, int end, @Nullable TIntSet filteredThreadUids) {
        double[] result = filteredThreadUids == null ? this.cache.getData(this.dataProvider, start, end) : this.dataProvider.getData(start, end, filteredThreadUids);
        return result;
    }

    @Override
    public double[] getData(@NonNull ProcessingElementReference channel, int start, int end, @Nullable TIntSet filteredThreadUids) {
        return this.dataProvider.getData(channel, start, end, filteredThreadUids);
    }

    @Override
    public String getName() {
        return this.dataProvider.getName();
    }

    @Override
    public IChartDataProvider getChart() {
        return this.dataProvider.getChart();
    }

    @Override
    public double getAggregateLimit() {
        return this.dataProvider.getAggregateLimit();
    }

    @Override
    public double getAggregateValueOfRangeFromDensestLevel(int start, int end, @Nullable TIntSet filteredThreadUids) {
        return this.dataProvider.getAggregateValueOfRangeFromDensestLevel(start, end, filteredThreadUids);
    }

    @Override
    public @NonNull IBinDataProvider getBinData(@NonNull String source) {
        return this.dataProvider.getBinData(source);
    }

    @Override
    public @NonNull SeriesConfig getConfig() {
        return this.dataProvider.getConfig();
    }

    @Override
    public @NonNull ISeriesDataProvider.ISeriesCoreInformationProvider getCoreInformationProvider() {
        return this.dataProvider.getCoreInformationProvider();
    }

    @Override
    public double getCoreLimit() {
        return this.dataProvider.getCoreLimit();
    }

    @Override
    public double getCoreValueOfRangeFromDensestLevel(@NonNull ProcessingElementReference channel, int start, int end, @Nullable TIntSet filteredThreadUids) {
        return this.dataProvider.getCoreValueOfRangeFromDensestLevel(channel, start, end, filteredThreadUids);
    }

    @Override
    public String getDescription() {
        return this.dataProvider.getDescription();
    }

    @Override
    public @NonNull Set<@NonNull String> getSources() {
        return this.dataProvider.getSources();
    }

    @Override
    public String getWarning() {
        return this.dataProvider.getWarning();
    }

    @Override
    public ISeriesDataProvider.WarningSource getWarningSource() {
        return this.dataProvider.getWarningSource();
    }

    @Override
    public void initializeLimits() {
        this.dataProvider.initializeLimits();
    }

    @Override
    public boolean isAverageSelectionPossible() {
        return this.dataProvider.isAverageSelectionPossible();
    }

    @Override
    public boolean isDataHiddenDueToEfficientFtrace() {
        return this.dataProvider.isDataHiddenDueToEfficientFtrace();
    }

    @Override
    public boolean isFilterable() {
        return this.dataProvider.isFilterable();
    }

    @Override
    public void refreshWarnings() {
        this.dataProvider.refreshWarnings();
    }
}

