/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.Boundness;
import com.arm.streamline.performanceadvisor.capturedata.BoundnessType;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.CpuProvider;
import com.arm.streamline.performanceadvisor.capturedata.FpsProvider;
import com.arm.streamline.performanceadvisor.capturedata.Frame;
import com.arm.streamline.performanceadvisor.capturedata.FrameProvider;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.capturedata.Region;
import com.arm.streamline.performanceadvisor.capturedata.gpuprovider.GpuProvider;
import com.arm.streamline.performanceadvisor.common.LogUtils;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.counterseries.BoundnessLabelledDoubleArray;
import com.arm.streamline.performanceadvisor.section.BoundnessRegion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class BoundnessProvider
extends Provider {
    private CpuProvider cpuProvider;
    private GpuProvider gpuProvider;
    private FrameProvider frameProvider;
    private FpsProvider fpsProvider;
    private Boundness[] frameBoundnessPerMsBin;
    private static final double MAGIC_CONFIDENCE_THRESHOLD = 6.0;

    public BoundnessProvider(CaptureData captureData) {
        super(captureData);
    }

    @Override
    public ProblemList initialise() {
        this.cpuProvider = this.captureData.getCpuProvider();
        this.gpuProvider = this.captureData.getGpuProvider();
        this.frameProvider = this.captureData.getFrameProvider();
        this.fpsProvider = this.captureData.getFpsProvider();
        return new ProblemList();
    }

    @Override
    public void execute() {
        List<Double> cpuGpuDiffSum;
        Application.LOG.fine("BoundnessProvider.execute()");
        double[] gpuUsage = this.gpuProvider.getUtilisation().toArray();
        List<BoundnessLabelledDoubleArray> queueUsages = this.gpuProvider.getLabelledQueueUtils();
        if (Application.LOG.isLoggable(Level.FINE)) {
            LogUtils.seriesStats(gpuUsage, "GPU usage provider (usage)");
        }
        int numFrames = this.frameProvider.getNumFrames();
        Application.LOG.fine(() -> String.format("Frame provider reports %d frames", numFrames));
        double[] fps = this.fpsProvider.getPerFrame().toArray();
        Application.LOG.fine(() -> String.format("FPS provider returned %d FPS values", fps.length));
        assert (fps.length == numFrames);
        if (Application.LOG.isLoggable(Level.FINEST)) {
            int i = 0;
            while (i < numFrames) {
                long startIdx = this.frameProvider.getStartIndex(i);
                long endIdx = this.frameProvider.getEndIndex(i);
                Application.LOG.finest(String.format("Frame %d: %d - %d", i, startIdx, endIdx));
                ++i;
            }
        }
        if (this.cpuProvider.getCriticalUsage().isPresent()) {
            Application.LOG.fine("Using CPU critical usage for boundness calculations.");
            double[] criticalUsage = this.cpuProvider.getCriticalUsage().toArray();
            cpuGpuDiffSum = this.twoVariableFrameDiff(criticalUsage, gpuUsage);
        } else {
            Application.LOG.fine("Using aggregate CPU usage for boundness calculations.");
            double[] cpuUsage = this.cpuProvider.getUsage().toArray();
            cpuGpuDiffSum = this.twoVariableFrameDiff(cpuUsage, gpuUsage);
        }
        assert (cpuGpuDiffSum.size() == numFrames);
        List<Boundness> gpuQueueBoundness = this.getGpuQueueBoundness(queueUsages);
        assert (gpuQueueBoundness.size() == numFrames);
        List<Boundness> frameBoundness = this.assignBoundnessToFrames(fps, cpuGpuDiffSum, gpuQueueBoundness);
        assert (frameBoundness.size() == numFrames);
        this.frameBoundnessPerMsBin = this.makePerMsBinBoundnessArray(frameBoundness);
    }

    private List<Boundness> getGpuQueueBoundness(List<BoundnessLabelledDoubleArray> queueUsages) {
        int numFrames = this.frameProvider.getNumFrames();
        ArrayList<Boundness> boundness = new ArrayList<Boundness>(numFrames);
        int sampleLimit = Integer.MAX_VALUE;
        for (BoundnessLabelledDoubleArray queueUsage : queueUsages) {
            int seriesLength = queueUsage.getArray().length;
            if (seriesLength >= sampleLimit) continue;
            sampleLimit = seriesLength;
        }
        int i = 0;
        while (i < numFrames) {
            int startIdx = this.frameProvider.getStartIndex(i);
            int endIdx = this.frameProvider.getEndIndex(i);
            ArrayList<Double> totals = new ArrayList<Double>();
            int j = 0;
            while (j < queueUsages.size()) {
                totals.add(0.0);
                ++j;
            }
            j = startIdx;
            while (j <= endIdx && j < sampleLimit) {
                int k = 0;
                while (k < totals.size()) {
                    totals.set(k, (Double)totals.get(k) + queueUsages.get(k).getArray()[j]);
                    ++k;
                }
                ++j;
            }
            double maxValue = -1.0;
            int maxIndex = -1;
            int a = 0;
            while (a < totals.size()) {
                if ((Double)totals.get(a) > maxValue) {
                    maxValue = (Double)totals.get(a);
                    maxIndex = a;
                }
                ++a;
            }
            totals.sort(Comparator.naturalOrder());
            double confidence = (Double)totals.get(totals.size() - 1) - (Double)totals.get(totals.size() - 2);
            boundness.add(new Boundness(queueUsages.get(maxIndex).getBoundnessType(), confidence));
            ++i;
        }
        return boundness;
    }

    private List<Boundness> assignBoundnessToFrames(double[] fps, List<Double> cpuGpuDiffSum, List<Boundness> gpuQueueBoundnesses) {
        int numFrames = this.frameProvider.getNumFrames();
        double idealFps = this.captureData.getTargetFrameRate().getAsFps();
        double fpsThreshold = idealFps * 0.95;
        ArrayList<Boundness> frameBoundness = new ArrayList<Boundness>(numFrames);
        int i = 0;
        while (i < numFrames) {
            Double cpuGpu = cpuGpuDiffSum.get(i);
            Boundness gpuQueueBoundness = gpuQueueBoundnesses.get(i);
            Boundness boundness = BoundnessProvider.determineBoundness(fps[i], fpsThreshold, cpuGpu, gpuQueueBoundness);
            if (Application.LOG.isLoggable(Level.FINEST)) {
                Application.LOG.finest(String.format("Frame %d: fps %f, cpuGpu %f: %s", i, fps[i], cpuGpu, boundness.toString()));
            }
            frameBoundness.add(boundness);
            ++i;
        }
        return frameBoundness;
    }

    private static Boundness determineBoundness(double fps, double threshold, double cpuGpu, Boundness gpuQueueBoundness) {
        Boundness result = fps > threshold ? new Boundness(BoundnessType.VSYNC, 100.0) : (cpuGpu > 0.0 ? new Boundness(BoundnessType.CPU, cpuGpu) : gpuQueueBoundness);
        if (result.getConfidence() < 6.0) {
            result = new Boundness(BoundnessType.UNKNOWN, result.getConfidence());
        }
        return result;
    }

    private Boundness[] makePerMsBinBoundnessArray(List<Boundness> frameBoundness) {
        Object[] boundness = new Boundness[this.captureData.getBinCount()];
        Arrays.fill(boundness, new Boundness(BoundnessType.UNKNOWN, 100.0));
        int binIndex = this.frameProvider.getFirstFrame().getStart();
        int frameIdx = 0;
        for (Frame f : this.frameProvider.getFrames()) {
            double length = f.getDrawTime();
            int i = 0;
            while ((double)i < length) {
                boundness[binIndex + i] = frameBoundness.get(frameIdx);
                ++i;
            }
            binIndex = (int)((double)binIndex + length);
            if (++frameIdx >= frameBoundness.size()) break;
        }
        return boundness;
    }

    public Boundness getBoundnessForBinIndex(int i) {
        return this.frameBoundnessPerMsBin[i];
    }

    private List<Double> twoVariableFrameDiff(double[] first, double[] second) {
        int numFrames = this.frameProvider.getNumFrames();
        ArrayList<Double> boundness = new ArrayList<Double>(numFrames);
        int sampleLimit = Math.min(first.length, second.length);
        int i = 0;
        while (i < numFrames) {
            int startIdx = this.frameProvider.getStartIndex(i);
            int endIdx = this.frameProvider.getEndIndex(i);
            double sum = 0.0;
            int j = startIdx;
            while (j <= endIdx && j < sampleLimit) {
                sum += first[j] - second[j];
                ++j;
            }
            boundness.add(sum);
            ++i;
        }
        return boundness;
    }

    public List<BoundnessRegion> getBoundnessRegions(int startBin, int endBin) {
        ArrayList<BoundnessRegion> regions = new ArrayList<BoundnessRegion>();
        int boundnessRegionStart = startBin;
        --endBin;
        BoundnessType currentBoundness = this.getBoundnessForBinIndex(startBin).getBoundnessType();
        int i = startBin;
        while (i < endBin) {
            BoundnessType nextBoundness;
            currentBoundness = this.getBoundnessForBinIndex(i).getBoundnessType();
            if (currentBoundness != (nextBoundness = this.getBoundnessForBinIndex(i + 1).getBoundnessType())) {
                regions.add(new BoundnessRegion(boundnessRegionStart, (double)i + 1.0, currentBoundness));
                boundnessRegionStart = i + 1;
            }
            ++i;
        }
        if (currentBoundness != this.getBoundnessForBinIndex(endBin).getBoundnessType()) {
            regions.add(new BoundnessRegion(boundnessRegionStart, endBin, this.getBoundnessForBinIndex(endBin).getBoundnessType()));
        } else {
            regions.add(new BoundnessRegion(boundnessRegionStart, endBin, currentBoundness));
        }
        return regions;
    }

    public LinkedHashMap<BoundnessType, Double> getBoundnessPercentageSplitForRegion(Region region) {
        LinkedHashMap<BoundnessType, Double> result = new LinkedHashMap<BoundnessType, Double>();
        for (BoundnessType type : this.gpuProvider.getBoundnessTypes()) {
            result.put(type, 0.0);
        }
        int i = region.getStart();
        while (i < region.getEnd()) {
            Boundness boundness = this.getBoundnessForBinIndex(i);
            BoundnessType type = boundness.getBoundnessType();
            double newValue = result.getOrDefault((Object)type, 0.0) + 1.0;
            result.put(type, newValue);
            ++i;
        }
        double total = (double)region.getEnd() - (double)region.getStart();
        if (total > 0.0) {
            double scale = 100.0 / total;
            for (Map.Entry<BoundnessType, Double> entry : result.entrySet()) {
                BoundnessType type = entry.getKey();
                double value = entry.getValue();
                result.put(type, value * scale);
            }
        }
        return result;
    }
}

