/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.analyser;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.analyser.Analyser;
import com.arm.streamline.performanceadvisor.analyser.BinnedDataPerFrame;
import com.arm.streamline.performanceadvisor.analyser.PerFrameChartData;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.ClippedRegionsProvider;
import com.arm.streamline.performanceadvisor.capturedata.FpsProvider;
import com.arm.streamline.performanceadvisor.capturedata.Frame;
import com.arm.streamline.performanceadvisor.capturedata.Region;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.counterseries.CounterDescriptor;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import com.arm.streamline.performanceadvisor.counterseries.StreamlineSeries;
import com.arm.streamline.performanceadvisor.report.ReportConfig;
import com.arm.streamline.performanceadvisor.section.Element;
import com.arm.streamline.performanceadvisor.section.PartialColumnList;
import com.arm.streamline.performanceadvisor.section.Section;
import com.arm.streamline.performanceadvisor.section.TextBlock;
import com.arm.streamline.performanceadvisor.section.TextStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;

public abstract class StandardPerFrameAnalyser
extends Analyser {
    private Optional<Double> threshold;
    private ClippedRegionsProvider clippedRegionsProvider;
    private List<CounterSeries> dataSeries;

    public StandardPerFrameAnalyser(CaptureData captureData, Optional<Double> threshold) {
        super(captureData);
        this.threshold = threshold;
        this.clippedRegionsProvider = captureData.getClippedRegionsProvider();
        this.dataSeries = new ArrayList<CounterSeries>();
    }

    public abstract String getTitle();

    public abstract String getHelpText();

    public abstract String getId();

    public abstract String getYAxisLabel();

    public List<Element> getAdvice(PerFrameChartData data, int userRegion) {
        return Collections.emptyList();
    }

    public final void addSeries(CounterSeries source) {
        this.dataSeries.add(source);
    }

    public final void addSeries(CounterDescriptor descriptor) {
        this.dataSeries.add(new StreamlineSeries(descriptor));
    }

    public final void addAllSeries(List<CounterSeries> sourceList) {
        this.dataSeries.addAll(sourceList);
    }

    public boolean dataIsPresent() {
        if (this.dataSeries.isEmpty()) {
            return false;
        }
        for (CounterSeries i : this.dataSeries) {
            if (i.isPresent()) continue;
            return false;
        }
        return true;
    }

    public int getStartIndex(int userRegion) {
        return this.clippedRegionsProvider.getClippedRegion(userRegion).getStart();
    }

    public int getEndIndex(int userRegion) {
        return this.clippedRegionsProvider.getClippedRegion(userRegion).getEnd();
    }

    @Override
    public ProblemList initialise() {
        if (this.threshold.isPresent()) {
            Double thresholdValue = this.threshold.get();
            Application.LOG.fine(() -> String.format("%s: budget threshold was set to %f%n", this.name(), thresholdValue));
        }
        ProblemList problemList = new ProblemList();
        Iterator<CounterSeries> itr = this.dataSeries.iterator();
        while (itr.hasNext()) {
            CounterSeries i = itr.next();
            problemList.addAll(i.initialise(this.captureData));
            if (!i.doNotShowIfAllZeroes() || !i.isAllZeroes()) continue;
            itr.remove();
        }
        if (!this.dataIsPresent()) {
            this.disableExecute();
        }
        return problemList;
    }

    @Override
    public Section execute(int userRegion) {
        if (!this.isEnabled()) {
            Application.LOG.fine(() -> this.name() + ": analyser is disabled");
            return new Section();
        }
        int startIndex = this.getStartIndex(userRegion);
        int endIndex = this.getEndIndex(userRegion);
        Application.LOG.finest(() -> String.format("Region %d start is at index %d", userRegion, startIndex));
        Application.LOG.finest(() -> String.format("Region %d end is at index %d", userRegion, endIndex));
        assert (startIndex >= 0);
        assert (endIndex <= this.captureData.getBinCount());
        Section sectionToReturn = null;
        @NonNull ReportConfig reportConfig = this.captureData.getOptions().getReportConfig();
        List<Frame> frames = this.captureData.getFrameProvider().getFrames();
        if (reportConfig.isCsvReportEnabled()) {
            sectionToReturn = this.handleCsvReport(frames, startIndex, endIndex, reportConfig.getWindowSize());
        } else {
            FpsProvider fpsProvider = this.captureData.getFpsProvider();
            double[] fpsData = fpsProvider.getPerBin().toArray(startIndex, endIndex);
            assert (fpsData.length == endIndex - startIndex);
            int binSize = this.captureData.getPerFrameBinSizeMs();
            int samplesPerSecond = this.captureData.getSamplesPerSecond();
            Region region = this.clippedRegionsProvider.getClippedRegion(userRegion);
            boolean enableFpsScaling = !this.hasPerFrameComponentSeries();
            List<Frame> framesToProcess = StandardPerFrameAnalyser.filterFramesToProcess(frames, startIndex, endIndex);
            PerFrameChartData chartData = new PerFrameChartData(binSize, samplesPerSecond, fpsProvider.getPerBin(), startIndex, endIndex, enableFpsScaling, region.getName(), framesToProcess.size());
            String unitsName = this.getYAxisLabel();
            chartData.setUnitsName(unitsName);
            chartData.setThreshold(this.threshold, unitsName + " budget");
            for (CounterSeries eachSeries : this.dataSeries) {
                List<double[]> dataList = StandardPerFrameAnalyser.getDataPerFrameFromSeries(framesToProcess, eachSeries);
                chartData.addSeries(eachSeries, startIndex, endIndex, dataList);
            }
            ArrayList<Element> elements = new ArrayList<Element>();
            elements.add(new TextBlock(TextStyle.H3_HIDDEN, this.getTitle(), this.getHelpText()));
            if (this.getTitle().contains("thermal")) {
                chartData.setToNeedStreamlineColours();
            }
            elements.addAll(this.getAdvice(chartData, userRegion));
            elements.add(chartData.getChart());
            sectionToReturn = userRegion != 0 ? new Section(this.getId(), elements, region.getName()) : new Section(this.getId(), elements);
        }
        return sectionToReturn;
    }

    private @NonNull Section handleCsvReport(@NonNull List<@NonNull Frame> frames, int startIndex, int endIndex, int windowSize) {
        @NonNull BinnedDataPerFrame binnedDataPerFrame = new BinnedDataPerFrame(frames, startIndex, endIndex, windowSize);
        @NonNull List<@NonNull Frame> framesToProcess = binnedDataPerFrame.getFramesToProcess();
        for (CounterSeries eachSeries : this.dataSeries) {
            @NonNull List<double[]> dataList = StandardPerFrameAnalyser.getDataPerFrameFromSeries(framesToProcess, eachSeries);
            binnedDataPerFrame.addSeriesData(eachSeries.getName(), dataList);
        }
        @NonNull PartialColumnList partialColumnList = binnedDataPerFrame.doBinningPerFrame(this.getTitle());
        @NonNull ArrayList<@NonNull Element> elements = new ArrayList<Element>();
        elements.add(partialColumnList);
        return new Section(this.getId(), elements);
    }

    private static @NonNull List<@NonNull Frame> filterFramesToProcess(@NonNull List<@NonNull Frame> frames, int startIndex, int endIndex) throws LogicError {
        if (startIndex < 0) {
            throw new LogicError("startIndex : " + startIndex + " must be a greater than or equal to 0 ");
        }
        if (endIndex < 0) {
            throw new LogicError("endIndex : " + endIndex + " must be a greater than or equal to 0 ");
        }
        if (startIndex > endIndex) {
            throw new LogicError("startIndex : " + startIndex + " must be less than the endIndex : " + endIndex);
        }
        if (startIndex == endIndex) {
            throw new LogicError("startIndex : " + startIndex + " cannot be same as the endIndex : " + endIndex);
        }
        if (frames.isEmpty()) {
            throw new LogicError("Error: Input frame list is empty");
        }
        @NonNull ArrayList<@NonNull Frame> framesToProcess = new ArrayList<Frame>();
        for (Frame eachFrame : frames) {
            if (eachFrame.getStart() < startIndex || eachFrame.getEnd() > endIndex) continue;
            framesToProcess.add(eachFrame);
        }
        if (framesToProcess.isEmpty()) {
            StringBuffer message = new StringBuffer("Error: There are no frames to process that fall in the time range of [startIndex,endIndex) : [");
            message.append(startIndex + "," + endIndex + ") ");
            message.append("First frame starts at time : " + frames.getFirst().getStart());
            message.append(" Last frame ends at time : " + frames.getLast().getEnd());
            throw new LogicError(message.toString());
        }
        return Collections.unmodifiableList(framesToProcess);
    }

    private static @NonNull List<double[]> getDataPerFrameFromSeries(@NonNull List<@NonNull Frame> framesToProcess, CounterSeries eachSeries) {
        @NonNull ArrayList<double[]> dataList = new ArrayList<double[]>();
        for (Frame eachFrame : framesToProcess) {
            int start = eachFrame.getStart();
            int end = eachFrame.getEnd();
            double[] dataPerFrame = eachSeries.toArray(start, end);
            dataList.add(dataPerFrame);
        }
        return Collections.unmodifiableList(dataList);
    }

    private boolean hasPerFrameComponentSeries() {
        boolean isPerFrame = false;
        for (CounterSeries i : this.dataSeries) {
            if (!i.isPerFrame()) continue;
            isPerFrame = true;
            break;
        }
        return isPerFrame;
    }
}

