/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.analyser;

import com.arm.streamline.performanceadvisor.analyser.Analyser;
import com.arm.streamline.performanceadvisor.analyser.AnalyserFactory;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.section.BinFrameMapper;
import com.arm.streamline.performanceadvisor.section.Element;
import com.arm.streamline.performanceadvisor.section.Section;
import java.util.ArrayList;

public class FrameDisplayAnalyserFactory
extends AnalyserFactory {
    @Override
    public Analyser create(CaptureData captureData) {
        return new FrameDisplayAnalyser(captureData);
    }

    public class FrameDisplayAnalyser
    extends Analyser {
        public FrameDisplayAnalyser(CaptureData captureData) {
            super(captureData);
        }

        @Override
        public Section execute(int userRegion) {
            if (userRegion != 0) {
                throw new LogicError("Frame display is only for the overall capture");
            }
            ArrayList<Element> elements = new ArrayList<Element>();
            BinFrameMapper frameMapper = this.captureData.getBinFrameProvider().getBinFrameMapper();
            frameMapper.setExcludeFromJson(true);
            elements.add(frameMapper);
            return new Section("fpsBoundness", elements);
        }
    }
}

