/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.analyser;

import com.arm.streamline.performanceadvisor.analyser.StandardPerFrameAnalyser;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.CustomChartListProvider;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.report.SectionDefinition;

public class ChartAndSeriesPerFrameAnalyser
extends StandardPerFrameAnalyser {
    private SectionDefinition sectionDefn;
    private String chartName;
    private String units;
    private boolean chartPresent;
    private boolean chartAllowed;

    public ChartAndSeriesPerFrameAnalyser(CaptureData captureData, SectionDefinition sectionDefn) {
        super(captureData, sectionDefn.getThreshold());
        CustomChartListProvider chartListProvider = captureData.getCustomChartListProvider();
        this.sectionDefn = sectionDefn;
        this.chartName = sectionDefn.getChartName();
        this.chartPresent = captureData.chartIsPresent(this.chartName);
        this.chartAllowed = chartListProvider.isValidTitle(this.chartName);
        this.units = "";
        if (!this.chartPresent) {
            for (String chartAlias : sectionDefn.getChartAliases()) {
                if (!captureData.chartIsPresent(chartAlias)) continue;
                this.chartName = chartAlias;
                this.chartPresent = true;
                this.chartAllowed = chartListProvider.isValidTitle(chartAlias);
                break;
            }
        }
        if (this.chartAllowed) {
            this.addAllSeries(captureData.seriesForChart(this.chartName));
            this.units = captureData.unitsForChart(this.chartName);
        }
    }

    @Override
    public ProblemList initialise() {
        ProblemList problemList = new ProblemList();
        if (!this.chartAllowed) {
            problemList.addWarning("\"" + this.sectionDefn.getChartName() + "\" cannot be used in a custom report.", "Use --chart-list-output to list the supported charts.");
        } else if (!this.chartPresent) {
            problemList.addWarning("Could not find \"" + this.sectionDefn.getChartName() + "\" in capture.", "Ensure chart is in capture.");
        }
        problemList.addAll(super.initialise());
        return problemList;
    }

    @Override
    public String name() {
        return this.sectionDefn.getChartName();
    }

    @Override
    public String getId() {
        StringBuilder builder = new StringBuilder();
        boolean isWordBoundary = false;
        boolean isFirstAlphanumeric = true;
        char[] cArray = this.sectionDefn.getChartName().toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isSpaceChar(c)) {
                isWordBoundary = true;
            } else if (c == '/') {
                builder.append("Per");
                isWordBoundary = true;
            } else if (Character.isLetterOrDigit(c)) {
                if (isFirstAlphanumeric) {
                    c = Character.toLowerCase(c);
                    isFirstAlphanumeric = false;
                } else if (isWordBoundary) {
                    c = Character.toTitleCase(c);
                    isWordBoundary = false;
                }
                builder.append(c);
            }
            ++n2;
        }
        return builder.toString();
    }

    @Override
    public String getYAxisLabel() {
        return this.units;
    }

    @Override
    public String getTitle() {
        return this.sectionDefn.getTitle().orElse(this.generateTitle());
    }

    @Override
    public String getHelpText() {
        return this.sectionDefn.getDescription().orElse("");
    }

    private String generateTitle() {
        Object title = this.name();
        if (!((String)title).isEmpty()) {
            title = ((String)title).substring(0, 1).toUpperCase() + ((String)title).substring(1).toLowerCase() + " per frame";
        }
        title = ((String)title).replace(" / frame", "");
        title = ((String)title).replace("l2 ", "L2 ");
        title = ((String)title).replace("gpu ", "GPU ");
        title = ((String)title).replace("cpu ", "CPU ");
        title = ((String)title).replace("ee instructions", "EE instructions");
        title = ((String)title).replace("Mali core", "Mali Core");
        return title;
    }
}

