/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.analyser;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.Frame;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.section.PartialColumnList;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class BinnedDataPerFrame {
    private @NonNull List<@NonNull Frame> mFramesToProcess = new ArrayList<Frame>();
    private int mNumBins = 0;
    private int mStartFrameIndex = 0;
    private int mSlidingWindowSize = 0;
    private @NonNull List<@NonNull List<double @NonNull []>> mSeriesData = new ArrayList<List<double[]>>();
    private @NonNull List<@NonNull String> mNames = new ArrayList<String>();
    private @NonNull List<double[]> mPerFrameSeries = new ArrayList<double[]>();

    public BinnedDataPerFrame(@NonNull List<@NonNull Frame> frames, int startIndex, int endIndex, int windowSize) {
        this.mFramesToProcess = this.filterFramesToProcess(frames, startIndex, endIndex);
        this.mNumBins = this.mFramesToProcess.size();
        this.mSlidingWindowSize = this.validateWindowSize(windowSize);
        Application.LOG.fine(() -> String.format("Number of bins is %d", this.mNumBins));
    }

    public @NonNull List<@NonNull Frame> getFramesToProcess() {
        return Collections.unmodifiableList(this.mFramesToProcess);
    }

    public void addSeriesData(@NonNull String name, @NonNull List<double @NonNull []> dataList) throws LogicError {
        BinnedDataPerFrame.validateDataList(dataList);
        if (!this.mSeriesData.isEmpty()) {
            BinnedDataPerFrame.validateDataPerFrame(this.mSeriesData.getFirst(), dataList, name);
        }
        this.mSeriesData.add(dataList);
        this.mNames.add(name);
    }

    private static void validateDataPerFrame(@NonNull List<double[]> first, @NonNull List<double[]> second, @NonNull String nameOfSecondSeries) {
        if (first.size() != second.size()) {
            throw new LogicError(String.format("Error: For series %s data length (%d) differs from expected data length (%d)", nameOfSecondSeries, second.size(), first.size()));
        }
        int i = 0;
        while (i < first.size()) {
            int secondLen;
            int firstLen = first.get(i).length;
            if (firstLen != (secondLen = second.get(i).length)) {
                throw new LogicError(String.format("Error: For Series %s data length (%d) differs for (%d) frame from expected length (%d)", nameOfSecondSeries, secondLen, i, firstLen));
            }
            ++i;
        }
    }

    private static double[] applySlidingWindowAveraging(double[] data, int slidingWindowSize) {
        double accumulator = 0.0;
        @NonNull ArrayList<@NonNull Double> averaged = new ArrayList<Double>();
        int i = 0;
        while (i < slidingWindowSize) {
            accumulator += data[i];
            ++i;
        }
        i = slidingWindowSize;
        while (i < data.length) {
            accumulator -= data[i - slidingWindowSize];
            averaged.add((accumulator += data[i]) / (double)slidingWindowSize);
            ++i;
        }
        accumulator = 0.0;
        i = 0;
        while (i < slidingWindowSize) {
            accumulator += ((Double)averaged.get(i)).doubleValue();
            ++i;
        }
        i = slidingWindowSize - 1;
        while (i >= 0) {
            accumulator -= data[i + slidingWindowSize];
            averaged.add(0, (accumulator += data[i]) / (double)slidingWindowSize);
            --i;
        }
        return averaged.stream().mapToDouble(Double::doubleValue).toArray();
    }

    private @NonNull List<@NonNull Frame> filterFramesToProcess(@NonNull List<@NonNull Frame> frames, int startIndex, int endIndex) throws LogicError {
        BinnedDataPerFrame.validateIndices(startIndex, endIndex);
        if (frames.isEmpty()) {
            throw new LogicError("Error: Input frame list is empty");
        }
        this.mStartFrameIndex = 0;
        @NonNull ArrayList<@NonNull Frame> framesToProcess = new ArrayList<Frame>();
        for (Frame eachFrame : frames) {
            if (eachFrame.getStart() < startIndex) {
                ++this.mStartFrameIndex;
                continue;
            }
            if (eachFrame.getEnd() > endIndex) continue;
            framesToProcess.add(eachFrame);
        }
        if (framesToProcess.isEmpty()) {
            StringBuffer message = new StringBuffer("Error: There are no frames to process that fall in the time range of [startIndex,endIndex) : [");
            message.append(startIndex + "," + endIndex + ") ");
            message.append("First frame starts at time : " + frames.getFirst().getStart());
            message.append(" Last frame ends at time : " + frames.getLast().getEnd());
            throw new LogicError(message.toString());
        }
        return Collections.unmodifiableList(framesToProcess);
    }

    private static void validateIndices(int startIndex, int endIndex) throws LogicError {
        if (startIndex < 0) {
            throw new LogicError("startIndex : " + startIndex + " must be a greater than or equal to 0 ");
        }
        if (endIndex < 0) {
            throw new LogicError("endIndex : " + endIndex + " must be a greater than or equal to 0 ");
        }
        if (startIndex > endIndex) {
            throw new LogicError("startIndex : " + startIndex + " must be less than the endIndex : " + endIndex);
        }
        if (startIndex == endIndex) {
            throw new LogicError("startIndex : " + startIndex + " cannot be same as the endIndex : " + endIndex);
        }
    }

    private int validateWindowSize(int windowSize) throws LogicError {
        int maxWindowSize = Integer.max(1, this.mNumBins / 2 - 1);
        if (windowSize <= 0) {
            throw new LogicError("Error: Invalid sliding window size : " + windowSize + ", it must be a positive integer, and maximum acceptable window size is : " + maxWindowSize);
        }
        if (windowSize >= this.mNumBins / 2) {
            throw new LogicError("Error: Sliding window size : " + windowSize + " is too large , it must be less than half of maximum number of frames to process : " + this.mNumBins + " Maximum acceptable window size is : " + maxWindowSize);
        }
        return windowSize;
    }

    private static void validateDataList(@NonNull List<double[]> dataList) throws LogicError {
        if (dataList.isEmpty()) {
            throw new LogicError("Error: An attempt to bin a zero length series");
        }
        for (double[] data : dataList) {
            if (data.length != 0) continue;
            throw new LogicError("Error: There is no data associated with one of the frames in frame range");
        }
    }

    public @NonNull PartialColumnList doBinningPerFrame(@NonNull String columnListTitle) throws LogicError {
        if (this.mSeriesData.isEmpty()) {
            throw new LogicError("Error: There is no series data to process");
        }
        int samplesCount = this.mSeriesData.getFirst().size();
        if (samplesCount != this.mNumBins) {
            throw new LogicError(String.format("Error: Length of data array (%d) does not match with total number of frames (%d) tobe considered in the report", samplesCount, this.mNumBins));
        }
        for (List<double[]> dataList : this.mSeriesData) {
            double[] binnedData = this.binSeries(dataList);
            this.mPerFrameSeries.add(binnedData);
        }
        @NonNull PartialColumnList partialColumnList = new PartialColumnList(columnListTitle);
        partialColumnList.setFrames(this.mFramesToProcess);
        partialColumnList.setStartFrameIndex(this.mStartFrameIndex);
        int i = 0;
        while (i < this.mPerFrameSeries.size()) {
            partialColumnList.addColumn(this.mNames.get(i), this.mPerFrameSeries.get(i));
            ++i;
        }
        return partialColumnList;
    }

    private double[] binSeries(@NonNull List<double @NonNull []> dataList) {
        double[] binnedData = new double[this.mNumBins];
        Arrays.fill(binnedData, 0.0);
        int i = 0;
        for (double[] data : dataList) {
            binnedData[i] = Arrays.stream(data).average().getAsDouble();
            ++i;
        }
        double[] averaged = BinnedDataPerFrame.applySlidingWindowAveraging(binnedData, this.mSlidingWindowSize);
        double[] rounded = BinnedDataPerFrame.roundArrayDownToTwoDP(averaged);
        return rounded;
    }

    private static double[] roundArrayDownToTwoDP(double[] data) {
        double[] rounded = new double[data.length];
        int i = 0;
        while (i < data.length) {
            rounded[i] = BinnedDataPerFrame.roundDoubleToTwoDP(data[i]);
            ++i;
        }
        return rounded;
    }

    private static double roundDoubleToTwoDP(double input) {
        BigDecimal bd = new BigDecimal(input);
        bd = bd.setScale(2, RoundingMode.FLOOR);
        return bd.doubleValue();
    }
}

