/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.analyser;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.common.LogUtils;
import com.arm.streamline.performanceadvisor.common.LogicError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.DoubleSummaryStatistics;
import java.util.List;

public class BinnedData {
    private int binSize;
    private int samplesPerSecond;
    private double offset;
    private int numBins;
    private int srcLength = 0;
    private List<double[]> series = new ArrayList<double[]>();
    private List<Double> averages = new ArrayList<Double>();
    private List<Boolean> isPerFrame = new ArrayList<Boolean>();
    private List<String> names = new ArrayList<String>();
    private List<List<double[]>> dataPerFrameCollection = new ArrayList<List<double[]>>();
    private double[] binTimes = new double[0];

    public BinnedData(int binSize, int samplesPerSecond, double offset) {
        this.binSize = binSize;
        this.samplesPerSecond = samplesPerSecond;
        this.offset = offset;
    }

    public void addSeries(double[] data, String name, boolean backFill) {
        this.addSeries(data, name, backFill, false);
    }

    public void addDataPerFrame(List<double[]> dataPerFrame) {
        this.dataPerFrameCollection.add(dataPerFrame);
    }

    public List<double[]> getDataPerFrameForSeries(int index) {
        return Collections.unmodifiableList(this.dataPerFrameCollection.get(index));
    }

    public void addSeries(double[] data, String name, boolean backFill, boolean isMaximum) {
        Application.LOG.fine(() -> String.format("Binning series %s with %d elements using bin size %d and %d samples/s", name, data.length, this.binSize, this.samplesPerSecond));
        LogUtils.seriesStats(data, name + " before binning");
        if (data.length == 0) {
            throw new LogicError("Attempt to bin a zero length series");
        }
        if (this.srcLength == 0) {
            this.srcLength = data.length;
            this.numBins = (this.srcLength + this.binSize - 1) / this.binSize;
            this.generateBinTimes(this.offset);
            Application.LOG.fine(() -> String.format("Series length is %d bins", this.srcLength));
            Application.LOG.fine(() -> String.format("Number of bins is %d", this.numBins));
        }
        if (this.srcLength != data.length) {
            throw new LogicError(String.format("Series %s length %d differs from expected (%d)", name, data.length, this.srcLength));
        }
        if (this.numBins < 10) {
            Application.LOG.warning(() -> String.format("Low bin count of %d for series %s: length %d, bin size %d", this.numBins, name, this.srcLength, this.binSize));
        }
        double[] srcData = backFill ? BinnedData.backFillData(data) : data;
        double[] binnedData = isMaximum ? this.binMaxSeries(srcData, name) : this.binSeries(srcData, name);
        this.series.add(binnedData);
        this.names.add(name);
    }

    public void setAverageForSeries(double average, boolean isPerFrameValue) {
        this.averages.add(average);
        this.isPerFrame.add(isPerFrameValue);
    }

    public double getAverageSeriesValue(int index) {
        return this.averages.get(index);
    }

    public boolean doesSeriesContainValuesPerFrame(int index) {
        return this.isPerFrame.get(index);
    }

    private double[] binSeries(double[] data, String name) {
        double[] binnedData = new double[this.numBins];
        Arrays.fill(binnedData, 0.0);
        int i = 0;
        while (i < this.srcLength) {
            int idx;
            int n = idx = i / this.binSize;
            binnedData[n] = binnedData[n] + data[i];
            ++i;
        }
        LogUtils.seriesStats(binnedData, name + " before scaling for bin frequency count");
        int lastBinSize = this.srcLength - this.binSize * (this.numBins - 1);
        Application.LOG.fine(() -> String.format("Last bin size is %d", lastBinSize));
        int i2 = 0;
        while (i2 < this.numBins - 1) {
            int n = i2++;
            binnedData[n] = binnedData[n] / (double)this.binSize;
        }
        int n = this.numBins - 1;
        binnedData[n] = binnedData[n] / (double)lastBinSize;
        LogUtils.seriesStats(binnedData, name + ", binned and scaled");
        return binnedData;
    }

    private double[] binMaxSeries(double[] data, String name) {
        ArrayList dataInBins = new ArrayList();
        int i = 0;
        while (i < this.numBins) {
            dataInBins.add(i, new ArrayList());
            ++i;
        }
        int idx = 0;
        int j = 0;
        int i2 = 0;
        while (i2 < this.srcLength) {
            if (i2 / this.binSize != idx) {
                j = 0;
            }
            idx = i2 / this.binSize;
            ((List)dataInBins.get(idx)).add(j, data[i2]);
            ++j;
            ++i2;
        }
        int lastBinSize = this.srcLength - this.binSize * (this.numBins - 1);
        Application.LOG.fine(() -> String.format("Last bin size is %d", lastBinSize));
        double[] binnedData = new double[this.numBins];
        int i3 = 0;
        while (i3 < this.numBins) {
            binnedData[i3] = (Double)Collections.max((Collection)dataInBins.get(i3));
            ++i3;
        }
        LogUtils.seriesStats(binnedData, name + ", binned and scaled");
        return binnedData;
    }

    private static double[] backFillData(double[] originalData) {
        double[] data = Arrays.copyOf(originalData, originalData.length);
        int runLength = 0;
        int i = 0;
        while (i < data.length) {
            if (data[i] == 0.0) {
                ++runLength;
            } else if (runLength > 0) {
                int start = i - runLength;
                BinnedData.fillZeroRun(data, start, runLength);
                runLength = 0;
            }
            ++i;
        }
        return data;
    }

    private static void fillZeroRun(double[] data, int start, int runLength) {
        int nonZeroStart = start + runLength;
        int end = Math.min(nonZeroStart + runLength, data.length);
        end = BinnedData.findEndOfNonZeroRunWithinRange(data, nonZeroStart, end);
        int numValues = runLength + end - nonZeroStart;
        double avg = BinnedData.findSum(data, nonZeroStart, end) / (double)numValues;
        Arrays.fill(data, start, end, avg);
    }

    private static int findEndOfNonZeroRunWithinRange(double[] data, int start, int end) {
        int i = start;
        while (i < end && data[i] != 0.0) {
            ++i;
        }
        return i;
    }

    private static double findSum(double[] data, int start, int end) {
        double result = 0.0;
        int i = start;
        while (i < end) {
            result += data[i];
            ++i;
        }
        return result;
    }

    public int getNumSeries() {
        return this.series.size();
    }

    public String getName(int index) {
        return this.names.get(index);
    }

    public double[] getSeries(int index) {
        return this.series.get(index);
    }

    public double getBinDurationMs() {
        return this.getDurationMs(this.binSize);
    }

    public double[] getTimes() {
        return this.binTimes;
    }

    public int getSamplesPerSecond() {
        return this.samplesPerSecond;
    }

    public void scaleSeriesForSampleRate(int index) {
        double[] data = this.series.get(index);
        int i = 0;
        while (i < this.numBins) {
            int n = i++;
            data[n] = data[n] * (double)this.samplesPerSecond;
        }
    }

    public DoubleSummaryStatistics getSeriesStats(int index) {
        return Arrays.stream(this.series.get(index)).summaryStatistics();
    }

    private double getDurationMs(int numSamples) {
        return 1000.0 * (double)numSamples / (double)this.samplesPerSecond;
    }

    private void generateBinTimes(double offset) {
        double binDurationMs = this.getDurationMs(this.binSize);
        double halfBinMs = binDurationMs / 2.0;
        this.binTimes = new double[this.numBins];
        int i = 0;
        while (i < this.numBins) {
            this.binTimes[i] = halfBinMs + (double)i * binDurationMs + offset;
            ++i;
        }
    }
}

