/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.analyser;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.analyser.Analyser;
import com.arm.streamline.performanceadvisor.analyser.AnalyserFactory;
import com.arm.streamline.performanceadvisor.analyser.CachingAnalyser;
import com.arm.streamline.performanceadvisor.analyser.FooterAnalyserFactory;
import com.arm.streamline.performanceadvisor.analyser.FpsBoundnessAnalyserFactory;
import com.arm.streamline.performanceadvisor.analyser.FrameDisplayAnalyserFactory;
import com.arm.streamline.performanceadvisor.analyser.HeaderAnalyserFactory;
import com.arm.streamline.performanceadvisor.analyser.RegionSummaryAnalyserFactory;
import com.arm.streamline.performanceadvisor.analyser.SummaryAnalyserFactory;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.config.ConfigItem;
import com.arm.streamline.performanceadvisor.developer.BinningTestAnalyserFactory;
import com.arm.streamline.performanceadvisor.developer.DualAxisTestAnalyserFactory;
import com.arm.streamline.performanceadvisor.developer.PerFrameScalingTestAnalyserFactory;
import com.arm.streamline.performanceadvisor.report.SectionSpec;
import com.arm.streamline.performanceadvisor.section.Section;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnalyserLibrary {
    private Map<SectionSpec, Analyser> analyserPool = new HashMap<SectionSpec, Analyser>();
    private Map<String, AnalyserFactory> factoryMap = new HashMap<String, AnalyserFactory>();

    public AnalyserLibrary() {
        this.addFactory(new HeaderAnalyserFactory());
        this.addFactory(new SummaryAnalyserFactory());
        this.addFactory(new RegionSummaryAnalyserFactory());
        this.addFactory(new FrameDisplayAnalyserFactory());
        this.addFactory(new FpsBoundnessAnalyserFactory());
        this.addFactory(new FooterAnalyserFactory());
        this.addFactory(new BinningTestAnalyserFactory());
        this.addFactory(new DualAxisTestAnalyserFactory());
        this.addFactory(new PerFrameScalingTestAnalyserFactory());
    }

    public final ProblemList initialise(SectionSpec spec, CaptureData captureData) {
        Analyser analyser = this.analyserPool.get(spec);
        if (analyser == null) {
            analyser = new CachingAnalyser(spec.create(captureData, this));
            this.analyserPool.put(spec, analyser);
        }
        return analyser.initialise();
    }

    public Section execute(SectionSpec spec, int userRegion) {
        Analyser analyser = this.analyserPool.get(spec);
        if (analyser == null) {
            throw new LogicError("Can't execute unknown analyser: " + spec.getName());
        }
        return analyser.execute(userRegion);
    }

    public void addAllConfigItems(List<ConfigItem<?>> configItems) {
        for (AnalyserFactory i : this.factoryMap.values()) {
            i.addAllConfigItems(configItems);
        }
    }

    public Analyser createAnalyserByName(String name, CaptureData captureData) {
        Application.LOG.fine(() -> "Creating analyser factory: " + name);
        AnalyserFactory factory = this.factoryMap.get(name);
        if (factory == null) {
            throw new LogicError("Failed to create analyser. Name not known: " + name);
        }
        Application.LOG.fine(() -> "Creating analyser: " + name + " via factory");
        return factory.create(captureData);
    }

    private void addFactory(AnalyserFactory factory) {
        String id = factory.getName();
        this.factoryMap.put(id, factory);
        Application.LOG.fine(() -> "Registered analyser type: " + id);
    }
}

