/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.Options;
import com.arm.streamline.performanceadvisor.ReportDriver;
import com.arm.streamline.performanceadvisor.analyser.AnalyserLibrary;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.ReportConfigProvider;
import com.arm.streamline.performanceadvisor.capturesource.CaptureSource;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.common.InsufficientDataException;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.common.ResourceProblem;
import com.arm.streamline.performanceadvisor.common.VersionProvider;
import com.arm.streamline.performanceadvisor.io.FileUtils;
import com.arm.streamline.performanceadvisor.io.PathValidation;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import com.arm.streamline.performanceadvisor.renderer.RendererOptions;
import com.arm.streamline.performanceadvisor.report.CsvReportHandler;
import com.arm.streamline.performanceadvisor.report.DefaultReportDefinitionGenerator;
import com.arm.streamline.performanceadvisor.report.HandlerRegistry;
import com.arm.streamline.performanceadvisor.report.HtmlReportHandler;
import com.arm.streamline.performanceadvisor.report.JsonReportHandler;
import com.arm.streamline.performanceadvisor.report.ReportDefinition;
import com.arm.streamline.performanceadvisor.report.ReportDefinitionFileWriter;
import com.arm.streamline.performanceadvisor.report.ReportHandler;
import com.arm.streamline.performanceadvisor.report.ReportRequest;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;

public class AnalysisDriver
implements ReportDriver {
    private final HandlerRegistry handlerRegistry;
    private AnalyserLibrary library;
    private VersionProvider versionProvider;
    private Options options;
    private UserProvidedPath capturePath;

    public AnalysisDriver(HandlerRegistry handlerRegistry, AnalyserLibrary library, VersionProvider versionProvider) {
        this.handlerRegistry = handlerRegistry;
        this.library = library;
        this.versionProvider = versionProvider;
        this.options = null;
    }

    @Override
    public void validate(Options options) {
        this.options = options;
        options.validateFilenameCount(1, "Provide one Streamline capture.");
        List<String> fileNames = options.getFileNames();
        this.capturePath = new UserProvidedPath(Path.of(fileNames.get(0), new String[0]));
        PathValidation.fatalErrorIfInvalidForFileOrDirectoryRead(this.capturePath);
    }

    @Override
    public void generate() throws IOException, InterruptedException, InsufficientDataException {
        @NonNull List<@NonNull ReportRequest> reportRequests = this.options.getReportRequests();
        this.validateReportTypes(reportRequests);
        Application.LOG.fine("Configure input capture");
        Throwable throwable = null;
        Object var3_4 = null;
        try (CaptureSource source = new CaptureSource(this.capturePath);){
            boolean chartListRequested;
            CaptureData captureData = new CaptureData(source, this.options);
            ProblemList commonProblems = captureData.initialise();
            ReportConfigProvider reportTemplateProvider = captureData.getReportTemplateProvider();
            if (!reportTemplateProvider.templateExistsWithinCaptureDirectory()) {
                reportTemplateProvider.copyTemplateToCaptureDirectory();
            }
            if (this.options.getCustomReportPath() != null) {
                this.configureReportConfig(this.options.getCustomReportPath());
            } else {
                Path reportConfigPath = Path.of(String.valueOf(source.toFile()) + "/report_config.json", new String[0]);
                this.configureReportConfig(new UserProvidedPath(reportConfigPath));
            }
            List<ReportSpec> reports = this.bindOutputPaths(reportRequests, this.options.getOutputDirectory());
            AnalysisDriver.validateUniqueOutputPaths(reports);
            ArrayList<Path> reportsPathList = new ArrayList<Path>();
            for (ReportSpec report : reports) {
                reportsPathList.add(report.path);
            }
            captureData.setReportsPathList(reportsPathList);
            Path chartListOutputPath = this.options.getChartListOutputPath();
            boolean bl = chartListRequested = chartListOutputPath != null;
            if (chartListRequested) {
                this.saveChartList(captureData, chartListOutputPath);
            } else {
                this.initialiseAnalysers(captureData, commonProblems, reports, this.options.getShowProgress());
                captureData.execute();
                this.generateReports(reports, this.options);
                this.logProfilingResults(this.options.getShowProfile());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void listProblems(ProblemList problems, String type) {
        if (!problems.isEmpty()) {
            System.err.println("Problems were found preparing " + type + " report:");
            for (ResourceProblem p : problems) {
                System.err.format("%s: %s%n", p.getSeverity().toString(), p.toString());
            }
            System.err.println();
        }
    }

    private List<ReportSpec> bindOutputPaths(@NonNull List<@NonNull ReportRequest> reportRequests, UserProvidedPath dirPath) {
        Application.LOG.fine("Configure requested report types");
        ArrayList<ReportSpec> result = new ArrayList<ReportSpec>();
        for (ReportRequest i : reportRequests) {
            ReportHandler handler = this.handlerRegistry.getHandler(i.getType());
            String outputPath = i.getDestination() == null ? handler.getDefaultFilename() : i.getDestination();
            UserProvidedPath destinationPath = UserProvidedPath.combine(dirPath, Path.of(outputPath, new String[0]));
            FileUtils.createMissingDirectories(destinationPath);
            PathValidation.fatalErrorIfInvalidForFileWrite(destinationPath);
            result.add(new ReportSpec(handler, destinationPath.getAdjustedPath()));
        }
        return result;
    }

    private static void validateUniqueOutputPaths(List<ReportSpec> reports) {
        List absPaths = reports.stream().map(e -> e.getPath().toAbsolutePath()).collect(Collectors.toList());
        List uniquePaths = absPaths.stream().distinct().collect(Collectors.toList());
        if (absPaths.size() != uniquePaths.size()) {
            throw new FatalError("Destination filenames cannot be the same.");
        }
    }

    private void validateReportTypes(@NonNull List<@NonNull ReportRequest> reportRequests) {
        Application.LOG.info("Validating output options");
        for (ReportRequest i : reportRequests) {
            if (i.getType() != null) continue;
            String file = i.getDestination();
            if (file == null) {
                throw new FatalError("Invalid report type");
            }
            throw new FatalError("No report type specified for output file: " + file);
        }
        List uniqueTypes = reportRequests.stream().map(ReportRequest::getType).distinct().collect(Collectors.toList());
        if (uniqueTypes.size() != reportRequests.size()) {
            throw new FatalError("A report type can only be specified once");
        }
        List unknownTypes = reportRequests.stream().map(ReportRequest::getType).filter(e -> !this.handlerRegistry.isKnownType((String)e)).collect(Collectors.toList());
        if (!unknownTypes.isEmpty()) {
            StringBuilder errorMsg = new StringBuilder("Unknown report type");
            if (unknownTypes.size() > 1) {
                errorMsg.append('s');
            }
            errorMsg.append(':');
            for (String i : unknownTypes) {
                errorMsg.append(' ');
                errorMsg.append(i);
            }
            throw new FatalError(errorMsg.toString());
        }
    }

    private void configureReportConfig(UserProvidedPath reportPath) {
        Application.LOG.fine(() -> "Custom report file path: " + reportPath.toString());
        Application.LOG.fine("Using custom html and json report handlers");
        this.handlerRegistry.replaceHandler(new HtmlReportHandler(reportPath));
        this.handlerRegistry.replaceHandler(new JsonReportHandler(reportPath));
        this.handlerRegistry.replaceHandler(new CsvReportHandler(reportPath));
    }

    private void saveChartList(CaptureData captureData, Path chartListOutputPath) {
        UserProvidedPath combinedPath = UserProvidedPath.combine(this.options.getOutputDirectory(), chartListOutputPath);
        FileUtils.createMissingDirectories(combinedPath);
        PathValidation.fatalErrorIfInvalidForFileWrite(combinedPath);
        ReportDefinition customReportDef = new DefaultReportDefinitionGenerator(captureData).generate();
        new ReportDefinitionFileWriter().write(combinedPath, customReportDef);
        System.out.println("Chart list saved to " + combinedPath.getUserProvidedPath().toString());
    }

    private void initialiseAnalysers(CaptureData captureData, ProblemList commonProblems, List<ReportSpec> reports, boolean showProgress) throws InsufficientDataException {
        boolean success = true;
        for (ReportSpec i : reports) {
            System.out.format("Preparing report type %s...%n", i.getHandler().getType());
            ReportHandler handler = i.getHandler();
            ProblemList problems = handler.initialise(captureData, this.library, showProgress);
            problems.addAll(commonProblems);
            AnalysisDriver.listProblems(problems.copyRemovingDuplicates(), handler.getType());
            if (!problems.hasError()) continue;
            success = false;
        }
        if (!success) {
            throw new InsufficientDataException();
        }
    }

    private void generateReports(List<ReportSpec> reports, Options options) {
        RendererOptions rendererOptions = options.getRendererOptions();
        for (ReportSpec i : reports) {
            System.out.format("Generating report type %s...%n", i.getHandler().getType());
            ReportHandler handler = i.getHandler();
            Path destination = i.getPath();
            handler.execute(rendererOptions, destination, options.getShowProgress());
            System.out.format("Report \"%s\" successfully generated%n", destination);
        }
    }

    private void logProfilingResults(boolean showOnConsole) {
        if (!this.versionProvider.isRelease()) {
            if (Application.LOG.isLoggable(Level.INFO)) {
                Application.PROFILER.printProfile(Application.LOG::info, true);
            }
            if (showOnConsole) {
                Application.PROFILER.printProfile(System.out::println, false);
            }
        }
    }

    private class ReportSpec {
        private ReportHandler handler;
        private Path path;

        public ReportSpec(ReportHandler handler, Path path) {
            this.handler = handler;
            this.path = path;
        }

        public ReportHandler getHandler() {
            return this.handler;
        }

        public Path getPath() {
            return this.path;
        }
    }
}

