/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.data_file.header_flag_values;

import com.arm.streamline.perf.io.StringIO;
import com.arm.utils.NullChecking;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class TracingData {
    private static final byte[] HEADER = new byte[]{23, 8, 68, 116, 114, 97, 99, 105, 110, 103};
    private final @NonNull ByteOrder endianness;
    private final byte sizeofLong;
    private final int pageSize;
    private final @NonNull NamedFileRecord headerPage;
    private final @NonNull NamedFileRecord headerEvent;
    private final @NonNull List<@NonNull FileRecord> ftraceRecords;
    private final @NonNull List<@NonNull TracepointRecord> eventRecords;
    private final @Nullable FileRecord kallsyms;
    private final @Nullable FileRecord ftracePrintk;
    private final @Nullable FileRecord cmdline;

    public TracingData(@NonNull DataInput input) throws IOException {
        byte[] header = new byte[HEADER.length];
        input.readFully(header);
        if (!Arrays.equals(header, HEADER)) {
            throw new IOException("Invalid header in TRACING_DATA section");
        }
        String versionStr = StringIO.readCString((DataInput)input);
        float versionNo = Float.parseFloat(versionStr);
        if ((double)versionNo < 0.5) {
            throw new IOException("Invalid version string in TRACING_DATA section");
        }
        this.endianness = (ByteOrder)NullChecking.neverNull((Object)(input.readByte() == 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN));
        this.sizeofLong = input.readByte();
        assert (this.sizeofLong == 4 || this.sizeofLong == 8);
        this.pageSize = input.readInt();
        this.headerPage = new NamedFileRecord(input);
        assert (this.headerPage.getName().equals("header_page"));
        this.headerEvent = new NamedFileRecord(input);
        assert (this.headerEvent.getName().equals("header_event"));
        this.ftraceRecords = FileRecord.create(input);
        this.eventRecords = TracepointRecord.create(input);
        this.kallsyms = FileRecord.optional(input, false);
        this.ftracePrintk = FileRecord.optional(input, false);
        this.cmdline = (double)versionNo >= 0.6 ? FileRecord.optional(input, true) : null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TracingData) {
            TracingData that = (TracingData)obj;
            return this.pageSize == that.pageSize && this.sizeofLong == that.sizeofLong && this.endianness.equals(that.endianness) && this.eventRecords.equals(that.eventRecords) && this.ftraceRecords.equals(that.ftraceRecords) && this.headerEvent.equals(that.headerEvent) && this.headerPage.equals(that.headerPage) && (this.ftracePrintk == null && that.ftracePrintk == null || this.ftracePrintk != null && that.ftracePrintk != null && this.ftracePrintk.equals(that.ftracePrintk)) && (this.kallsyms == null && that.kallsyms == null || this.kallsyms != null && that.kallsyms != null && this.kallsyms.equals(that.kallsyms));
        }
        return false;
    }

    public @NonNull ByteOrder getEndianness() {
        return this.endianness;
    }

    public @NonNull List<@NonNull TracepointRecord> getEventRecords() {
        return this.eventRecords;
    }

    public @Nullable FileRecord getFtracePrintk() {
        return this.ftracePrintk;
    }

    public @NonNull List<@NonNull FileRecord> getFtraceRecords() {
        return this.ftraceRecords;
    }

    public @NonNull NamedFileRecord getHeaderEvent() {
        return this.headerEvent;
    }

    public @NonNull NamedFileRecord getHeaderPage() {
        return this.headerPage;
    }

    public @Nullable FileRecord getKallsyms() {
        return this.kallsyms;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public byte getSizeofLong() {
        return this.sizeofLong;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.endianness.hashCode();
        result = 31 * result + this.eventRecords.hashCode();
        result = 31 * result + (this.ftracePrintk != null ? this.ftracePrintk.hashCode() : 0);
        result = 31 * result + this.ftraceRecords.hashCode();
        result = 31 * result + this.headerEvent.hashCode();
        result = 31 * result + this.headerPage.hashCode();
        result = 31 * result + (this.kallsyms != null ? this.kallsyms.hashCode() : 0);
        result = 31 * result + this.pageSize;
        result = 31 * result + this.sizeofLong;
        return result;
    }

    public String toString() {
        return String.format("TracingData [endianness=%s, sizeofLong=%s, pageSize=%s, headerPage=%s, headerEvent=%s, ftraceRecords=%s, eventRecords=%s, kallsyms=%s, ftracePrintk=%s]", this.endianness, this.sizeofLong, this.pageSize, this.headerPage, this.headerEvent, this.ftraceRecords, this.eventRecords, this.kallsyms, this.ftracePrintk);
    }

    public static final class FileRecord {
        private final @NonNull String contents;

        public static @NonNull List<@NonNull FileRecord> create(@NonNull DataInput input) throws IOException {
            ArrayList<@NonNull FileRecord> result = new ArrayList<FileRecord>();
            int count = input.readInt();
            while (result.size() < count) {
                result.add(new FileRecord(input, true));
            }
            return result;
        }

        public static @Nullable FileRecord optional(@NonNull DataInput input, boolean longSize) throws IOException {
            FileRecord result = new FileRecord(input, longSize);
            return result.contents.isEmpty() ? null : result;
        }

        public FileRecord(@NonNull DataInput input, boolean lengthIsLong) throws IOException {
            long length;
            long l = length = lengthIsLong ? input.readLong() : (long)input.readInt() & 0xFFFFFFFFL;
            assert ((length & 0xFFFFFFFFL) == length);
            this.contents = (String)NullChecking.neverNull((Object)String.valueOf(StringIO.readFixedString((DataInput)input, (int)((int)length))));
        }

        public boolean equals(Object obj) {
            if (obj instanceof FileRecord) {
                FileRecord that = (FileRecord)obj;
                return this.contents.equals(that.contents);
            }
            return false;
        }

        public @NonNull String getContents() {
            return this.contents;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.contents.hashCode();
            return result;
        }

        public String toString() {
            return String.format("FileRecord [contents=%s]", this.contents);
        }
    }

    public static final class NamedFileRecord {
        private final @NonNull String name;
        private final @NonNull FileRecord file;

        public NamedFileRecord(@NonNull DataInput input) throws IOException {
            this.name = StringIO.readCString((DataInput)input);
            this.file = new FileRecord(input, true);
        }

        public boolean equals(Object obj) {
            if (obj instanceof NamedFileRecord) {
                NamedFileRecord that = (NamedFileRecord)obj;
                return this.name.equals(that.name) && this.file.equals(that.file);
            }
            return false;
        }

        public @NonNull FileRecord getFile() {
            return this.file;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.file.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public String toString() {
            return String.format("NamedFileRecord [name=%s, file=%s]", this.name, this.file);
        }
    }

    public static final class TracepointRecord {
        private final @NonNull String name;
        private final @NonNull List<@NonNull FileRecord> events;

        public static @NonNull List<@NonNull TracepointRecord> create(@NonNull DataInput input) throws IOException {
            ArrayList<@NonNull TracepointRecord> result = new ArrayList<TracepointRecord>();
            int count = input.readInt();
            while (result.size() < count) {
                result.add(new TracepointRecord(input));
            }
            return result;
        }

        public TracepointRecord(@NonNull DataInput input) throws IOException {
            this.name = StringIO.readCString((DataInput)input);
            this.events = FileRecord.create(input);
        }

        public boolean equals(Object obj) {
            if (obj instanceof TracepointRecord) {
                TracepointRecord that = (TracepointRecord)obj;
                return this.name.equals(that.name) && this.events.equals(that.events);
            }
            return false;
        }

        public @NonNull List<@NonNull FileRecord> getEvents() {
            return this.events;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.events.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public String toString() {
            return String.format("TracepointRecord [name=%s, events=%s]", this.name, this.events);
        }
    }
}

