/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.data_file.header_flag_values;

import com.arm.streamline.perf.data_file.HeaderFlags;
import com.arm.streamline.perf.io.StringIO;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class GroupDescription {
    private final int leaderIndex;
    private final @NonNull String name;
    private final int numberOfMembers;

    public static @NonNull List<@NonNull GroupDescription> create(@NonNull DataInput input) throws IOException {
        ArrayList<@NonNull GroupDescription> groups = new ArrayList<GroupDescription>();
        int nr = input.readInt();
        int i = 0;
        while (i < nr) {
            groups.add(new GroupDescription(input));
            ++i;
        }
        return groups;
    }

    public GroupDescription(@NonNull DataInput input) throws IOException {
        this.name = StringIO.stripNullTerminator((String)HeaderFlags.readHeaderString(input));
        this.leaderIndex = input.readInt();
        this.numberOfMembers = input.readInt();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GroupDescription) {
            GroupDescription that = (GroupDescription)obj;
            return this.leaderIndex == that.leaderIndex && this.numberOfMembers == that.numberOfMembers && this.name.equals(that.name);
        }
        return false;
    }

    public int getLeaderIndex() {
        return this.leaderIndex;
    }

    public String getName() {
        return this.name;
    }

    public int getNumberOfMembers() {
        return this.numberOfMembers;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.leaderIndex;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.numberOfMembers;
        return result;
    }

    public String toString() {
        return String.format("GroupDescription [leaderIndex=%s, numberOfMembers=%s, name=%s]", this.leaderIndex, this.numberOfMembers, this.name);
    }
}

