/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.data_file.header_flag_values;

import com.arm.streamline.perf.data_file.HeaderFlags;
import com.arm.streamline.perf.io.StringIO;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class CacheDescription {
    private final int level;
    private final int lineSize;
    private final int sets;
    private final int ways;
    private final @NonNull String type;
    private final @NonNull String size;
    private final @NonNull String map;

    public static @NonNull List<@NonNull CacheDescription> create(@NonNull DataInput input) throws IOException {
        ArrayList<@NonNull CacheDescription> caches = new ArrayList<CacheDescription>();
        int version = input.readInt();
        if (version != 1) {
            throw new IOException("Unexpected HEADER_CACHE version: " + version);
        }
        int nr = input.readInt();
        int i = 0;
        while (i < nr) {
            caches.add(new CacheDescription(input));
            ++i;
        }
        return caches;
    }

    public CacheDescription(@NonNull DataInput input) throws IOException {
        this.level = input.readInt();
        this.lineSize = input.readInt();
        this.sets = input.readInt();
        this.ways = input.readInt();
        this.type = StringIO.stripNullTerminator((String)HeaderFlags.readHeaderString(input));
        this.size = StringIO.stripNullTerminator((String)HeaderFlags.readHeaderString(input));
        this.map = StringIO.stripNullTerminator((String)HeaderFlags.readHeaderString(input));
    }

    public boolean equals(Object obj) {
        if (obj instanceof CacheDescription) {
            CacheDescription that = (CacheDescription)obj;
            return this.level == that.level && this.lineSize == that.lineSize && this.sets == that.sets && this.ways == that.ways && this.type.equals(that.type) && this.size.equals(that.size) && this.map.equals(that.map);
        }
        return false;
    }

    public int getLevel() {
        return this.level;
    }

    public int getLineSize() {
        return this.lineSize;
    }

    public @NonNull String getMap() {
        return this.map;
    }

    public int getSets() {
        return this.sets;
    }

    public @NonNull String getSize() {
        return this.size;
    }

    public @NonNull String getType() {
        return this.type;
    }

    public int getWays() {
        return this.ways;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.level;
        result = 31 * result + this.lineSize;
        result = 31 * result + this.sets;
        result = 31 * result + this.ways;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.size.hashCode();
        result = 31 * result + this.map.hashCode();
        return result;
    }

    public String toString() {
        return String.format("CacheDescription [level=%s, lineSize=%s, sets=%s, ways=%s, type=%s, size=%s, map=%s]", this.level, this.lineSize, this.sets, this.ways, this.type, this.size, this.map);
    }
}

