/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.data_file;

import java.io.DataInput;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public final class FileSection {
    private final long offset;
    private final long size;
    public static final int SIZE = 16;

    public FileSection(@NonNull DataInput input) throws IOException {
        this.offset = input.readLong();
        this.size = input.readLong();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileSection) {
            FileSection that = (FileSection)obj;
            return this.offset == that.offset && this.size == that.size;
        }
        return false;
    }

    public long getEnd() {
        return this.offset + this.size;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getSize() {
        return this.size;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        return result;
    }

    public String toString() {
        return String.format("FileSection [offset=%s, size=%s]", this.offset, this.size);
    }
}

