/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.data_file;

import com.arm.streamline.perf.InvalidPerfDataException;
import com.arm.streamline.perf.data_file.FileSection;
import com.arm.streamline.perf.data_file.Header;
import com.arm.streamline.perf.data_file.HeaderFlags;
import com.arm.streamline.perf.data_file.HeaderType;
import com.arm.streamline.perf.data_file.IDataFile;
import com.arm.streamline.perf.data_file.RecordVisitor;
import com.arm.streamline.perf.records.EventAttribute;
import com.arm.streamline.perf.records.EventHeader;
import com.arm.streamline.perf.records.RecordBlob;
import com.arm.utils.NullChecking;
import com.arm.utils.datainput.SeekableDataInput;
import com.arm.utils.datainput.SeekableInputStream;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DataFile
implements IDataFile {
    private final @NonNull Map<@NonNull EventAttribute, @NonNull TLongSet> attributes;
    private @Nullable Long cachedNumberOfRecords;
    private final @NonNull SeekableDataInput dataInput;
    private final @NonNull Header header;
    private final @NonNull SeekableInputStream inputStream;

    public DataFile(@NonNull File file) throws IOException, InvalidPerfDataException {
        this(new SeekableInputStream(new FileInputStream(file)));
    }

    public DataFile(@NonNull SeekableInputStream is) throws IOException, InvalidPerfDataException {
        this.inputStream = is;
        HeaderType headerType = Header.validateMagicBytes((InputStream)this.inputStream);
        if (headerType == null) {
            throw new InvalidPerfDataException(InvalidPerfDataException.Reason.FILE_NOT_RECOGNIZED);
        }
        this.dataInput = headerType.getEndianAppropriateDataInput(this.inputStream);
        this.header = new Header(headerType, this.dataInput);
        this.attributes = this.readAttributes();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataFile) {
            DataFile that = (DataFile)obj;
            return this.inputStream.equals(that.inputStream) && this.dataInput.equals(that.dataInput) && this.header.equals(that.header) && this.attributes.equals(that.attributes);
        }
        return false;
    }

    @Override
    public @NonNull Map<@NonNull EventAttribute, @NonNull TLongSet> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public @NonNull ByteOrder getByteOrder() {
        return this.getHeader().getType().isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public @NonNull SeekableDataInput getDataInput() {
        return this.dataInput;
    }

    public @NonNull Header getHeader() {
        return this.header;
    }

    @Override
    public <T> @Nullable T getHeaderFlagValue(@NonNull HeaderFlags<T> flag) throws IOException {
        return this.header.getFlagValue(flag, this.dataInput);
    }

    public @NonNull InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public long getNumberOfRecords() throws IOException, InvalidPerfDataException, InterruptedException {
        if (this.cachedNumberOfRecords == null) {
            FileSection dataSection = this.header.getData();
            this.dataInput.seek(dataSection.getOffset());
            long offset = 0L;
            long count = 0L;
            while (offset < dataSection.getSize()) {
                EventHeader header = EventHeader.fromDataInput((DataInput)this.dataInput);
                this.dataInput.skipBytes(header.getPayloadSizeAsInt());
                assert (this.dataInput.offset() == dataSection.getOffset() + (offset += header.getTotalSize()));
                assert (offset <= dataSection.getSize());
                ++count;
            }
            this.cachedNumberOfRecords = count;
        }
        return (Long)NullChecking.neverNull((Object)this.cachedNumberOfRecords);
    }

    public int hashCode() {
        return this.header.hashCode() ^ this.attributes.hashCode();
    }

    @Override
    public boolean isHeaderFlagSet(@NonNull HeaderFlags<?> flag) {
        return this.header.isFlagSet(flag);
    }

    @Override
    public void processRecords(@NonNull RecordVisitor visitor) throws IOException, InvalidPerfDataException, InterruptedException {
        FileSection dataSection = this.header.getData();
        this.dataInput.seek(dataSection.getOffset());
        long offset = 0L;
        while (offset < dataSection.getSize()) {
            RecordBlob record = new RecordBlob((DataInput)this.dataInput);
            visitor.process(record);
            assert (this.dataInput.offset() == dataSection.getOffset() + (offset += record.getHeader().getTotalSize()));
            assert (offset <= dataSection.getSize());
        }
    }

    public String toString() {
        return String.format("DataFile [header=%s]", this.header);
    }

    private @NonNull Map<@NonNull EventAttribute, @NonNull TLongSet> readAttributes() throws IOException {
        int attrSize = (int)this.header.getAttrSize();
        FileSection attrSection = this.header.getAttrs();
        HashMap<@NonNull EventAttribute, @NonNull TLongSet> result = new HashMap<EventAttribute, TLongSet>();
        if (attrSize < 48) {
            throw new IOException("Unexpectedly small attrSize: " + attrSize);
        }
        boolean first = true;
        long offset = attrSection.getOffset();
        while (offset < attrSection.getEnd()) {
            this.dataInput.seek(offset);
            EventAttribute attr = new EventAttribute((DataInput)this.dataInput, attrSize - 16);
            FileSection idsFileSection = new FileSection((DataInput)this.dataInput);
            assert (this.dataInput.offset() == (offset += (long)attrSize));
            this.dataInput.seek(idsFileSection.getOffset());
            int numIds = Math.toIntExact(idsFileSection.getSize() / 8L);
            TLongSet ids = result.computeIfAbsent(attr, k -> new TLongHashSet());
            int i = 0;
            while (i < numIds) {
                ids.add(this.dataInput.readLong());
                ++i;
            }
            if (!first) continue;
            ids.add(0L);
            first = false;
        }
        return result;
    }
}

