/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf;

import com.arm.streamline.analysis.gator.BacktraceProcessing;
import com.arm.streamline.capture.builder.apc.APCFrameBuilder;
import com.arm.streamline.common.utility.io.Compression;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.perf.InvalidPerfDataException;
import com.arm.streamline.perf.PerfMessages;
import com.arm.streamline.perf.Statistics;
import com.arm.streamline.perf.apc.EventsXml;
import com.arm.streamline.perf.data_file.DataFile;
import com.arm.streamline.perf.data_file.HeaderFlags;
import com.arm.streamline.perf.data_file.IDataFile;
import com.arm.streamline.perf.data_file.header_flag_values.EventDescription;
import com.arm.streamline.perf.data_file.header_flag_values.PmuMapping;
import com.arm.streamline.perf.data_file.header_flag_values.TracingData;
import com.arm.streamline.perf.misc.IEventsXMLProvider;
import com.arm.streamline.perf.misc.IParallelEventRecordProcessor;
import com.arm.streamline.perf.misc.IdToAttributeMap;
import com.arm.streamline.perf.records.EventAndPmuNames;
import com.arm.streamline.perf.records.EventAttribute;
import com.arm.streamline.perf.records.ReadFormat;
import com.arm.streamline.perf.records.RecordBlob;
import com.arm.streamline.perf.transform.CapturedCounter;
import com.arm.streamline.perf.transform.CapturedCounters;
import com.arm.streamline.perf.transform.ClusterCoreMapping;
import com.arm.streamline.perf.transform.CommEntry;
import com.arm.streamline.perf.transform.IPerfTransformMonitor;
import com.arm.streamline.protocol.capture.apc.io.APCCaptureFrameWriter;
import com.arm.streamline.protocol.capture.apc.io.IAPCCaptureFrameWriter;
import com.arm.utils.NullChecking;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.TLongSet;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class PerfToAPCTransformer
implements Closeable {
    private static final int FRAME_BUILDER_SIZE_LIMIT = 65536;
    private final @NonNull IDataFile dataFile;
    private final @NonNull EventsXml eventsXml;
    private final @Nullable Long sharedSampleTypeBits;
    private final @NonNull Map<String, String> warningMessages = new HashMap<String, String>();

    private static byte @NonNull [] compressPerfRecord(@NonNull RecordBlob record) throws IOException {
        byte @NonNull [] data = record.getBytes();
        if ((data.length & 7) != 0) {
            throw new AssertionError();
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        int i = 0;
        while (i < data.length) {
            long longValue = (long)data[i + 0] & 0xFFL | ((long)data[i + 1] & 0xFFL) << 8 | ((long)data[i + 2] & 0xFFL) << 16 | ((long)data[i + 3] & 0xFFL) << 24 | ((long)data[i + 4] & 0xFFL) << 32 | ((long)data[i + 5] & 0xFFL) << 40 | ((long)data[i + 6] & 0xFFL) << 48 | ((long)data[i + 7] & 0xFFL) << 56;
            Compression.packInt((long)longValue, (OutputStream)result);
            i += 8;
        }
        return (byte[])NullChecking.neverNull((Object)result.toByteArray());
    }

    private static boolean isExcludedCounter(@NonNull CapturedCounter counter) {
        EventAttribute attr = counter.getEventAttribute();
        if (attr.getType() == 1 && attr.getConfig() == 0L) {
            return true;
        }
        return attr.getType() == 1 && attr.getConfig() == 9L;
    }

    private static void writeCapturedXml(@NonNull OutputStream outputStream, @NonNull String name, int cores, long sampleRate, @NonNull CapturedCounters capturedCounters, @NonNull Set<CapturedCounter> countersWithoutSamples) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var8_8 = null;
        try (XMLGenerator generator = new XMLGenerator(outputStream);){
            generator.startDocument();
            generator.startTag("captured");
            generator.addAttribute("version", 1);
            generator.addAttribute("created", System.currentTimeMillis() / 1000L);
            generator.addAttribute("type", "Perf");
            generator.addAttribute("protocol", 900);
            generator.addAttribute("backtrace_processing", BacktraceProcessing.NONE.toString());
            generator.addAttribute("is_perf_import", "yes");
            generator.startEmptyTag("target");
            generator.addAttribute("name", name);
            generator.addAttribute("sample_rate", sampleRate);
            generator.addAttribute("cores", cores);
            generator.startTag("counters");
            for (CapturedCounter counter : capturedCounters.getMappings().values()) {
                if (countersWithoutSamples.contains(counter) || PerfToAPCTransformer.isExcludedCounter(counter)) continue;
                counter.writeCapturedXml(generator);
            }
            generator.endTag();
            generator.endTag();
            generator.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void writeCommEntries(@NonNull IAPCCaptureFrameWriter frameWriter, @NonNull List<CommEntry> commEntries) throws IOException {
        APCFrameBuilder frameBuilder = new APCFrameBuilder(11);
        frameBuilder.writePacked32(0);
        for (CommEntry entry : commEntries) {
            frameBuilder.writePacked32(5);
            frameBuilder.writePacked32(entry.getPid());
            frameBuilder.writePacked32(entry.getTid());
            frameBuilder.writeCString(entry.getImage());
            frameBuilder.writeCString(entry.getComm());
        }
        frameWriter.writeFrame(frameBuilder.getData());
    }

    private static void writeCountersXml(@NonNull OutputStream outputStream, @NonNull EventsXml eventsXml, @NonNull ClusterCoreMapping clusterCoreMap, @NonNull CapturedCounters capturedCounters, @NonNull Map<String, String> warningMessages) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (XMLGenerator generator = new XMLGenerator(outputStream);){
            generator.startDocument();
            generator.startTag("counters");
            for (CapturedCounter counter : capturedCounters.getMappings().values()) {
                counter.writeCountersXml(generator);
            }
            int numClusters = clusterCoreMap.getClusterCount();
            String[] names = new String[numClusters];
            boolean writeClusters = numClusters > 1;
            int i = 0;
            while (writeClusters && i < numClusters) {
                String name = clusterCoreMap.getClusterName(eventsXml, i);
                if (name != null) {
                    names[i] = name;
                } else {
                    writeClusters = false;
                }
                ++i;
            }
            if (writeClusters) {
                i = 0;
                while (i < numClusters) {
                    generator.startEmptyTag("cluster");
                    generator.addAttribute("id", i);
                    generator.addAttribute("name", clusterCoreMap.getClusterName(eventsXml, i));
                    ++i;
                }
                int[] nArray = clusterCoreMap.getCoreToClusterMap().keys();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int core = nArray[n2];
                    int cluster = clusterCoreMap.getCoreToClusterMap().get(core);
                    generator.startEmptyTag("cpu");
                    generator.addAttribute("id", core);
                    generator.addAttribute("cluster", cluster);
                    ++n2;
                }
            } else {
                warningMessages.put((String)NullChecking.neverNull((Object)PerfMessages.MISSING_CLUSTER_MAP_TITLE), (String)NullChecking.neverNull((Object)PerfMessages.MISSING_CLUSTER_MAP_MESSAGE));
            }
            for (Map.Entry<String, String> warning : warningMessages.entrySet()) {
                generator.startTag("other_warnings");
                generator.addText(warning.getKey() + "\n" + warning.getValue() + "|");
                generator.endTag();
            }
            generator.endTag();
            generator.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeEventsXml(@NonNull File apcDirectory, @NonNull IEventsXMLProvider eventsXmlProvider) throws FileNotFoundException, IOException {
        byte[] buffer = new byte[0x100000];
        int bytesRead = 0;
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            InputStream inputStream = eventsXmlProvider.getEventsXmlInputStream();
            try {
                try (FileOutputStream outputStream = new FileOutputStream(new File(apcDirectory, "events.xml"));){
                    while ((bytesRead = inputStream.read(buffer)) >= 0) {
                        outputStream.write(buffer, 0, bytesRead);
                    }
                }
                if (inputStream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void writePerfAttributeKeys(@NonNull IAPCCaptureFrameWriter frameWriter, @NonNull ToIntFunction<@NonNull EventAttribute> keys, @NonNull Map<@NonNull EventAttribute, @NonNull TLongSet> attributes) throws IOException {
        APCFrameBuilder frameBuilder = new APCFrameBuilder(11);
        frameBuilder.writePacked32(0);
        for (Map.Entry<EventAttribute, TLongSet> entry : attributes.entrySet()) {
            int key = keys.applyAsInt(entry.getKey());
            long[] ids = entry.getValue().toArray();
            if (ids.length <= 0) continue;
            frameBuilder.writePacked32(2);
            frameBuilder.writePacked32(ids.length);
            long[] lArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                long id = lArray[n2];
                frameBuilder.writePacked64(id);
                frameBuilder.writePacked32(key);
                ++n2;
            }
        }
        frameWriter.writeFrame(frameBuilder.getData());
    }

    private static void writePerfAttributes(@NonNull IAPCCaptureFrameWriter frameWriter, @NonNull ToIntFunction<@NonNull EventAttribute> keys, @NonNull Collection<@NonNull EventAttribute> attributes) throws IOException {
        APCFrameBuilder frameBuilder = new APCFrameBuilder(11);
        frameBuilder.writePacked32(0);
        for (EventAttribute attr : attributes) {
            int key = keys.applyAsInt(attr);
            frameBuilder.writePacked32(1);
            attr.write(frameBuilder.asDataOutput());
            frameBuilder.writePacked32(key);
        }
        frameWriter.writeFrame(frameBuilder.getData());
    }

    private static void writePerfRecord(@NonNull APCFrameBuilder frameBuilder, @NonNull IDataFile dataFile, long idBits, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull RecordBlob.IIdToAttributeMap attributesById, @NonNull RecordBlob record) throws IOException, InvalidPerfDataException {
        if (record.getHeader().getType() < 64) {
            RecordBlob.SampleId sampleId = record.parseSampleId(dataFile.getByteOrder(), idBits, attributesById);
            int core = sampleId.cpu != null ? sampleId.cpu : 0;
            frameBuilder.writePacked32(core);
            byte @NonNull [] recordData = PerfToAPCTransformer.compressPerfRecord(record);
            frameBuilder.asDataOutput().writeInt(recordData.length);
            frameBuilder.write(recordData);
        }
    }

    private static void writeSessionXml(@NonNull OutputStream outputStream, @Nullable String targetAddress) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (XMLGenerator generator = new XMLGenerator(outputStream);){
            generator.startDocument();
            generator.startTag("session");
            generator.addAttribute("version", 1);
            generator.addAttribute("call_stack_unwinding", "yes");
            generator.addAttribute("parse_debug_info", "yes");
            generator.addAttribute("high_resolution", "no");
            generator.addAttribute("buffer_mode", "streaming");
            generator.addAttribute("sample_rate", "normal");
            generator.addAttribute("target_address", targetAddress != null ? targetAddress : "unknown");
            generator.addAttribute("live_rate", 100);
            generator.addAttribute("mali_timeline_layer_driver", "auto");
            generator.endTag();
            generator.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void writeSummaryFrame(@NonNull IAPCCaptureFrameWriter frameWriter, long timestamp) throws IOException {
        APCFrameBuilder frameBuilder = new APCFrameBuilder(1);
        frameBuilder.writePacked32(1);
        frameBuilder.writeString("1\n2\r\n3\r4\n\r5");
        frameBuilder.writePacked64(timestamp);
        frameBuilder.writePacked64(timestamp);
        frameBuilder.writePacked64(0L);
        frameBuilder.writeString("nosync");
        frameBuilder.writeString("");
        frameBuilder.writeString("");
        frameWriter.writeFrame(frameBuilder.getData());
    }

    private static void writeTracepointFormat(int code, @NonNull APCFrameBuilder frameBuilder, @Nullable TracingData.FileRecord event) throws IOException {
        if (event != null && !event.getContents().isEmpty()) {
            frameBuilder.writePacked32(code);
            frameBuilder.writeCString(event.getContents());
        }
    }

    private static void writeTracepointFormats(@NonNull IAPCCaptureFrameWriter frameWriter, @NonNull TracingData tracingData) throws IOException {
        APCFrameBuilder frameBuilder = new APCFrameBuilder(11);
        frameBuilder.writePacked32(0);
        PerfToAPCTransformer.writeTracepointFormat(9, frameBuilder, tracingData.getKallsyms());
        PerfToAPCTransformer.writeTracepointFormat(11, frameBuilder, tracingData.getHeaderPage().getFile());
        PerfToAPCTransformer.writeTracepointFormat(12, frameBuilder, tracingData.getHeaderEvent().getFile());
        for (TracingData.TracepointRecord tracepoint : tracingData.getEventRecords()) {
            for (TracingData.FileRecord event : tracepoint.getEvents()) {
                PerfToAPCTransformer.writeTracepointFormat(3, frameBuilder, event);
            }
        }
        for (TracingData.FileRecord ftrace : tracingData.getFtraceRecords()) {
            PerfToAPCTransformer.writeTracepointFormat(3, frameBuilder, ftrace);
        }
        frameWriter.writeFrame(frameBuilder.getData());
    }

    public static @NonNull PerfToAPCTransformer create(@NonNull File inputFile, @NonNull IEventsXMLProvider exProvider) throws IOException, InvalidPerfDataException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream eventsStream = exProvider.getEventsXmlInputStream();){
            return new PerfToAPCTransformer(new DataFile(inputFile), new EventsXml(eventsStream));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public PerfToAPCTransformer(@NonNull IDataFile inputFile, @NonNull EventsXml eventsXml) throws InvalidPerfDataException {
        this.eventsXml = eventsXml;
        this.dataFile = inputFile;
        this.sharedSampleTypeBits = EventAttribute.validateSampleType(this.dataFile.getAttributes().keySet());
    }

    public void validate() throws InvalidPerfDataException, IOException {
        if (!this.dataFile.isHeaderFlagSet(HeaderFlags.HEADER_TRACING_DATA)) {
            for (EventAttribute attribute : this.dataFile.getAttributes().keySet()) {
                if (attribute.getType() != 2) continue;
                throw new InvalidPerfDataException(InvalidPerfDataException.Reason.MISSING_HEADER_TRACING_DATA);
            }
        }
        if (this.sharedSampleTypeBits == null) {
            throw new InvalidPerfDataException(InvalidPerfDataException.Reason.CANNOT_DECODE_ID);
        }
        for (EventAttribute attr : this.dataFile.getAttributes().keySet()) {
            boolean isEBS;
            if ((attr.getSampleType() & 4L) == 0L) {
                throw new InvalidPerfDataException(InvalidPerfDataException.Reason.MISSING_CMDLINE_ARG_T);
            }
            if (!attr.isFlagSet(EventAttribute.Flags.SAMPLE_ID_ALL)) {
                throw new InvalidPerfDataException(InvalidPerfDataException.Reason.NO_SAMPLE_ID_ALL);
            }
            boolean isSampleReadAvailable = (attr.getSampleType() & 0x10L) != 0L || attr.getType() == 2;
            boolean isFreqAndPeriodAvailable = attr.isFlagSet(EventAttribute.Flags.FREQ) && (attr.getSampleType() & 0x100L) != 0L;
            boolean bl = isEBS = !attr.isFlagSet(EventAttribute.Flags.FREQ) && attr.getSampleFreqOrPeriod() != 0L;
            if (isSampleReadAvailable || isFreqAndPeriodAvailable || isEBS) continue;
            throw new InvalidPerfDataException(InvalidPerfDataException.Reason.NO_SAMPLE_TYPE_READ_OR_FREQ_PERIOD);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTo(@NonNull File apcDirectory, @NonNull IPerfTransformMonitor monitor) throws IOException, InvalidPerfDataException, InterruptedException {
        if (!apcDirectory.exists() && !apcDirectory.mkdir()) {
            throw new IOException("Could not make output directory " + String.valueOf(apcDirectory));
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            APCCaptureFrameWriter frameWriter = new APCCaptureFrameWriter(apcDirectory);
            try {
                block25: {
                    FileOutputStream sessionXml = new FileOutputStream(new File(apcDirectory, "session.xml"));
                    try {
                        block24: {
                            FileOutputStream capturedXml = new FileOutputStream(new File(apcDirectory, "captured.xml"));
                            try {
                                try (FileOutputStream countersXml = new FileOutputStream(new File(apcDirectory, "counters.xml"));){
                                    this.writeTo((IAPCCaptureFrameWriter)frameWriter, sessionXml, capturedXml, countersXml, monitor);
                                }
                                if (capturedXml == null) break block24;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (capturedXml == null) throw throwable;
                                capturedXml.close();
                                throw throwable;
                            }
                            capturedXml.close();
                        }
                        if (sessionXml == null) break block25;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (sessionXml == null) throw throwable;
                        sessionXml.close();
                        throw throwable;
                    }
                    sessionXml.close();
                }
                if (frameWriter == null) return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (frameWriter == null) throw throwable;
                frameWriter.close();
                throw throwable;
            }
            frameWriter.close();
            return;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void writeTo(@NonNull IAPCCaptureFrameWriter frameWriter, @NonNull OutputStream sessionXml, @NonNull OutputStream capturedXml, @NonNull OutputStream counterXml, @NonNull IPerfTransformMonitor monitor) throws IOException, InvalidPerfDataException, InterruptedException {
        monitor.setProgress(IPerfTransformMonitor.ProgressStage.VALIDATING_INPUT, 1L);
        this.validate();
        long idBits = (Long)NullChecking.neverNull((Object)this.sharedSampleTypeBits);
        monitor.setProgress(IPerfTransformMonitor.ProgressStage.MAPPING_ATTRIBUTES_TO_IDS, 1L);
        IdToAttributeMap attributesById = new IdToAttributeMap(this.dataFile.getAttributes());
        IntFunction<@NonNull String> pmuNames = this.getPmuNames();
        ToIntFunction<@NonNull EventAttribute> keys = this.getKeys();
        Map<@NonNull EventAttribute, @NonNull String> attributeNames = this.getAttributeNames(pmuNames);
        monitor.setProgress(IPerfTransformMonitor.ProgressStage.COUNT_EVENT_RECORDS, 1L);
        long numberOfRecords = this.dataFile.getNumberOfRecords();
        monitor.setProgress(IPerfTransformMonitor.ProgressStage.EXAMINE_RECORDS, numberOfRecords);
        ClusterCoreMapping.ClusterCoreMappingBuilder clusterCoreMapBuilder = new ClusterCoreMapping.ClusterCoreMappingBuilder(this.dataFile, idBits, attributesById, pmuNames);
        CommEntry.CommEntryBuilder commEntriesBuilder = new CommEntry.CommEntryBuilder(this.dataFile, idBits, attributesById);
        StatsBuilder statsBuilder = new StatsBuilder(this.dataFile, idBits, attributesById);
        this.dataFile.processRecords(r -> {
            clusterCoreMapBuilder.process(r);
            statsBuilder.process(r);
            commEntriesBuilder.process(r);
            monitor.incProgress();
        });
        ClusterCoreMapping clusterCoreMap = clusterCoreMapBuilder.finish();
        Statistics stats = statsBuilder.finish();
        Object commEntries = commEntriesBuilder.finish();
        CapturedCounters capturedCounters = new CapturedCounters(monitor, pmuNames, attributeNames.entrySet(), keys, this.eventsXml, clusterCoreMap);
        monitor.setProgress(IPerfTransformMonitor.ProgressStage.PARSING_TRACING_DATA, 1L);
        TracingData tracingData = this.dataFile.getHeaderFlagValue(HeaderFlags.HEADER_TRACING_DATA);
        monitor.setProgress(IPerfTransformMonitor.ProgressStage.WRITING_APC, numberOfRecords);
        HashSet<@Nullable Long> attributeIdsWithSamples = new HashSet<Long>();
        PerfToAPCTransformer.writeSummaryFrame(frameWriter, stats.getEarliestTimestamp());
        PerfToAPCTransformer.writePerfAttributes(frameWriter, keys, this.dataFile.getAttributes().keySet());
        PerfToAPCTransformer.writePerfAttributeKeys(frameWriter, keys, this.dataFile.getAttributes());
        if (tracingData != null) {
            PerfToAPCTransformer.writeTracepointFormats(frameWriter, tracingData);
        }
        PerfToAPCTransformer.writeCommEntries(frameWriter, (List<CommEntry>)commEntries);
        APCFrameBuilder[] frameBuilder = new APCFrameBuilder[1];
        this.dataFile.processRecords(record -> {
            block6: {
                block7: {
                    Long attributeId;
                    EventAttribute attribute;
                    block8: {
                        monitor.incProgress();
                        if (this.removePerfRecord(record, idBits, attributesById)) break block6;
                        if (frameBuilder[0] == null) {
                            aPCFrameBuilderArray[0] = new APCFrameBuilder(12);
                        }
                        PerfToAPCTransformer.writePerfRecord((APCFrameBuilder)NullChecking.neverNull((Object)frameBuilder[0]), this.dataFile, idBits, attributesById, record);
                        if (frameBuilder[0].size() > 65536) {
                            frameWriter.writeFrame(frameBuilder[0].getData());
                            aPCFrameBuilderArray[0] = null;
                        }
                        if (record.getHeader().getType() != 9) break block7;
                        // Could not load outer class - annotation placement on inner may be incorrect
                        @NonNull RecordBlob.SampleRecord sample = record.parseSampleRecord(this.dataFile.getByteOrder(), idBits, attributesById);
                        attribute = sample.attribute;
                        attributeId = sample.getAttributeId();
                        ReadFormat readFormat = sample.getReadFormat();
                        if (readFormat == null) break block8;
                        long[] lArray = readFormat.getIds();
                        int n = lArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            long id = lArray[n2];
                            attributeIdsWithSamples.add(id);
                            ++n2;
                        }
                        break block6;
                    }
                    if (attribute == null || (attribute.getSampleType() & 0x100L) == 0L && attribute.getSampleFreqOrPeriod() == 0L) break block6;
                    attributeIdsWithSamples.add(attributeId);
                    break block6;
                }
                if (record.getHeader().getType() == 8) {
                    // Could not load outer class - annotation placement on inner may be incorrect
                    @NonNull RecordBlob.SampleId id = record.parseSampleId(this.dataFile.getByteOrder(), idBits, attributesById);
                    @NonNull EventAttribute attribute = id.attribute;
                    if (attribute != null) {
                        @NonNull @NonNull ByteBuffer buffer = this.dataFile.createByteBuffer(record.getPayload());
                        buffer.position(8);
                        ReadFormat readFormat = new ReadFormat(id.getAttributeId(), attribute.getReadFormat(), buffer::getLong);
                        long[] lArray = readFormat.getIds();
                        int n = lArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            long readId = lArray[n3];
                            attributeIdsWithSamples.add(readId);
                            ++n3;
                        }
                    }
                }
            }
        });
        if (frameBuilder[0] != null) {
            frameWriter.writeFrame(frameBuilder[0].getData());
        }
        Set<CapturedCounter> countersWithoutSamples = this.addUnusedCounterWarnings(capturedCounters, attributesById, attributeIdsWithSamples);
        PerfToAPCTransformer.writeSessionXml(sessionXml, this.dataFile.getHeaderFlagValue(HeaderFlags.HEADER_HOSTNAME));
        PerfToAPCTransformer.writeCapturedXml(capturedXml, this.dataFile.getTargetName(), clusterCoreMap.getCoreCount(), stats.getSampleRate(), capturedCounters, countersWithoutSamples);
        PerfToAPCTransformer.writeCountersXml(counterXml, this.eventsXml, clusterCoreMap, capturedCounters, this.warningMessages);
    }

    private void addCountersWarning(@NonNull String title, @NonNull String message, @NonNull Set<CapturedCounter> countersWithoutSamples) {
        ArrayList sortedNames = new ArrayList(countersWithoutSamples.stream().map(v -> v.getDisplayTitle()).collect(Collectors.toSet()));
        sortedNames.sort((a, b) -> a.compareTo((String)b));
        StringBuilder counterNames = new StringBuilder();
        int i = 0;
        while (i < sortedNames.size()) {
            if (i > 0) {
                if (i < sortedNames.size() - 1) {
                    counterNames.append(", ");
                } else {
                    counterNames.append(" " + PerfMessages.AND + " ");
                }
            }
            counterNames.append((String)sortedNames.get(i));
            ++i;
        }
        this.addWarning(title, (String)NullChecking.neverNull((Object)MessageFormat.format(message, counterNames)));
    }

    private @NonNull Set<CapturedCounter> addUnusedCounterWarnings(@NonNull CapturedCounters capturedCounters, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull RecordBlob.IIdToAttributeMap attributesById, @NonNull Set<@Nullable Long> attributeIdsWithSamples) throws InvalidPerfDataException {
        @NonNull Map<EventAttribute, CapturedCounter> map = capturedCounters.getMappings();
        HashSet<CapturedCounter> countersWithoutSamples = new HashSet<CapturedCounter>(map.values());
        for (Long id : attributeIdsWithSamples) {
            EventAttribute event = attributesById.getEventAttributeById(id);
            countersWithoutSamples.remove(map.get(event));
        }
        for (EventAttribute event : map.keySet()) {
            if (event.getType() != 2 || (event.getSampleType() & 0x400L) == 0L) continue;
            countersWithoutSamples.remove(map.get(event));
        }
        if (!countersWithoutSamples.isEmpty()) {
            this.addCountersWarning((String)NullChecking.neverNull((Object)PerfMessages.COUNTERS_WITHOUT_SAMPLES_TITLE), (String)NullChecking.neverNull((Object)PerfMessages.COUNTERS_WITHOUT_SAMPLES_MESSAGE), countersWithoutSamples);
        }
        return countersWithoutSamples;
    }

    private void addWarning(@NonNull String title, @NonNull String message) {
        this.warningMessages.put(title, message);
    }

    private boolean removePerfRecord(@NonNull RecordBlob r, long idBits, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull RecordBlob.IIdToAttributeMap attributesById) throws InvalidPerfDataException {
        if (r.getHeader().getType() == 7) {
            ByteBuffer buffer = this.dataFile.createByteBuffer(r.getPayload());
            int pid = buffer.getInt();
            int ppid = buffer.getInt();
            int tid = buffer.getInt();
            int ptid = buffer.getInt();
            long time = buffer.getLong();
            return time == 0L;
        }
        if (r.getHeader().getType() == 3) {
            long timestamp;
            RecordBlob.SampleId id = r.parseSampleId(this.dataFile.getByteOrder(), idBits, attributesById);
            long l = timestamp = id.time != null ? id.time : Long.MIN_VALUE;
            return timestamp == 0L || id.attribute == null;
        }
        return false;
    }

    private @NonNull Map<@NonNull EventAttribute, @NonNull String> getAttributeNames(@NonNull IntFunction<@NonNull String> pmuNames) throws IOException {
        String eventTypeInfo;
        Map<String, String> simplePerfMeta;
        Set<@NonNull EventAttribute> attributes = this.dataFile.getAttributes().keySet();
        HashMap<@NonNull EventAttribute, @NonNull String> result = new HashMap<EventAttribute, String>();
        List<@NonNull EventDescription> eventDescriptions = this.dataFile.getHeaderFlagValue(HeaderFlags.HEADER_EVENT_DESC);
        if (eventDescriptions != null) {
            eventDescriptions.stream().filter(e -> attributes.contains(e.getAttr())).forEach(e -> {
                String string = result.put(e.getAttr(), e.getName());
            });
        }
        if ((simplePerfMeta = this.dataFile.getHeaderFlagValue(HeaderFlags.HEADER_SIMPLEPERF_META_INFO)) != null && (eventTypeInfo = simplePerfMeta.get("event_type_info")) != null) {
            try {
                HashMap<// Could not load outer class - annotation placement on inner may be incorrect
                EventAndPmuNames.TypeAndConfig, @NonNull String> typeConfigMap = new HashMap<EventAndPmuNames.TypeAndConfig, String>();
                String[] stringArray = eventTypeInfo.split("\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String event = stringArray[n2];
                    @NonNull String[] parts = event.split(",");
                    if (parts.length != 3) {
                        throw new IllegalArgumentException();
                    }
                    String name = parts[0];
                    int type = Integer.parseUnsignedInt(parts[1]);
                    long config = Long.parseUnsignedLong(parts[2]);
                    typeConfigMap.put(new EventAndPmuNames.TypeAndConfig(type, config), name);
                    ++n2;
                }
                attributes.stream().forEach(a -> {
                    String name = (String)typeConfigMap.get(a.getTypeAndConfig());
                    if (name != null) {
                        result.put((EventAttribute)a, name);
                    }
                });
            }
            catch (IllegalArgumentException e2) {
                throw new InvalidPerfDataException(InvalidPerfDataException.Reason.BAD_META_INFO_EVENT_TYPE_INFO);
            }
        }
        String arch = this.dataFile.getHeaderFlagValue(HeaderFlags.HEADER_ARCH);
        attributes.stream().filter(a -> !result.containsKey(a)).forEach(a -> {
            String string2 = result.put((EventAttribute)a, EventAndPmuNames.getEventName((EventAndPmuNames.TypeAndConfig)a.getTypeAndConfig(), (String)arch, (IntFunction)pmuNames));
        });
        return result;
    }

    private @NonNull IntFunction<@NonNull String> getPmuNames() throws IOException {
        List<@NonNull PmuMapping> pmuMappings = this.dataFile.getHeaderFlagValue(HeaderFlags.HEADER_PMU_MAPPINGS);
        TIntObjectHashMap map = new TIntObjectHashMap();
        if (pmuMappings != null) {
            for (PmuMapping pmu : pmuMappings) {
                String prev = (String)map.put(pmu.getType(), (Object)pmu.getName());
                if (prev == null || prev.equals(pmu.getName())) continue;
                throw new IOException("Conflicting names '" + prev + "' and '" + pmu.getName() + "' for type " + pmu.getType());
            }
        }
        return arg_0 -> PerfToAPCTransformer.lambda$10((TIntObjectMap)map, arg_0);
    }

    private @NonNull ToIntFunction<@NonNull EventAttribute> getKeys() {
        int key = 16;
        TObjectIntHashMap map = new TObjectIntHashMap();
        for (EventAttribute entry : this.dataFile.getAttributes().keySet()) {
            map.put((Object)entry, key++);
        }
        return arg_0 -> ((TObjectIntMap)map).get(arg_0);
    }

    @Override
    public void close() throws IOException {
        this.dataFile.close();
    }

    private static /* synthetic */ String lambda$10(TIntObjectMap tIntObjectMap, int pmuType) {
        String name = (String)tIntObjectMap.get(pmuType);
        if (name != null) {
            return name;
        }
        return EventAndPmuNames.getPmuName((int)pmuType);
    }

    private static class StatsBuilder
    implements IParallelEventRecordProcessor<Statistics> {
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull RecordBlob.IIdToAttributeMap attributesById;
        private final @NonNull IDataFile dataFile;
        private final @NonNull Map<Long, Long> eventCounters = new HashMap<Long, Long>();
        private final long idBits;
        private final long @NonNull [] result = new long[]{Long.MAX_VALUE, Long.MIN_VALUE};

        public StatsBuilder(@NonNull IDataFile dataFile, long idBits, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull RecordBlob.IIdToAttributeMap attributesById) {
            this.dataFile = dataFile;
            this.idBits = idBits;
            this.attributesById = attributesById;
        }

        @Override
        public @NonNull Statistics finish() {
            return new Statistics(this.result[0], this.result[1], 1000L, this.eventCounters);
        }

        @Override
        public void process(@NonNull RecordBlob r) throws InvalidPerfDataException, IOException, InterruptedException {
            Long id;
            RecordBlob.SampleId sampleId = r.parseSampleId(this.dataFile.getByteOrder(), this.idBits, this.attributesById);
            Long time = sampleId.time;
            if (time != null) {
                this.result[0] = Math.min(this.result[0], time);
                this.result[1] = Math.max(this.result[1], time);
            }
            if ((id = sampleId.getAttributeId()) != null) {
                Long oldValue = this.eventCounters.get(id);
                this.eventCounters.put(id, (oldValue != null ? oldValue : 0L) + 1L);
            }
        }
    }
}

