/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.pa;

import com.arm.streamline.jni.apcdbgen.proto.ICAMDataProvider;
import com.arm.streamline.jni.apcdbgen.proto.ICAMJob;
import com.arm.streamline.jni.apcdbgen.proto.ICAMTrack;
import com.arm.streamline.model.timeline.ProcessData;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class StreamlineGaData {
    private final @NonNull List<@NonNull ICAMJob> camJobs;
    private final @NonNull Optional<ICAMDataProvider> camModel;
    private final @Nullable ProcessData camModelProcess;

    public StreamlineGaData(@Nullable ICAMDataProvider model, @Nullable ProcessData camModelProcess) {
        this.camModel = Optional.ofNullable(model);
        this.camJobs = model == null ? Collections.emptyList() : model.getAllJobsAsList();
        this.camModelProcess = camModelProcess;
    }

    public @NonNull Stream<@NonNull ICAMJob> getAllCamJobs() {
        return this.camJobs.stream();
    }

    public @NonNull Stream<@NonNull ICAMJob> getCamJobsForContext(String name) {
        return this.camJobs.stream().filter(job -> this.jobIsInContext((ICAMJob)job, name)).filter(job -> job.getName().startsWith("Frame #"));
    }

    public @NonNull String guessPrimaryContextName() {
        if (this.camModel.isEmpty()) {
            return "";
        }
        Map<ICAMTrack, Integer> jobCountsByTrack = this.camJobs.stream().collect(Collectors.groupingBy(ICAMJob::getTrack, Collectors.reducing(0, job -> 1, Integer::sum)));
        return jobCountsByTrack.entrySet().stream().max((a, b) -> (Integer)a.getValue() - (Integer)b.getValue()).map(Map.Entry::getKey).map(ICAMTrack::getParent).map(parent -> parent == null ? "" : parent.getTitle()).orElse("");
    }

    public int getCamJobsSize() {
        return this.camJobs.size();
    }

    public String getCamJobName(int job) {
        return this.camJobs.get(job).getName();
    }

    public long getCamJobStartTime(int job) {
        return this.camJobs.get(job).getStartTime();
    }

    public long getCamJobStopTime(int job) {
        return this.camJobs.get(job).getStopTime();
    }

    private boolean jobIsInContext(ICAMJob job, String contextTitle) {
        if (contextTitle == null || contextTitle.isEmpty()) {
            return true;
        }
        if (!job.getTrack().getTitle().equals("Frames")) {
            return false;
        }
        if (this.camModel.isEmpty()) {
            return false;
        }
        ICAMTrack parent = job.getTrack().getParent();
        return parent != null && parent.getTitle().contains(contextTitle);
    }

    public @Nullable ProcessData getCamModelProcess() {
        return this.camModelProcess;
    }
}

