/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.timeline;

import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.widget.lightweight.IBlockContentProposalProvider;
import com.arm.utils.text.NumericStringComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;

public class VariableContentProposalProvider
implements IBlockContentProposalProvider,
Comparator<IContentProposal> {
    private static final char[] ACTIVATION_CHARS = new char[]{'$'};
    private ICaptureDataProvider mDataProvider;

    private static final int findLeftEdge(String contents, int pos) {
        int i = pos;
        while (--i >= 0) {
            char ch = contents.charAt(i);
            if (ch == '_' || ch == '.' || Character.isLetterOrDigit(ch)) continue;
            return ch == '$' ? i : i + 1;
        }
        return 0;
    }

    public VariableContentProposalProvider(ICaptureDataProvider provider) {
        this.mDataProvider = provider;
    }

    @Override
    public final int compare(IContentProposal o1, IContentProposal o2) {
        String t2;
        String t1 = o1.getLabel();
        if (t1 == null) {
            t1 = o1.getContent();
        }
        if ((t2 = o2.getLabel()) == null) {
            t2 = o2.getContent();
        }
        return NumericStringComparator.caselessCompareStrings((String)t1, (String)t2);
    }

    @Override
    public final int[] findRange(String contents, int left, int right) {
        left = VariableContentProposalProvider.findLeftEdge(contents, left);
        int max = contents.length();
        while (right < max) {
            char ch = contents.charAt(right);
            if (ch != '_' && ch != '.' && !Character.isLetterOrDigit(ch)) break;
            ++right;
        }
        if (right < left) {
            right = left;
        }
        return new int[]{left, right};
    }

    @Override
    public char[] getAutoActivationCharacters() {
        return ACTIVATION_CHARS;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        int right;
        List<ContentProposal> all = this.mDataProvider.getContentProposals();
        if (all == null || all.isEmpty()) {
            return new IContentProposal[0];
        }
        ArrayList<Object> proposals = new ArrayList<Object>();
        int left = VariableContentProposalProvider.findLeftEdge((String)contents, position);
        if (left == (right = Math.max(position, left))) {
            proposals.addAll(all);
        } else {
            if (!((String)(contents = ((String)contents).substring(left, right))).startsWith("$")) {
                contents = "$" + (String)contents;
            }
            contents = ((String)contents).toLowerCase();
            for (IContentProposal iContentProposal : all) {
                if (!iContentProposal.getContent().toLowerCase().startsWith((String)contents)) continue;
                proposals.add(iContentProposal);
            }
        }
        Collections.sort(proposals, this);
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }
}

