/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.timeline;

import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.capture.IProcessDataProvider;
import com.arm.streamline.model.capture.IProcessListener;
import com.arm.streamline.model.process.IProcessCounter;
import com.arm.streamline.model.process.ITimelineRowProvider;
import com.arm.streamline.model.process.TimelineRow;
import com.arm.streamline.model.process.TimelineRowType;
import com.arm.streamline.model.timeline.ProcessData;
import com.arm.streamline.model.timeline.ProcessIdentifierRegex;
import com.arm.utils.NullChecking;
import com.arm.utils.OptionalUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;

public class TimelineProcessDataProvider
implements IProcessDataProvider {
    private final @NonNull Analysis mAnalysis;
    private final @NonNull List<@NonNull ProcessData> mProcessAndThreadsList = new ArrayList<ProcessData>();
    private @NonNull List<@NonNull IProcessCounter> mProcessCounters;
    private final @NonNull List<@NonNull ProcessData> mProcessOnlyList = new ArrayList<ProcessData>();
    private final @NonNull List<@NonNull ProcessData> mThreadOnlyList = new ArrayList<ProcessData>();
    private final @NonNull List<@NonNull IProcessListener> processListeners = new ArrayList<IProcessListener>();
    private @NonNull IProcessDataProvider.ThreadMode threadMode = IProcessDataProvider.ThreadMode.PROCESS_AND_THREADS;

    public TimelineProcessDataProvider(@NonNull Analysis analysis) {
        this.mAnalysis = analysis;
        this.mProcessCounters = IProcessCounter.findProcessCounters(analysis);
        List<@NonNull ITimelineRowProvider> processLevelTimelineRows = this.mAnalysis.getMapProvider().getProcessLevelTimelineRows();
        block5: for (ITimelineRowProvider row : processLevelTimelineRows) {
            if (row.isIdle()) continue;
            boolean isKernel = row.isKernel();
            boolean anyThreads = false;
            switch (row.getRowType()) {
                case GROUP: 
                case ANNOTATION: 
                case VMUID: 
                case CPU: {
                    break;
                }
                case PROCESS: {
                    boolean added;
                    if (!this.addProcessRow(row, isKernel)) {
                        added = this.addThreadRowAsProcessAndThread(row, isKernel);
                        assert (added);
                        anyThreads = true;
                    }
                    for (ITimelineRowProvider childRow : row.getChildren()) {
                        if (childRow.getRowType() != TimelineRowType.THREAD || row.getUID() == childRow.getUID()) continue;
                        anyThreads = true;
                        boolean added2 = this.addThreadRow(childRow, isKernel);
                        assert (added2);
                    }
                    if (anyThreads) continue block5;
                    added = this.addProcessRowAsThread(row, isKernel);
                    assert (added);
                    continue block5;
                }
                case THREAD: {
                    boolean added = this.addThreadRowAsProcessAndThread(row, isKernel);
                    assert (added);
                    continue block5;
                }
                default: {
                    throw new AssertionError((Object)row.getRowType());
                }
            }
        }
    }

    @Override
    public final synchronized void addProcessListener(@NonNull IProcessListener listener) {
        this.processListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull List<@NonNull IProcessDataProvider.ColumnLabel> getColumns() {
        List<IProcessCounter> mProcessCounters;
        TimelineProcessDataProvider timelineProcessDataProvider = this;
        synchronized (timelineProcessDataProvider) {
            mProcessCounters = this.mProcessCounters;
        }
        return mProcessCounters.stream().map(c -> new IProcessDataProvider.ColumnLabel(c.getTitle(), c.getDescription(), c.isPercentage(), c.isDefaultSortItem(), c.getColourPreference(), c.getChartRGB())).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getColumnValue(int columnIndex, int start, int end, @NonNull ProcessData processData) {
        List<IProcessCounter> mProcessCounters;
        TimelineProcessDataProvider timelineProcessDataProvider = this;
        synchronized (timelineProcessDataProvider) {
            mProcessCounters = this.mProcessCounters;
        }
        if (columnIndex < 0 || columnIndex >= mProcessCounters.size()) {
            return -1L;
        }
        return mProcessCounters.get(columnIndex).getData(start, end, processData.getUID(), processData.isKernel());
    }

    @Override
    public @NonNull List<@NonNull ProcessData> getProcessData(@NonNull IProcessDataProvider.ThreadMode threadMode) {
        switch (threadMode) {
            case PROCESS_AND_THREADS: {
                return this.mProcessAndThreadsList;
            }
            case PROCESS_ONLY: {
                return this.mProcessOnlyList;
            }
            case THREAD_ONLY: {
                return this.mThreadOnlyList;
            }
        }
        throw new AssertionError((Object)threadMode);
    }

    @Override
    public @NonNull List<@NonNull ProcessData> getSpecificProcessData(@NonNull String processNameRegex, @NonNull IProcessDataProvider.ThreadMode threadMode) {
        List<ProcessData> dataList = this.getProcessData(threadMode);
        try {
            ProcessIdentifierRegex processIdentifierRegex = ProcessIdentifierRegex.parse(processNameRegex);
            ArrayList<ProcessData> ret = new ArrayList<ProcessData>();
            for (ProcessData pd : dataList) {
                if (!processIdentifierRegex.match(pd.getNameAndPid())) continue;
                ret.add(pd);
            }
            return ret;
        }
        catch (NumberFormatException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public @NonNull IProcessDataProvider.ThreadMode getThreadMode() {
        return this.threadMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyChartsChanged() {
        IProcessListener[] listeners;
        TimelineProcessDataProvider timelineProcessDataProvider = this;
        synchronized (timelineProcessDataProvider) {
            listeners = this.processListeners.toArray(new IProcessListener[this.processListeners.size()]);
            this.mProcessCounters = IProcessCounter.findProcessCounters(this.mAnalysis);
        }
        IProcessListener[] iProcessListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessListener listener = iProcessListenerArray[n2];
            listener.notifyChartsChanged();
            ++n2;
        }
    }

    @Override
    public final synchronized void removeProcessListener(@NonNull IProcessListener listener) {
        this.processListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadMode(@NonNull IProcessDataProvider.ThreadMode threadMode) {
        IProcessListener[] listeners;
        TimelineProcessDataProvider timelineProcessDataProvider = this;
        synchronized (timelineProcessDataProvider) {
            this.threadMode = threadMode;
            listeners = this.processListeners.toArray(new IProcessListener[this.processListeners.size()]);
        }
        IProcessListener[] iProcessListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessListener listener = iProcessListenerArray[n2];
            listener.setThreadMode(threadMode);
            ++n2;
        }
    }

    private boolean addProcessRow(@NonNull ITimelineRowProvider row, boolean isKernel) {
        return this.addProcessRowCommon(row, isKernel, false);
    }

    private boolean addProcessRowAsThread(@NonNull ITimelineRowProvider row, boolean isKernel) {
        return this.addProcessRowCommon(row, isKernel, true);
    }

    private boolean addProcessRowCommon(@NonNull ITimelineRowProvider row, boolean isKernel, boolean asThreadOnly) {
        assert (row.getRowType() == TimelineRowType.PROCESS);
        String processName = (String)NullChecking.neverNull((Object)((TimelineRow)row).getBaseName());
        int uid = row.getUID();
        Optional process = this.mAnalysis.getUniqueIdMap().findProcess(uid);
        if (!process.isPresent()) {
            return false;
        }
        if (asThreadOnly) {
            this.mThreadOnlyList.add(new ProcessData(this.mThreadOnlyList.size(), uid, OptionalUtils.mapToInt((Optional)process, i -> i.getOriginalID()).orElse(-2), processName, true, isKernel));
        } else {
            this.mProcessOnlyList.add(new ProcessData(this.mProcessOnlyList.size(), uid, OptionalUtils.mapToInt((Optional)process, i -> i.getOriginalID()).orElse(-2), processName, false, isKernel));
            this.mProcessAndThreadsList.add(new ProcessData(this.mProcessAndThreadsList.size(), uid, OptionalUtils.mapToInt((Optional)process, i -> i.getOriginalID()).orElse(-2), processName, false, isKernel));
        }
        return true;
    }

    private boolean addThreadRow(@NonNull ITimelineRowProvider row, boolean isKernel) {
        return this.addThreadRowCommon(row, isKernel, false);
    }

    private boolean addThreadRowAsProcessAndThread(@NonNull ITimelineRowProvider row, boolean isKernel) {
        return this.addThreadRowCommon(row, isKernel, true);
    }

    private boolean addThreadRowCommon(@NonNull ITimelineRowProvider row, boolean isKernel, boolean andMasqueradeAsProcess) {
        assert (row.getRowType() == TimelineRowType.PROCESS || row.getRowType() == TimelineRowType.THREAD);
        String threadName = (String)NullChecking.neverNull((Object)((TimelineRow)row).getBaseName());
        int uid = row.getUID();
        Optional thread = this.mAnalysis.getUniqueIdMap().findThread(uid);
        if (!thread.isPresent()) {
            return false;
        }
        this.mThreadOnlyList.add(new ProcessData(this.mThreadOnlyList.size(), uid, OptionalUtils.mapToInt((Optional)thread, i -> i.getOriginalID()).orElse(-2), threadName, true, isKernel));
        this.mProcessAndThreadsList.add(new ProcessData(this.mProcessAndThreadsList.size(), uid, OptionalUtils.mapToInt((Optional)thread, i -> i.getOriginalID()).orElse(-2), threadName, true, isKernel));
        if (andMasqueradeAsProcess) {
            this.mProcessOnlyList.add(new ProcessData(this.mProcessOnlyList.size(), uid, OptionalUtils.mapToInt((Optional)thread, i -> i.getOriginalID()).orElse(-2), threadName, false, isKernel));
        }
        return true;
    }
}

