/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.timeline;

import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.annotation.VisualAnnotationData;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.capture.ChartConfig;
import com.arm.streamline.model.capture.ChartCoreInformationProvider;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.capture.IWildcardSeriesDataProvider;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.model.capture.WildcardSeriesConfig;
import com.arm.streamline.model.timeline.TimelineSeriesDataProvider;
import com.arm.streamline.model.timeline.TimelineWildcardSeriesDataProvider;
import com.arm.streamline.report.model.pe.ProcessingElementTopology;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TimelineChartDataProvider
implements IChartDataProvider {
    private static final double FLOAT_COMPARISON_OF_1 = 1.000001;
    private final @NonNull Analysis mAnalysis;
    private final @NonNull List<@NonNull ISeriesDataProvider> mSeries;
    private final @NonNull ChartConfig mChartConfig;
    private final @NonNull IChartDataProvider.IChartCoreInformationProvider coreInformationProvider;
    private final @NonNull List<@NonNull IWildcardSeriesDataProvider> wildCardSeries;

    public TimelineChartDataProvider(final @NonNull Analysis analysis, @NonNull ChartConfig config) {
        this.mAnalysis = analysis;
        this.mChartConfig = config;
        this.mSeries = new ArrayList<ISeriesDataProvider>();
        this.wildCardSeries = new ArrayList<IWildcardSeriesDataProvider>();
        this.coreInformationProvider = new ChartCoreInformationProvider(this.mSeries){

            @Override
            public @Nullable ProcessingElementTopology getTopology(@NonNull ProcessingElementReference peReference) {
                return analysis.getProcessingElementTopology(peReference);
            }

            @Override
            public @Nullable String getVmName(@NonNull ProcessingElementReference peReference) {
                return analysis.getVmName(peReference.vmUID);
            }

            @Override
            protected @NonNull IBinDataProvider getBinDataProvider(@NonNull String source) {
                return TimelineChartDataProvider.this.getBinDataProvider(source);
            }

            @Override
            protected @Nullable String getCoreName(@NonNull ProcessingElementReference peReference) {
                return analysis.getClusterNameFromProcessingElementReference(peReference);
            }

            @Override
            protected int getCoreIndex(@NonNull ProcessingElementReference peReference) {
                if (!$assertionsDisabled && !peReference.deviceType.isCPU()) {
                    throw new AssertionError();
                }
                return analysis.getCoreIndexFromProcessingElementReference(peReference);
            }

            @Override
            public boolean hasMultipleVms() {
                return analysis.hasMultipleVms();
            }

            @Override
            public int getRelativeCoreID(@NonNull ProcessingElementReference peReference) {
                if (!$assertionsDisabled && !peReference.deviceType.isCPU()) {
                    throw new AssertionError();
                }
                int coreIndex = analysis.getCoreIndexFromProcessingElementReference(peReference);
                return analysis.getRelativeCoreID(coreIndex);
            }
        };
    }

    @Override
    public boolean canCoresBeAveraged() {
        return this.coreInformationProvider.getChannelCount() > 1;
    }

    @Override
    public final @NonNull TimelineSeriesDataProvider createSeries(int index, @NonNull SeriesConfig config) {
        TimelineSeriesDataProvider series = new TimelineSeriesDataProvider(this.mAnalysis, this, config);
        this.mSeries.add(index, series);
        this.mAnalysis.notifyChartsChanged();
        return series;
    }

    @Override
    public final @NonNull TimelineSeriesDataProvider createSeries(@NonNull SeriesConfig config) {
        TimelineSeriesDataProvider series = new TimelineSeriesDataProvider(this.mAnalysis, this, config);
        this.mSeries.add(series);
        this.mAnalysis.notifyChartsChanged();
        return series;
    }

    @Override
    public double getAggregateLimit() {
        if (this.isPercentage()) {
            return 1.0;
        }
        return this.getNonPercentageLimit(false);
    }

    @Override
    public ICaptureDataProvider getCaptureDataProvider() {
        return this.mAnalysis;
    }

    @Override
    public double getCoreLimit() {
        if (this.isPercentage()) {
            return 1.0;
        }
        return this.getNonPercentageLimit(true);
    }

    @Override
    public int getHeight() {
        return this.mChartConfig.getHeight();
    }

    public double getNonPercentageLimit(boolean perCore) {
        if (this.mSeries.size() == 0) {
            return 0.0;
        }
        double limit = perCore ? this.mSeries.get(0).getCoreLimit() : this.mSeries.get(0).getAggregateLimit();
        boolean seriesLimitsAreLessThanOne = limit <= 1.000001;
        int index = 1;
        while (index < this.mSeries.size()) {
            double thisLimit;
            double d = thisLimit = perCore ? this.mSeries.get(index).getCoreLimit() : this.mSeries.get(index).getAggregateLimit();
            if (this.getSeriesComposition() == SeriesComposition.STACKED) {
                limit += thisLimit;
                seriesLimitsAreLessThanOne = seriesLimitsAreLessThanOne && thisLimit <= 1.000001;
            } else if (thisLimit > limit) {
                limit = thisLimit;
            }
            ++index;
        }
        if (seriesLimitsAreLessThanOne && this.getSeriesComposition() == SeriesComposition.STACKED && limit > 1.0) {
            limit = 1.0;
        }
        return limit;
    }

    @Override
    public GraphRenderingType getRenderingType() {
        return this.mChartConfig.getRenderingType();
    }

    @Override
    public List<ISeriesDataProvider> getSeries() {
        return this.mSeries;
    }

    @Override
    public SeriesComposition getSeriesComposition() {
        return this.mChartConfig.getSeriesComposition();
    }

    @Override
    public String getTitle() {
        return this.getCaptureDataProvider().getVariableReplacer().replace(this.getTitleFormat());
    }

    @Override
    public @NonNull String getTitleFormat() {
        return this.mChartConfig.getTitle();
    }

    @Override
    public String getUnits() {
        String units = null;
        for (ISeriesDataProvider series : this.mSeries) {
            String seriesUnits = series.getConfig().getUnits();
            if (units == null) {
                units = seriesUnits;
                continue;
            }
            if (units.equals(seriesUnits)) continue;
            units = "";
        }
        return units;
    }

    @Override
    public VisualAnnotationData getVisualAnnotationData() {
        return null;
    }

    @Override
    public boolean isAverageCores() {
        return this.mChartConfig.isAverageCores();
    }

    @Override
    public boolean isAverageSelection() {
        return this.mChartConfig.isAverageSelection();
    }

    @Override
    public boolean isOpen() {
        return this.mChartConfig.isOpen();
    }

    @Override
    public boolean isPercentage() {
        return this.mChartConfig.isPercentage();
    }

    @Override
    public void setAverageCores(boolean average) {
        if (this.isAverageCores() != average) {
            this.mChartConfig.setAverageCores(average);
            if (this.canCoresBeAveraged()) {
                this.initializeLimits();
            }
        }
    }

    @Override
    public void setAverageSelection(boolean average) {
        this.mChartConfig.setAverageSelection(average);
    }

    @Override
    public void setHeight(int height) {
        this.mChartConfig.setHeight(height);
    }

    @Override
    public void setOpen(boolean open) {
        this.mChartConfig.setOpen(open);
    }

    @Override
    public void setPercentage(boolean percentage) {
        this.mChartConfig.setPercentage(percentage);
    }

    @Override
    public void setRenderingType(GraphRenderingType renderingType) {
        this.mChartConfig.setRenderingType(renderingType);
    }

    @Override
    public void setSeriesComposition(SeriesComposition seriesComposition) {
        this.mChartConfig.setSeriesComposition(seriesComposition);
    }

    @Override
    public void setTitleFormat(String title) {
        this.mChartConfig.setTitle(title);
    }

    public String toString() {
        return "CounterChart: " + this.getTitle();
    }

    protected @NonNull IBinDataProvider getBinDataProvider(@NonNull String source) {
        return (IBinDataProvider)NullChecking.neverNull((Object)this.mAnalysis.getAllBinData().getBinData(source));
    }

    private void initializeLimits() {
        for (ISeriesDataProvider series : this.mSeries) {
            series.initializeLimits();
        }
    }

    @Override
    public @NonNull IChartDataProvider.IChartCoreInformationProvider getCoreInformationProvider() {
        return this.coreInformationProvider;
    }

    @Override
    public void remove(ISeriesDataProvider series) {
        this.mSeries.remove(series);
        this.mAnalysis.notifyChartsChanged();
    }

    @Override
    public @NonNull ChartConfig getChartConfig() {
        return this.mChartConfig;
    }

    @Override
    public boolean isHeatMapLineEnabled() {
        return this.mChartConfig.isHeatMapLineEnabled();
    }

    @Override
    public void setHeatMapLineEnabled(boolean heatMapEnabled) {
        this.mChartConfig.setHeatMapLineEnabled(heatMapEnabled);
    }

    @Override
    public @NonNull IWildcardSeriesDataProvider createWildcardSeries(@NonNull WildcardSeriesConfig config) {
        TimelineWildcardSeriesDataProvider wildcardSeriesDataProvider = new TimelineWildcardSeriesDataProvider(config);
        this.wildCardSeries.add(wildcardSeriesDataProvider);
        this.mAnalysis.notifyChartsChanged();
        return wildcardSeriesDataProvider;
    }

    @Override
    public @NonNull List<@NonNull IWildcardSeriesDataProvider> getWildcardSeries() {
        return this.wildCardSeries;
    }

    @Override
    public void remove(@NonNull IWildcardSeriesDataProvider wildCardSeriesDataProvider) {
        this.wildCardSeries.remove(wildCardSeriesDataProvider);
    }
}

