/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.timeline;

import com.arm.utils.collections.Pair;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ProcessIdentifierRegex {
    private static final char REGEX_PID_SEPARATOR = '#';
    public static final @NonNull ProcessIdentifierRegex MATCH_ANY = new ProcessIdentifierRegex(null, null);
    private static final @NonNull Integer NO_PID_FOUND = -99;
    private final @Nullable Pattern regex;
    private final @Nullable Integer pid;

    public ProcessIdentifierRegex(@Nullable String regex, @Nullable Integer pid) {
        this.regex = regex == null ? null : Pattern.compile(regex);
        this.pid = pid;
    }

    public boolean match(@NonNull Pair<@NonNull String, @NonNull Integer> processThreadPair) {
        boolean regexMatched = this.matchWithPattern((String)processThreadPair.first);
        boolean pidMatched = this.matchPid((Integer)processThreadPair.second);
        return regexMatched && pidMatched;
    }

    private boolean matchWithPattern(@NonNull String name) {
        if (this.regex != null) {
            return this.regex.matcher(name).find();
        }
        return true;
    }

    private boolean matchPid(@Nullable Integer otherPid) {
        if (this.pid != null) {
            return this.pid.equals(otherPid);
        }
        return true;
    }

    public static @NonNull ProcessIdentifierRegex parse(@NonNull String argValue) {
        Pair<String, Integer> pair = ProcessIdentifierRegex.getNameAndPidPair(argValue);
        if (((Integer)pair.second).equals(NO_PID_FOUND)) {
            return new ProcessIdentifierRegex((String)pair.first, null);
        }
        return new ProcessIdentifierRegex((String)pair.first, (Integer)pair.second);
    }

    public static @NonNull Pair<@NonNull String, @NonNull Integer> getNameAndPidPair(@NonNull String argValue) {
        if ("".equals(argValue)) {
            throw new PatternSyntaxException("Regex cannot be empty", argValue, 0);
        }
        int pidIndex = argValue.lastIndexOf(35);
        if (pidIndex == -1) {
            return new Pair((Object)argValue, (Object)NO_PID_FOUND);
        }
        String pName = argValue.substring(0, pidIndex);
        String pid = argValue.substring(pidIndex + 1);
        try {
            int pidInt = Integer.parseInt(pid);
            return new Pair((Object)pName, (Object)pidInt);
        }
        catch (NumberFormatException e) {
            return new Pair((Object)argValue, (Object)NO_PID_FOUND);
        }
    }
}

