/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.timeline;

import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.utils.collections.Pair;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ProcessData {
    private boolean mExited;
    private final int mIndex;
    private final boolean mIsThread;
    private final boolean mKernel;
    private final int mPID;
    private final @Nullable IUniqueThread mProcess;
    private @NonNull String mProcessName;
    private final int mUID;

    public ProcessData(int index, int uid, int pid, @NonNull String processName, boolean thread, boolean kernel) {
        this.mIndex = index;
        this.mUID = uid;
        this.mPID = pid;
        this.mProcess = null;
        this.mProcessName = processName;
        this.mIsThread = thread;
        this.mKernel = kernel;
    }

    public ProcessData(int index, int uid, @NonNull IUniqueThread process, @NonNull String processName, boolean thread, boolean kernel) {
        this.mIndex = index;
        this.mUID = uid;
        this.mPID = process.getOriginalID();
        this.mProcess = process;
        this.mProcessName = processName;
        this.mIsThread = thread;
        this.mKernel = kernel;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProcessData) {
            return this.mUID == ((ProcessData)obj).mUID;
        }
        return false;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public @NonNull Pair<@NonNull String, @NonNull Integer> getNameAndPid() {
        return new Pair((Object)this.mProcessName, (Object)this.mPID);
    }

    public @Nullable IUniqueThread getProcess() {
        return this.mProcess;
    }

    public int getProcessID() {
        return this.mPID;
    }

    public @NonNull String getProcessName() {
        return this.mProcessName;
    }

    public int getUID() {
        return this.mUID;
    }

    public boolean hasExited() {
        return this.mExited;
    }

    public int hashCode() {
        return this.mUID;
    }

    public boolean isKernel() {
        return this.mKernel;
    }

    public boolean isThread() {
        return this.mIsThread;
    }

    public void setExited(boolean exited) {
        this.mExited = exited;
    }

    public void setProcessName(@NonNull String processName) {
        this.mProcessName = processName;
    }
}

