/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.templates;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.preferences.CommonPreferences;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.model.templates.ITemplatePath;
import com.arm.streamline.model.templates.TemplatesMessages;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

public class TemplatePath
implements ITemplatePath {
    public static final @NonNull File DEFAULT_DIR;
    public static final @NonNull String TEMPLATE_EXTENSION = ".st";
    public static final @NonNull Set<@NonNull String> STOCK_NAMES;
    public static final @NonNull String TEMPLATE_RESOURCES_DIR = "/resources/templates/stock/";
    public static final @NonNull String TEMPLATE_RESOURCES_LIST = "/resources/templates/stock/directory.xml";
    private static final String BUILT_IN = "[Built-in]";
    private final @NonNull String mName;
    private final boolean mStock;
    private final @Nullable File templateFile;

    static {
        block2: {
            DEFAULT_DIR = new File(CommonPreferences.getDefaultDocumentPath(), "Templates");
            STOCK_NAMES = new LinkedHashSet<String>();
            DEFAULT_DIR.mkdirs();
            try {
                @NonNull BuiltinTemplateDirectory builtin = TemplatePath.loadBuiltinDirectory();
                builtin.templates.forEach(t -> {
                    boolean bl = STOCK_NAMES.add(t.name);
                });
            }
            catch (IOException e) {
                StdLog.warning((Plugin)StreamlinePlugin.getInstance(), (String)"Could not load builtin template list", (Throwable)e);
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    protected static @NonNull BuiltinTemplateDirectory loadBuiltinDirectory() throws IOException {
        try {
            try {
                Throwable throwable = null;
                Object var1_5 = null;
                try (InputStream is = TemplatePath.class.getResourceAsStream(TEMPLATE_RESOURCES_LIST);){
                    @NonNull Persister serializer = new Persister();
                    return (BuiltinTemplateDirectory)serializer.read(BuiltinTemplateDirectory.class, is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (IOException | Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public static @NonNull TemplatePath resolveTemplatePath(@NonNull String template) throws FileNotFoundException {
        String basename;
        if (STOCK_NAMES.contains(template)) {
            return new TemplatePath(template, true);
        }
        if (template.startsWith(BUILT_IN) && STOCK_NAMES.contains(basename = template.substring(BUILT_IN.length()).trim())) {
            return new TemplatePath(basename, true);
        }
        @NonNull File defaultFile = new File(DEFAULT_DIR, template);
        if (defaultFile.isFile()) {
            return new TemplatePath(defaultFile);
        }
        @NonNull File file = new File(template);
        if (!file.isFile()) {
            throw new FileNotFoundException(MessageFormat.format(TemplatesMessages.TEMPLATE_NOT_EXISTS, template));
        }
        if (!file.getName().endsWith(TEMPLATE_EXTENSION)) {
            throw new FileNotFoundException(MessageFormat.format(TemplatesMessages.ONLY_ST_SUPPORTED, file.getName()));
        }
        return new TemplatePath(file);
    }

    public static final boolean isNamePermitted(File file) {
        return TemplatePath.isNamePermitted(FilePath.getLeafName((String)file.getName(), (boolean)false));
    }

    public static final boolean isNamePermitted(String name) {
        return !STOCK_NAMES.contains(name);
    }

    public TemplatePath(File file) {
        this.mName = FilePath.getLeafName((String)file.getName(), (boolean)false);
        this.templateFile = file;
        this.mStock = false;
    }

    public TemplatePath(@NonNull String name, boolean stock) {
        this.mName = name;
        this.mStock = stock;
        @NonNull String templateFileNameWithXtn = name + TEMPLATE_EXTENSION;
        this.templateFile = stock ? null : new File(DEFAULT_DIR, templateFileNameWithXtn);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TemplatePath) {
            TemplatePath other = (TemplatePath)obj;
            return this.mStock == other.mStock && this.mName.equals(other.mName);
        }
        return false;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    public final int hashCode() {
        return 31 * (31 + this.mName.hashCode()) + (this.mStock ? 1231 : 1237);
    }

    @Override
    public final boolean isStock() {
        return this.mStock;
    }

    @Override
    public final @NonNull InputStream openInputStream() throws FileNotFoundException {
        if (this.mStock) {
            String resource = TEMPLATE_RESOURCES_DIR + this.mName + TEMPLATE_EXTENSION;
            return (InputStream)NullChecking.neverNullOrThrow((Object)TemplatePath.class.getResourceAsStream(resource), () -> new FileNotFoundException("resource: " + resource));
        }
        return new FileInputStream(this.toFile());
    }

    @Override
    public final OutputStream openOutputStream() throws FileNotFoundException {
        if (this.mStock) {
            throw new FileNotFoundException(this.mName + TEMPLATE_EXTENSION);
        }
        return new FileOutputStream(this.toFile());
    }

    @Override
    public final @Nullable File toFile() {
        return this.templateFile;
    }

    public static class BuiltinTemplate {
        @Attribute(name="name", required=true)
        public @NonNull String name;
    }

    @Root(name="templates")
    public static class BuiltinTemplateDirectory {
        @ElementList(required=true, empty=false, inline=true, entry="template", type=BuiltinTemplate.class)
        public @NonNull List<@NonNull BuiltinTemplate> templates;
    }
}

