/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.templates;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.InvalidVersionException;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.ChartAndSeriesXMLParser;
import com.arm.streamline.model.templates.ITemplate;
import com.arm.streamline.model.templates.ITemplatePath;
import com.arm.streamline.model.templates.TemplatePath;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.ObjBoolPair;
import gnu.trove.set.TIntSet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TemplateFile
implements Cloneable,
Comparable<TemplateFile>,
ITemplate {
    public static final String TAG = "template";
    private static final String ATTR_EXPAND_CLUSTER = "expand_clusters";
    private static final String ATTR_ID = "id";
    private static final String ATTR_VERSION = "version";
    private static final int CURRENT_VERSION = 2;
    private static final int MINIMUM_VERSION = 2;
    private static final String TAG_SELECT_METRIC = "select-metric";
    private static final String TAG_SUPPORTED_CPUID = "supported-cpuid";
    private static final String TAG_SUPPORTED_GPUID = "supported-gpuid";
    private final @NonNull List<@NonNull ChartAndSeriesConfig> mCharts = new ArrayList<ChartAndSeriesConfig>();
    private @Nullable ITemplatePath mPath;
    private final @NonNull Set<@NonNull String> selectedMetrics = new HashSet<String>();
    private final @NonNull Set<@NonNull String> supportedCpuNames = new HashSet<String>();
    private final @NonNull Set<@NonNull String> supportedGpuNames = new HashSet<String>();
    private final boolean expandClusters;

    private static void addSupportedXpuId(@NonNull Set<@NonNull String> names, @NonNull XMLParser in) {
        String id = in.getAttribute(ATTR_ID);
        if (id == null) {
            return;
        }
        if ((id = id.strip()).isEmpty()) {
            return;
        }
        names.add(id);
    }

    public TemplateFile() {
        this.expandClusters = false;
    }

    public TemplateFile(@NonNull File file, @NonNull Map<@NonNull String, @NonNull TIntSet> sourceToClusterIds) throws IOException {
        this(new TemplatePath(file), sourceToClusterIds);
    }

    public TemplateFile(@NonNull ITemplatePath path, @NonNull Map<@NonNull String, @NonNull TIntSet> sourceToClusterIds) throws IOException {
        this.mPath = path;
        boolean expandClusters = false;
        Throwable throwable = null;
        Object var5_6 = null;
        try (XMLParser in = XMLParser.create((InputStream)path.openInputStream());){
            String tag;
            while ((tag = in.nextTag()) != null) {
                if (TAG.equals(tag)) {
                    ObjBoolPair<String> res = this.populate(in, sourceToClusterIds, false);
                    expandClusters = res.second;
                    break;
                }
                in.skip();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.expandClusters = expandClusters;
    }

    public TemplateFile(@NonNull XMLParser in, @NonNull Map<@NonNull String, @NonNull TIntSet> sourceToClusterIds) throws IOException {
        ObjBoolPair<String> res = this.populate(in, sourceToClusterIds, true);
        String name = (String)res.first;
        this.expandClusters = res.second;
        if (name != null) {
            this.mPath = new TemplatePath(name, false);
        }
    }

    private @NonNull ObjBoolPair<@Nullable String> populate(@NonNull XMLParser in, @NonNull Map<@NonNull String, @NonNull TIntSet> sourceToClusterIds, boolean ignoreVersion) throws IOException {
        String tag;
        boolean expandCluster = false;
        String name = null;
        String marker = in.getMarker();
        int version = in.getIntegerAttribute(ATTR_VERSION, 0);
        if (!ignoreVersion || version != 0) {
            if (version > 2) {
                throw InvalidVersionException.createTemplateVersionTooNewException();
            }
            if (version < 2) {
                throw InvalidVersionException.createTemplateVersionTooOldException();
            }
        }
        expandCluster = in.isAttributeSet(ATTR_EXPAND_CLUSTER, false);
        name = in.getAttribute("name");
        while ((tag = in.nextTag(marker)) != null) {
            if ("chart".contentEquals(tag)) {
                List<ChartAndSeriesConfig> load = ChartAndSeriesXMLParser.load(in, expandCluster, sourceToClusterIds);
                List validCharts = load.stream().filter(c -> c.getChart().getSeriesComposition() != SeriesComposition.VISUAL_ANNOTATION).collect(Collectors.toList());
                this.mCharts.addAll(validCharts);
                continue;
            }
            if (TAG_SELECT_METRIC.contentEquals(tag)) {
                String id = in.getAttribute(ATTR_ID);
                if (id == null || id.isBlank()) continue;
                this.selectedMetrics.add(id.strip());
                continue;
            }
            if (TAG_SUPPORTED_CPUID.contentEquals(tag)) {
                TemplateFile.addSupportedXpuId(this.supportedCpuNames, in);
                continue;
            }
            if (TAG_SUPPORTED_GPUID.contentEquals(tag)) {
                TemplateFile.addSupportedXpuId(this.supportedGpuNames, in);
                continue;
            }
            in.skip();
        }
        return new ObjBoolPair((Object)name, expandCluster);
    }

    public final void addAllCharts(@NonNull Collection<@NonNull ChartAndSeriesConfig> charts) {
        this.mCharts.addAll(charts);
    }

    public final void addChart(@NonNull ChartAndSeriesConfig chart) {
        this.mCharts.add(chart);
    }

    public final boolean canSave() {
        return this.mPath != null && !this.mPath.isStock();
    }

    public void clear() {
        this.mCharts.clear();
    }

    public final TemplateFile clone() {
        try {
            TemplateFile clone = (TemplateFile)super.clone();
            clone.mCharts.clear();
            for (ChartAndSeriesConfig chart : this.mCharts) {
                clone.mCharts.add(chart.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            CommonPlugin.error((Throwable)exception);
            return null;
        }
    }

    @Override
    public final int compareTo(TemplateFile other) {
        @Nullable ITemplatePath path = this.mPath;
        @Nullable ITemplatePath otherPath = other.mPath;
        if (path == null) {
            return otherPath == null ? 0 : -1;
        }
        if (otherPath == null) {
            return 1;
        }
        return path.compareTo(otherPath);
    }

    @Override
    public final @NonNull List<@NonNull ChartAndSeriesConfig> getCharts() {
        return this.mCharts;
    }

    public final @NonNull String getName() {
        return this.mPath != null ? this.mPath.getName() : "";
    }

    public final @Nullable ITemplatePath getPath() {
        return this.mPath;
    }

    public final @Nullable File getPathAsFile() {
        return this.canSave() ? ((ITemplatePath)NullChecking.neverNull((Object)this.mPath)).toFile() : null;
    }

    @Override
    public @NonNull Set<@NonNull String> getSelectedMetrics() {
        return this.selectedMetrics;
    }

    public @NonNull Set<@NonNull String> getSupportedCpuNames() {
        return this.supportedCpuNames;
    }

    public @NonNull Set<@NonNull String> getSupportedGpuNames() {
        return this.supportedGpuNames;
    }

    public final boolean matches(TemplateFile other, boolean staticPropertiesOnly) {
        int count = this.mCharts.size();
        if (count == other.mCharts.size()) {
            int i = 0;
            while (i < count) {
                if (!this.mCharts.get(i).matches(other.mCharts.get(i), staticPropertiesOnly)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public final void save() throws IOException {
        if (this.canSave()) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (XMLGenerator xml = new XMLGenerator((OutputStream)new BufferedOutputStream(((ITemplatePath)NullChecking.neverNull((Object)this.mPath)).openOutputStream()));){
                xml.startDocument();
                this.save(xml);
                xml.endDocument();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public final void save(@NonNull XMLGenerator xml) throws IOException {
        xml.startTag(TAG);
        xml.addAttribute(ATTR_VERSION, 2);
        String mName = this.getName();
        if (!mName.isEmpty()) {
            xml.addAttribute("name", mName);
        }
        xml.addAttributeNot(ATTR_EXPAND_CLUSTER, this.expandClusters, false);
        for (String id : this.supportedCpuNames) {
            xml.startEmptyTag(TAG_SUPPORTED_CPUID);
            xml.addAttribute(ATTR_ID, id);
        }
        for (String id : this.supportedGpuNames) {
            xml.startEmptyTag(TAG_SUPPORTED_GPUID);
            xml.addAttribute(ATTR_ID, id);
        }
        for (String id : this.selectedMetrics) {
            xml.startEmptyTag(TAG_SELECT_METRIC);
            xml.addAttribute(ATTR_ID, id);
        }
        ChartAndSeriesXMLParser.save(xml, this.mCharts);
        xml.endTag();
    }

    public final void setPath(@NonNull ITemplatePath path) {
        this.mPath = path;
    }
}

