/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.process;

import com.arm.streamline.common.model.chart.ActivityChartUtils;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.chart.SeriesRangeInfo;
import com.arm.streamline.model.process.CpuUtilizationProcessCounter;
import com.arm.streamline.model.process.SimpleProcessCounter;
import com.arm.streamline.model.process.TimelineSeriesProcessCounter;
import com.arm.streamline.utility.expression2.ExpressionData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IProcessCounter {
    public static @NonNull List<@NonNull IProcessCounter> findProcessCounters(@NonNull Analysis analysis) {
        CpuUtilizationProcessCounter cpuUtilizationProcessCounter = null;
        ArrayList<IProcessCounter> resultSimple = new ArrayList<IProcessCounter>();
        ArrayList<SeriesRangeInfo> systemActivity = new ArrayList<SeriesRangeInfo>();
        ArrayList<SeriesRangeInfo> userActivity = new ArrayList<SeriesRangeInfo>();
        for (IBinDataProvider provider : analysis.getAllBinData().getAllSelectedProviders()) {
            SeriesRangeInfo info;
            String source;
            HashSet<String> set;
            if (!provider.isFilterable()) continue;
            CounterRecord counterRecord = provider.getCounterRecord();
            if (ActivityChartUtils.isCPUActivitySystem((String)counterRecord.getTitle(), (String)counterRecord.getName())) {
                set = new HashSet<String>();
                source = provider.getPrimaryUniqueSourceName();
                set.add(source);
                info = new SeriesRangeInfo(counterRecord.getDisplay(), new ExpressionData(counterRecord.getExpression()), counterRecord.isAverageCores(), counterRecord.isAverageSelection(), null, analysis.getCores(counterRecord), set, false);
                systemActivity.add(info);
                continue;
            }
            if (ActivityChartUtils.isCPUActivityUser((String)counterRecord.getTitle(), (String)counterRecord.getName())) {
                set = new HashSet();
                source = provider.getPrimaryUniqueSourceName();
                set.add(source);
                info = new SeriesRangeInfo(counterRecord.getDisplay(), new ExpressionData(counterRecord.getExpression()), counterRecord.isAverageCores(), counterRecord.isAverageSelection(), null, analysis.getCores(counterRecord), set, false);
                userActivity.add(info);
                continue;
            }
            resultSimple.add(new SimpleProcessCounter(analysis, provider));
        }
        ArrayList<IProcessCounter> resultCharts = new ArrayList<IProcessCounter>();
        if (!systemActivity.isEmpty() || !userActivity.isEmpty()) {
            cpuUtilizationProcessCounter = new CpuUtilizationProcessCounter(analysis, systemActivity, userActivity);
            resultSimple.add(0, cpuUtilizationProcessCounter);
            resultCharts.add(cpuUtilizationProcessCounter);
        }
        for (IChartDataProvider chart : analysis.getCharts().getCharts()) {
            for (ISeriesDataProvider series : chart.getSeries()) {
                if (!series.isFilterable() || cpuUtilizationProcessCounter != null && (ActivityChartUtils.isCPUActivitySystem((String)chart.getTitle(), (String)series.getName()) || ActivityChartUtils.isCPUActivityUser((String)chart.getTitle(), (String)series.getName()))) continue;
                resultCharts.add(new TimelineSeriesProcessCounter(chart, series));
            }
        }
        if (resultCharts.size() > (cpuUtilizationProcessCounter != null ? 1 : 0)) {
            return resultCharts;
        }
        return resultSimple;
    }

    public long getData(int var1, int var2, int var3, boolean var4);

    public @NonNull String getDescription();

    public @NonNull String getTitle();

    public boolean isPercentage();

    public boolean isDefaultSortItem();

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference getColourPreference();

    public @Nullable Integer getChartRGB();
}

