/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.process;

import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueID;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueProcessID;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueThreadID;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.Focus;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.IUniqueLifetimes;
import com.arm.streamline.report.model.uids.UniqueProcess;
import com.arm.streamline.report.model.uids.UniqueThread;
import com.arm.utils.ArrayUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.ObjIntPair;
import gnu.trove.list.TLongList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class HeatmapDataCompute {
    private static final int[] REASON_MAP = new int[]{-2, -3, -4, -5, -6, -7};
    private static final @NonNull TLongList EMPTY_EVENTS = new TLongArrayList(0);
    private final @NonNull Analysis analysis;
    private int cachedEndBin = -1;
    private @Nullable HeatmapData cachedHeatmapData = null;
    private @Nullable String cachedSource = null;
    private int cachedStartBin = -1;
    private @Nullable ZoomLevel cachedZoomLevel = null;

    private static void accumulateBinData(long currentBinTime, @NonNull IUniqueIds uniqueIds, @NonNull IUniqueLifetimes uniqueLifetimes, @NonNull Set<@NonNull UniqueThread> idleThreads, @NonNull ICaptureDataProvider.IFocusedEventSource fes, @NonNull Map<@NonNull IUniqueID, @NonNull TLongList> data, int insertIndex, @NonNull HeatmapData result) {
        UniqueProcess process;
        HashMap<UniqueProcess, ProcessIntermediateState> perProcessState = new HashMap<UniqueProcess, ProcessIntermediateState>();
        ObjIntPair[] perCoreState = new ObjIntPair[result.numberOfCores];
        TIntHashSet distinctThreadUIDs = new TIntHashSet(10, 0.5f, -1);
        long totalPercent = 0L;
        for (Map.Entry<IUniqueID, TLongList> entry : data.entrySet()) {
            IUniqueID uid = entry.getKey();
            TLongList events = entry.getValue();
            distinctThreadUIDs.add(uid.getUID());
            UniqueThread thread2 = HeatmapDataCompute.mapToUniqueThread(uniqueIds, uid);
            if (thread2.isIdle()) continue;
            process = thread2.process;
            ProcessIntermediateState processIntermediateState = perProcessState.computeIfAbsent(process, k -> new ProcessIntermediateState(heatmapData.numberOfCores));
            int threadPercentOrReason = HeatmapDataCompute.accumulateBinData(currentBinTime, uniqueLifetimes, fes, insertIndex, result, perCoreState, thread2, events, processIntermediateState.perCoreSumPercent);
            if (threadPercentOrReason > 0) {
                totalPercent += (long)threadPercentOrReason;
            }
            processIntermediateState.bestReason = Math.min(processIntermediateState.bestReason, threadPercentOrReason);
        }
        uniqueIds.getThreads().forEach(thread -> {
            if (distinctThreadUIDs.contains(thread.uid) || thread.isIdle()) {
                return;
            }
            UniqueProcess process = thread.process;
            ProcessIntermediateState processIntermediateState = perProcessState.computeIfAbsent(process, k -> new ProcessIntermediateState(heatmapData.numberOfCores));
            int threadPercentOrReason = HeatmapDataCompute.accumulateBinData(currentBinTime, uniqueLifetimes, fes, insertIndex, result, perCoreState, thread, EMPTY_EVENTS, processIntermediateState.perCoreSumPercent);
            assert (threadPercentOrReason <= 0);
            processIntermediateState.bestReason = Math.min(processIntermediateState.bestReason, threadPercentOrReason);
        });
        for (Map.Entry<Object, Object> entry : perProcessState.entrySet()) {
            UniqueProcess upid = (UniqueProcess)entry.getKey();
            ProcessIntermediateState state = (ProcessIntermediateState)entry.getValue();
            int sumPercent = 0;
            int maxPercent = -1;
            int maxPercentCore = 0;
            int coreNo = 0;
            while (coreNo < state.perCoreSumPercent.length) {
                int percent = state.perCoreSumPercent[coreNo];
                sumPercent += percent;
                if (percent > maxPercent) {
                    maxPercent = percent;
                    maxPercentCore = coreNo;
                }
                ++coreNo;
            }
            if (sumPercent > 0) {
                result.setProcessItem((IUniqueProcessID)upid, insertIndex, sumPercent, maxPercentCore, fes.getClusterID(maxPercentCore));
                continue;
            }
            assert (state.bestReason < 0);
            result.setProcessItem((IUniqueProcessID)upid, insertIndex, state.bestReason, state.bestReason, state.bestReason);
        }
        long l = (long)(result.numberOfCores * 10000) - totalPercent;
        if (!idleThreads.isEmpty() && l > 0L) {
            int percent = (int)(l / (long)idleThreads.size());
            for (UniqueThread idle : idleThreads) {
                process = idle.process;
                result.setThreadItem((IUniqueThreadID)idle, insertIndex, percent, -1, -1);
                result.setProcessItem((IUniqueProcessID)process, insertIndex, percent, -1, -1);
            }
        }
        int coreNo = 0;
        while (coreNo < perCoreState.length) {
            ObjIntPair bestThread = perCoreState[coreNo];
            if (bestThread != null) {
                UniqueProcess process2 = ((UniqueThread)bestThread.first).process;
                result.setCoreItem(coreNo, insertIndex, (IUniqueProcessID)process2, (IUniqueThreadID)bestThread.first, bestThread.second);
            }
            ++coreNo;
        }
    }

    private static int accumulateBinData(long currentBinTime, @NonNull IUniqueLifetimes uniqueLifetimes, @NonNull ICaptureDataProvider.IFocusedEventSource fes, int insertIndex, @NonNull HeatmapData result, @Nullable ObjIntPair<@NonNull UniqueThread> @NonNull [] bestThreadPerCore, @NonNull UniqueThread utid, @NonNull TLongList events, int @NonNull [] processPerCoreSumPercent) {
        int[] perCoreSumPercent = new int[result.numberOfCores];
        int sumPercent = 0;
        int maxPercent = 0;
        int maxStateIndex = 0;
        int maxPercentCore = 0;
        for (long event : events) {
            int coreNo = (int)(event >>> 32);
            int stateIndexOrPercent = (int)event;
            if (coreNo < 0) {
                maxStateIndex = stateIndexOrPercent > maxStateIndex && stateIndexOrPercent < REASON_MAP.length ? stateIndexOrPercent : maxStateIndex;
                continue;
            }
            assert (stateIndexOrPercent > 0);
            sumPercent += stateIndexOrPercent;
            if (stateIndexOrPercent <= maxPercent) continue;
            maxPercent = stateIndexOrPercent;
            maxPercentCore = coreNo;
            int n = coreNo;
            processPerCoreSumPercent[n] = processPerCoreSumPercent[n] + stateIndexOrPercent;
            int n2 = coreNo;
            perCoreSumPercent[n2] = perCoreSumPercent[n2] + stateIndexOrPercent;
        }
        if (!utid.isIdle()) {
            int coreNo = 0;
            while (coreNo < perCoreSumPercent.length) {
                int percent = perCoreSumPercent[coreNo];
                ObjIntPair<UniqueThread> currentBest = bestThreadPerCore[coreNo];
                if (percent > 0 && (currentBest == null || percent > currentBest.second)) {
                    bestThreadPerCore[coreNo] = new ObjIntPair((Object)utid, percent);
                }
                ++coreNo;
            }
        }
        if (sumPercent > 0) {
            result.setThreadItem((IUniqueThreadID)utid, insertIndex, sumPercent, maxPercentCore, fes.getClusterID(maxPercentCore));
            return sumPercent;
        }
        if (uniqueLifetimes.getStartTime(utid.getUID()).orElse(Long.MAX_VALUE) < currentBinTime && uniqueLifetimes.getEndTime(utid.getUID()).orElse(Long.MIN_VALUE) > currentBinTime) {
            int reason = REASON_MAP[maxStateIndex];
            result.setThreadItem((IUniqueThreadID)utid, insertIndex, reason, reason, reason);
            return reason;
        }
        result.setThreadItem((IUniqueThreadID)utid, insertIndex, -1, -1, -1);
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static @NonNull UniqueThread mapToUniqueThread(@NonNull IUniqueIds uniqueIds, @NonNull IUniqueID uid) {
        IUniqueID iUniqueID = uid;
        if (iUniqueID instanceof UniqueThread) {
            void utid;
            UniqueThread uniqueThread = (UniqueThread)iUniqueID;
            UniqueThread cfr_ignored_0 = (UniqueThread)iUniqueID;
            return utid;
        }
        UniqueThread utid = uniqueIds.findThread(uid.getUID()).orElse(null);
        if (utid == null) {
            throw new AssertionError((Object)("missing thread for uid " + String.valueOf(uid)));
        }
        return utid;
    }

    public HeatmapDataCompute(@NonNull Analysis analysis) {
        this.analysis = analysis;
    }

    public @NonNull HeatmapData computeHeatmapData(int requestedStartBin, int requestedEndBin) {
        int size = requestedEndBin - requestedStartBin + 1;
        if (size <= 0) {
            return HeatmapData.EMPTY;
        }
        ZoomLevel zoomLevel = this.analysis.getScales().getZoomLevel();
        Focus focus = this.analysis.getFocusObject();
        ICaptureDataProvider.IFocusedEventSource fes = this.analysis.getFocusedEventSource();
        int numberOfCores = fes.getCoreCount();
        HeatmapData cachedHeatmapData = this.cachedHeatmapData;
        if (cachedHeatmapData != null && requestedStartBin == this.cachedStartBin && requestedEndBin == this.cachedEndBin && NullChecking.equalsNullable((Object)this.cachedZoomLevel, (Object)zoomLevel) && NullChecking.equalsNullable((Object)focus.getFocusSource(), (Object)this.cachedSource)) {
            return cachedHeatmapData;
        }
        int numberOfBins = this.analysis.getBinCount();
        int actualStartBin = Math.max(0, requestedStartBin);
        int actualBinCount = Math.max(actualStartBin, Math.min(requestedEndBin + 1, numberOfBins)) - actualStartBin;
        HeatmapData result = new HeatmapData(size, numberOfCores);
        IUniqueIds uniqueIds = this.analysis.getUniqueIdMap();
        IUniqueLifetimes uniqueLifetimes = this.analysis.getUniqueLifetimes();
        Set<UniqueThread> idleThreads = uniqueIds.getIdleThreads().collect(Collectors.toSet());
        focus.setAutoCloseFiles(false);
        try {
            int binCounter = 0;
            while (binCounter < actualBinCount) {
                int binIndex = binCounter + actualStartBin;
                int insertIndex = binIndex - requestedStartBin;
                long currentBinTime = zoomLevel.convertBinToNanoseconds((long)binIndex);
                Map<IUniqueID, TLongList> data = focus.getData(binIndex);
                if (data != null) {
                    HeatmapDataCompute.accumulateBinData(currentBinTime, uniqueIds, uniqueLifetimes, idleThreads, fes, data, insertIndex, result);
                }
                ++binCounter;
            }
        }
        finally {
            focus.cleanup();
            focus.setAutoCloseFiles(true);
        }
        this.cachedStartBin = requestedStartBin;
        this.cachedEndBin = requestedEndBin;
        this.cachedSource = focus.getFocusSource();
        this.cachedZoomLevel = zoomLevel;
        this.cachedHeatmapData = result;
        return result;
    }

    public static class HeatmapData {
        public static final @NonNull HeatmapData EMPTY = new HeatmapData(0, 0);
        public final int numberOfCores;
        public final int rangeSize;
        private final @NonNull PerCoreData @NonNull [] perCoreData;
        private final @NonNull Map<@NonNull IUniqueProcessID, @NonNull PerUIDData> perProcessData = new HashMap<IUniqueProcessID, PerUIDData>();
        private final @NonNull Map<@NonNull IUniqueThreadID, @NonNull PerUIDData> perThreadData = new HashMap<IUniqueThreadID, PerUIDData>();

        public HeatmapData(int rangeSize, int numberOfCores) {
            this.rangeSize = Math.max(rangeSize, 0);
            this.numberOfCores = Math.max(numberOfCores, 1);
            this.perCoreData = (PerCoreData[])ArrayUtils.createNonNull(PerCoreData[]::new, (int)numberOfCores, i -> new PerCoreData(rangeSize));
        }

        public @Nullable PerUIDData get(@NonNull IUniqueProcessID upid) {
            return this.perProcessData.get(upid);
        }

        public @Nullable PerUIDData get(@NonNull IUniqueThreadID upid) {
            return this.perThreadData.get(upid);
        }

        public @NonNull PerCoreData getCPU(int coreNo) {
            if (coreNo < 0 || coreNo >= this.numberOfCores) {
                throw new IllegalArgumentException("Invalid core index (" + coreNo + "/" + this.numberOfCores + ")");
            }
            return this.perCoreData[coreNo];
        }

        private void setCoreItem(int coreNo, int insertIndex, @NonNull IUniqueProcessID process, @NonNull IUniqueThreadID thread, int percentage) {
            PerCoreData entry = this.perCoreData[coreNo];
            entry.setItem(insertIndex, process, thread, percentage);
        }

        private void setProcessItem(@NonNull IUniqueProcessID upid, int insertIndex, int percentageOrCode, int coreNoOrCode, int clusterNoOrCode) {
            if (insertIndex < 0 || insertIndex >= this.rangeSize) {
                return;
            }
            PerUIDData entry = this.perProcessData.computeIfAbsent(upid, k -> new PerUIDData(this.rangeSize));
            entry.setItem(insertIndex, percentageOrCode, coreNoOrCode, clusterNoOrCode);
        }

        private void setThreadItem(@NonNull IUniqueThreadID utid, int insertIndex, int percentageOrCode, int coreNoOrCode, int clusterNoOrCode) {
            if (insertIndex < 0 || insertIndex >= this.rangeSize) {
                return;
            }
            PerUIDData entry = this.perThreadData.computeIfAbsent(utid, k -> new PerUIDData(this.rangeSize));
            entry.setItem(insertIndex, percentageOrCode, coreNoOrCode, clusterNoOrCode);
        }
    }

    public static final class PerCoreData {
        public final @Nullable IUniqueProcessID @NonNull [] bestUPID;
        public final @Nullable IUniqueThreadID @NonNull [] bestUTID;
        public final int @NonNull [] percentage;

        public PerCoreData(int rangeSize) {
            this.bestUPID = new IUniqueProcessID[rangeSize];
            this.bestUTID = new IUniqueThreadID[rangeSize];
            this.percentage = new int[rangeSize];
        }

        private void setItem(int insertIndex, @NonNull IUniqueProcessID process, @NonNull IUniqueThreadID thread, int percentage) {
            if (insertIndex < 0 || insertIndex >= this.bestUPID.length) {
                return;
            }
            assert (this.bestUPID[insertIndex] == null);
            assert (this.bestUTID[insertIndex] == null);
            assert (this.percentage[insertIndex] == 0);
            this.bestUPID[insertIndex] = process;
            this.bestUTID[insertIndex] = thread;
            this.percentage[insertIndex] = percentage;
        }
    }

    public static final class PerUIDData {
        public final int @NonNull [] clusterNoOrCode;
        public final int @NonNull [] coreNoOrCode;
        public final int @NonNull [] percentageOrCode;

        public PerUIDData(int rangeSize) {
            this.percentageOrCode = new int[rangeSize];
            this.coreNoOrCode = new int[rangeSize];
            this.clusterNoOrCode = new int[rangeSize];
            Arrays.fill(this.percentageOrCode, -1);
            Arrays.fill(this.coreNoOrCode, -1);
            Arrays.fill(this.clusterNoOrCode, -1);
        }

        private void setItem(int insertIndex, int percentageOrCode, int coreNoOrCode, int clusterNoOrCode) {
            assert (this.percentageOrCode[insertIndex] == -1);
            assert (this.coreNoOrCode[insertIndex] == -1);
            assert (this.clusterNoOrCode[insertIndex] == -1);
            this.percentageOrCode[insertIndex] = percentageOrCode;
            this.coreNoOrCode[insertIndex] = coreNoOrCode;
            this.clusterNoOrCode[insertIndex] = clusterNoOrCode;
        }
    }

    private static final class ProcessIntermediateState {
        public int bestReason;
        public final int @NonNull [] perCoreSumPercent;

        public ProcessIntermediateState(int numberOfCores) {
            this.perCoreSumPercent = new int[numberOfCores];
            this.bestReason = 0;
        }
    }
}

