/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.process;

import com.arm.streamline.editortabs.timeline.common.process.ProcessMessages;
import com.arm.streamline.jni.apcdbgen.proto.IColumnDescriptor;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.chart.SeriesRangeCalculator;
import com.arm.streamline.model.chart.SeriesRangeInfo;
import com.arm.streamline.model.process.IProcessCounter;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class CpuUtilizationProcessCounter
implements IProcessCounter {
    private static final double ROUNDING_FACTOR = 0.5;
    private final @NonNull Analysis mAnalysis;
    private final @NonNull List<@NonNull SeriesRangeInfo> mSystemActivity;
    private final @NonNull List<@NonNull SeriesRangeInfo> mUserActivity;

    public CpuUtilizationProcessCounter(@NonNull Analysis analysis, @NonNull List<@NonNull SeriesRangeInfo> systemActivity, @NonNull List<@NonNull SeriesRangeInfo> userActivity) {
        this.mAnalysis = analysis;
        this.mSystemActivity = systemActivity;
        this.mUserActivity = userActivity;
    }

    @Override
    public long getData(int start, int end, int uid, boolean isKernel) {
        SeriesRangeCalculator calculator = this.mAnalysis.getSeriesRangeCalculator();
        TIntHashSet tids = this.mAnalysis.getUniqueIdMap().toThreadUids(uid).collect(TIntHashSet::new, TIntSet::add, TIntSet::addAll);
        double sum = 0.0;
        int totalCount = 0;
        for (SeriesRangeInfo info : isKernel ? this.mSystemActivity : this.mUserActivity) {
            info.setUtids(tids);
            int count = info.getChannelDescriptors().length;
            sum += calculator.getAggregateRange(info, start, end) * (double)count;
            totalCount += count;
        }
        return (long)(sum / (double)totalCount * 10000.0 + 0.5);
    }

    @Override
    public @NonNull String getDescription() {
        return "";
    }

    @Override
    public @NonNull String getTitle() {
        return ProcessMessages.CPU_USAGE_TITLE;
    }

    @Override
    public boolean isPercentage() {
        return true;
    }

    @Override
    public boolean isDefaultSortItem() {
        return true;
    }

    @Override
    public @Nullable Integer getChartRGB() {
        return 3858243;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference getColourPreference() {
        return IColumnDescriptor.ColourPreference.user_defined;
    }
}

