/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.live;

import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.model.capture.SeriesCoreInformationProvider;
import com.arm.streamline.model.chart.ChartModelMessages;
import com.arm.streamline.model.chart.ChartUtility;
import com.arm.streamline.model.chart.SeriesRangeCalculator;
import com.arm.streamline.model.chart.SeriesRangeInfo;
import com.arm.streamline.model.live.ILiveAllBinDataProvider;
import com.arm.streamline.model.live.LiveBinDataProvider;
import com.arm.streamline.model.live.LiveCaptureDataProvider;
import com.arm.streamline.model.live.LiveChartDataProvider;
import com.arm.streamline.utility.expression2.ExpressionData;
import com.arm.streamline.utility.expression2.ExpressionException;
import com.arm.utils.NullChecking;
import gnu.trove.list.TIntList;
import gnu.trove.map.hash.TIntDoubleHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import gnu.trove.set.hash.TLongHashSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class LiveSeriesDataProvider
implements ISeriesDataProvider,
SeriesConfig.IListener {
    private final @NonNull SeriesCoreInformationProvider coreInformationProvider;
    private LiveChartDataProvider mChart;
    private @NonNull SeriesConfig mConfig;
    private boolean mEfficientFtrace;
    private boolean mIsAverageSelectionPossible;
    private TIntDoubleHashMap mScaleToAggregateLimitMap = new TIntDoubleHashMap();
    private TIntDoubleHashMap mScaleToCoreLimitMap = new TIntDoubleHashMap();
    private @NonNull Set<@NonNull String> mSources = Collections.emptySet();
    private String mWarning;
    private ISeriesDataProvider.WarningSource mWarningSource;

    LiveSeriesDataProvider(LiveChartDataProvider chart, @NonNull SeriesConfig config, @NonNull ProcessingElementReferenceSet processingElementsReferenceSet) {
        this.mChart = chart;
        this.mConfig = config;
        this.mConfig.addListener(this);
        this.mEfficientFtrace = this.getCaptureDataProvider().getCaptureSettings().isEfficientFtraceEnabled();
        this.coreInformationProvider = new SeriesCoreInformationProvider(() -> this.mSources, s -> (IBinDataProvider)NullChecking.neverNull((Object)this.getAllBinData().getBinData((String)s)), c -> {
            @Nullable TIntList coresInCluster = this.getCaptureDataProvider().getClustersInfo().getCores(c);
            if (coresInCluster == null || coresInCluster.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<@NonNull ProcessingElementReference> result = new ArrayList<ProcessingElementReference>();
            for (int core : coresInCluster) {
                result.add(processingElementsReferenceSet.get(DeviceType.CPU, 0L, core));
            }
            return result;
        });
        this.initializeDataDependentOnExpression();
        this.mSources = (Set)NullChecking.neverNull(this.mSources);
    }

    @Override
    public void expressionOrDisplayModified() {
        this.initializeDataDependentOnExpression();
        this.mChart.getCaptureDataProvider().providersBeingUsedChanged();
    }

    @Override
    public double getAggregateLimit() {
        return this.mScaleToAggregateLimitMap.get(this.getChart().getCaptureDataProvider().getScales().getZoomLevel().getBps());
    }

    @Override
    public final double getAggregateValueOfRangeFromDensestLevel(int start, int end, TIntSet filteredUids) {
        return this.getValueOfRangeFromDensestLevel(null, start, end, this.getChart().getCaptureDataProvider().getScales().getZoomLevel(), this.getSeriesRangeInfo(filteredUids), false);
    }

    public final @NonNull ILiveAllBinDataProvider getAllBinData() {
        return this.getChart().getCaptureDataProvider().getAllBinData();
    }

    @Override
    public final @NonNull LiveBinDataProvider getBinData(@NonNull String source) {
        return (LiveBinDataProvider)NullChecking.neverNull((Object)this.getAllBinData().getBinData(source));
    }

    public LiveCaptureDataProvider getCaptureDataProvider() {
        return this.mChart.getCaptureDataProvider();
    }

    @Override
    public final LiveChartDataProvider getChart() {
        return this.mChart;
    }

    @Override
    public final SeriesConfig getConfig() {
        return this.mConfig;
    }

    @Override
    public @NonNull ISeriesDataProvider.ISeriesCoreInformationProvider getCoreInformationProvider() {
        return this.coreInformationProvider;
    }

    @Override
    public double getCoreLimit() {
        return this.mScaleToCoreLimitMap.get(this.getChart().getCaptureDataProvider().getScales().getZoomLevel().getBps());
    }

    @Override
    public final double getCoreValueOfRangeFromDensestLevel(@NonNull ProcessingElementReference peReference, int start, int end, TIntSet filteredUids) {
        return this.getValueOfRangeFromDensestLevel(peReference, start, end, this.getChart().getCaptureDataProvider().getScales().getZoomLevel(), this.getSeriesRangeInfo(filteredUids), false);
    }

    @Override
    public double[] getData(@Nullable ProcessingElementReference peReference, int start, int end, @Nullable TIntSet filteredUids) {
        double[] data = new double[1 + end - start];
        SeriesRangeInfo info = this.getSeriesRangeInfo(filteredUids);
        int i = start;
        while (i <= end) {
            data[i - start] = this.getDataPointAtScale(this.getChart().getCaptureDataProvider().getScales().getZoomLevel(), peReference, i, info);
            ++i;
        }
        return data;
    }

    @Override
    public final double[] getData(int start, int end, @Nullable TIntSet filteredUids) {
        return this.getData(null, start, end, filteredUids);
    }

    @Override
    public String getDescription() {
        return this.getCaptureDataProvider().getVariableReplacer().replace(this.getConfig().getDescriptionFormat());
    }

    @Override
    public String getName() {
        return this.getCaptureDataProvider().getVariableReplacer().replace(this.getConfig().getName());
    }

    @Override
    public @NonNull Set<@NonNull String> getSources() {
        return this.mSources;
    }

    @Override
    public String getWarning() {
        return this.mWarning;
    }

    @Override
    public ISeriesDataProvider.WarningSource getWarningSource() {
        return this.mWarningSource;
    }

    @Override
    public void initializeLimits() {
        TLongHashSet limits = new TLongHashSet();
        Set<@NonNull String> sources = this.getSources();
        for (String source : sources) {
            LiveBinDataProvider provider = this.getBinData(source);
            limits.addAll(provider.getLimits());
        }
        if (limits.size() == 0) {
            limits.add(0L);
        }
        this.mScaleToAggregateLimitMap.clear();
        this.mScaleToCoreLimitMap.clear();
        SeriesRangeInfo info = this.getSeriesRangeInfo(null);
        ZoomLevel[] zoomLevelArray = this.getChart().getCaptureDataProvider().getScales().getAvailableZoomLevels();
        int n = zoomLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ZoomLevel zoomLevel = zoomLevelArray[n2];
            long[] lArray = limits.toArray();
            int n3 = lArray.length;
            int n4 = 0;
            while (n4 < n3) {
                long limitIndex = lArray[n4];
                this.getDataPointAtScale(zoomLevel, null, (int)limitIndex, info);
                @NonNull Set<@NonNull ProcessingElementReference> channels = this.coreInformationProvider.getChannelDescriptors();
                if (channels.size() > 1) {
                    for (ProcessingElementReference channel : channels) {
                        this.getDataPointAtScale(zoomLevel, channel, (int)limitIndex, info);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public final boolean isAverageSelectionPossible() {
        return this.mIsAverageSelectionPossible;
    }

    @Override
    public boolean isDataHiddenDueToEfficientFtrace() {
        if (this.mEfficientFtrace) {
            for (String source : this.getSources()) {
                if (!this.getBinData(source).getCounterRecord().isFromFtrace()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isFilterable() {
        return false;
    }

    private void adjustAggregateLimit(@NonNull ZoomLevel zoomLevel, double value) {
        if (value > this.mScaleToAggregateLimitMap.get(zoomLevel.getBps())) {
            this.mScaleToAggregateLimitMap.put(zoomLevel.getBps(), value);
        }
    }

    private void adjustCoreLimit(@NonNull ZoomLevel zoomLevel, double value) {
        if (value > this.mScaleToCoreLimitMap.get(zoomLevel.getBps())) {
            this.mScaleToCoreLimitMap.put(zoomLevel.getBps(), value);
        }
    }

    private void calculateWarnings() {
        @NonNull HashSet<@NonNull String> vars = new HashSet<String>();
        try {
            ChartUtility.getVariableSetFromExpression(this.mConfig.getExpression(), vars);
        }
        catch (ExpressionException e) {
            this.mWarningSource = ISeriesDataProvider.WarningSource.EXPRESSION;
            this.mWarning = ChartModelMessages.INVALID_EXPRESSION;
            return;
        }
        int indexForMissingSources = 0;
        int indexForInvalidSources = 0;
        int indexForDummySources = 0;
        int indexForIncompatibleDisplay = 0;
        @NonNull ILiveAllBinDataProvider binData = this.getAllBinData();
        String missingSources = null;
        String invalidSources = null;
        String dummySources = null;
        String incompatibleDisplay = null;
        for (String v : vars) {
            if (!binData.isValidSource(v, c -> true)) {
                if (indexForMissingSources++ == 0) {
                    missingSources = ChartModelMessages.MISSING_SOURCES + "$" + v;
                    continue;
                }
                missingSources = missingSources + ", $" + v;
                continue;
            }
            if (binData.getInvalidSources().contains(v)) {
                if (indexForInvalidSources++ == 0) {
                    invalidSources = "$" + v;
                    continue;
                }
                invalidSources = invalidSources + ", $" + v;
                continue;
            }
            if (binData.isDummySource(v)) {
                if (indexForDummySources++ == 0) {
                    dummySources = "$" + v;
                    continue;
                }
                dummySources = dummySources + ", $" + v;
                continue;
            }
            if (ChartUtility.isCompatible(this.mConfig.getDisplay(), ((LiveBinDataProvider)NullChecking.neverNull((Object)binData.getBinData(v))).getCounterRecord().getCounterClass())) continue;
            incompatibleDisplay = indexForIncompatibleDisplay++ == 0 ? "'" + this.mConfig.getDisplay().toString() + "' " + ChartModelMessages.INCOMPATIBLE_DISPLAY + " $" + v : incompatibleDisplay + ", $" + v;
        }
        if (missingSources != null) {
            this.mWarningSource = ISeriesDataProvider.WarningSource.EXPRESSION;
            this.mWarning = missingSources;
        } else if (invalidSources != null) {
            this.mWarningSource = ISeriesDataProvider.WarningSource.INVALID_COUNTER;
            this.mWarning = MessageFormat.format(ChartModelMessages.NO_COUNTER_AVAILABLE_SOURCES, invalidSources);
        } else if (dummySources != null) {
            this.mWarningSource = ISeriesDataProvider.WarningSource.DUMMY_COUNTER;
            this.mWarning = MessageFormat.format(ChartModelMessages.DUMMY_SOURCES, dummySources);
        } else if (incompatibleDisplay != null) {
            this.mWarningSource = ISeriesDataProvider.WarningSource.COUNTER_DISPLAY;
            this.mWarning = incompatibleDisplay;
        } else {
            this.mWarningSource = ISeriesDataProvider.WarningSource.NONE;
            this.mWarning = null;
        }
    }

    private final double getDataPointAtScale(@NonNull ZoomLevel zoomLevel, @Nullable ProcessingElementReference peReference, int offset, SeriesRangeInfo info) {
        @NonNull ZoomLevel densestZoomLevel = this.getChart().getCaptureDataProvider().getScales().getDensestZoomLevel();
        int start = offset * densestZoomLevel.getBps() / zoomLevel.getBps();
        int end = start + densestZoomLevel.getBps() / zoomLevel.getBps() - 1;
        double value = this.getValueOfRangeFromDensestLevel(peReference, start, end, zoomLevel, info, true);
        return value;
    }

    private SeriesRangeInfo getSeriesRangeInfo(@Nullable TIntSet filteredUids) {
        TIntHashSet filteredThreadUids = this.getChart().getCaptureDataProvider().convertToThreadUIDs(filteredUids);
        @NonNull Set<@NonNull ProcessingElementReference> channels = this.coreInformationProvider.getChannelDescriptors();
        ExpressionData expression = this.mConfig.getExpression();
        return new SeriesRangeInfo(this.mConfig.getDisplay(), expression, this.getChart().isAverageCores(), this.getChart().isAverageSelection(), filteredThreadUids, channels.toArray(new ProcessingElementReference[channels.size()]), ChartUtility.getVariableSetFromExpression(expression), ChartUtility.isExpressionComplex(expression));
    }

    private final double getValueOfRangeFromDensestLevel(@Nullable ProcessingElementReference peReference, int start, int end, @NonNull ZoomLevel zoomLevel, SeriesRangeInfo info, boolean adjustLimit) {
        double value;
        boolean perCore = peReference != null;
        SeriesRangeCalculator calculator = this.getChart().getCaptureDataProvider().getSeriesRangeCalculator();
        double d = value = peReference == null ? calculator.getAggregateRange(info, start, end) : calculator.getCoreRange(info, start, end, peReference);
        if (adjustLimit && perCore) {
            this.adjustCoreLimit(zoomLevel, value);
        } else if (adjustLimit) {
            this.adjustAggregateLimit(zoomLevel, value);
        }
        double limit = this.getChart().getNonPercentageLimit(perCore);
        return this.handlePercentageAndRound(limit, value);
    }

    private double handlePercentageAndRound(double limit, double value) {
        if (this.mChart.isPercentage()) {
            if (limit == 0.0) {
                value = 0.0;
            } else {
                if (limit < 1.0) {
                    limit = 1.0;
                }
                value /= limit;
                value = (double)Math.round(value * 10000.0) / 10000.0;
            }
        }
        return value;
    }

    private void initializeDataDependentOnExpression() {
        ExpressionData expression = this.mConfig.getExpression();
        this.mIsAverageSelectionPossible = ChartUtility.isAverageSelectionPossible(this.mConfig.getDisplay(), ChartUtility.isExpressionComplex(expression));
        this.mSources = this.getAllBinData().filterAndNormalizeSourceNames(ChartUtility.getVariableSetFromExpression(expression));
        this.calculateWarnings();
        this.initializeLimits();
    }

    @Override
    public void refreshWarnings() {
        this.calculateWarnings();
    }
}

