/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.live;

import com.arm.streamline.analysis.gator.ICaptureDetails;
import com.arm.streamline.analysis.gator.ILiveAgentCapabilities;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.CaptureSubType;
import com.arm.streamline.common.model.IScaleChangeListener;
import com.arm.streamline.common.model.ProtocolType;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.model.warnings.IWarnings;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.xml.counters.Category;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.common.xml.counters.TargetCounter;
import com.arm.streamline.common.xml.spe.SpeFilterConfiguration;
import com.arm.streamline.counterconfig.model.Configurations;
import com.arm.streamline.counterconfig.model.CounterConfiguration;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.jni.apcdbgen.proto.ICAMDataProvider;
import com.arm.streamline.jni.apcdbgen.proto.SourceFile;
import com.arm.streamline.jni.common.IProgressMonitorFactory;
import com.arm.streamline.model.EventBasedSampleInfo;
import com.arm.streamline.model.ISamplesCallback;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.capture.AbstractSeriesConfig;
import com.arm.streamline.model.capture.Bookmark;
import com.arm.streamline.model.capture.Calipers;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.ChartConfig;
import com.arm.streamline.model.capture.CrossSectionMarker;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.IChartAndSeriesListener;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.model.capture.TimelineConfig;
import com.arm.streamline.model.chart.ChartUtility;
import com.arm.streamline.model.chart.SeriesRangeCalculator;
import com.arm.streamline.model.chart.VisualChartDataProvider;
import com.arm.streamline.model.live.ILiveAllBinDataProvider;
import com.arm.streamline.model.live.ILiveProcessDataProvider;
import com.arm.streamline.model.live.LiveAllBinDataProvider;
import com.arm.streamline.model.live.LiveBinDataProvider;
import com.arm.streamline.model.live.LiveChartDataProvider;
import com.arm.streamline.model.process.ITimelineMapProvider;
import com.arm.streamline.model.session.ICaptureInputSettings;
import com.arm.streamline.model.templates.TemplateFile;
import com.arm.streamline.model.templates.TemplateUtils;
import com.arm.streamline.report.model.VariableReplacer;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.streamline.report.model.uids.AbstractPerVmId;
import com.arm.utils.NullChecking;
import com.arm.utils.OptionalUtils;
import com.arm.utils.StreamUtils;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.fieldassist.ContentProposal;

public class LiveCaptureDataProvider
implements ICaptureDataProvider,
IScaleChangeListener {
    private final @NonNull ICaptureDataProvider.IFocusedEventSource focusedEventSource;
    private final @NonNull ILiveAgentCapabilities mAgentCapabilities;
    private final @NonNull ILiveAllBinDataProvider mAllBinDataProvider;
    private final @NonNull List<Bookmark> mBookmarks = new ArrayList<Bookmark>();
    private final @NonNull Calipers mCalipers;
    private @NonNull ICaptureDetails mCaptureDetails;
    private final @NonNull ICaptureInputSettings mCaptureSettings;
    private final @NonNull List<@NonNull IChartDataProvider> mCharts = new ArrayList<IChartDataProvider>();
    private final @NonNull IClustersInfo mClustersInfo;
    private final @NonNull ConfigurationsListener mConfigurationsListener;
    private final @NonNull CrossSectionMarker mCrossSectionMarker;
    private @NonNull TimelineConfig mDefaultTimelineConfiguration;
    private final @NonNull LiveAllBinDataProvider.IDynamicSourceListener mDynamicSourceListener;
    private int mLastBinCount;
    private final @NonNull List<IChartAndSeriesListener> mListeners = new ArrayList<IChartAndSeriesListener>();
    private final @NonNull ILiveProcessDataProvider mLiveModelProcessMonitor;
    private final @NonNull Scales mScales;
    private final @NonNull SeriesRangeCalculator mSeriesRangeCalculator;
    private final @NonNull VariableReplacer mVariableReplacer;
    private boolean mVisualAnnotationsPresent;
    private final @NonNull ProcessingElementReferenceSet processingElementsReferenceSet;
    private final @NonNull AtomicReference<@Nullable IWarnings> mWarnings = new AtomicReference();
    private final @NonNull AtomicBoolean mIsApplicationTracingMode = new AtomicBoolean(false);
    private final @NonNull Collection<@NonNull Runnable> mBadgesListener = Collections.synchronizedList(new ArrayList());
    private final @NonNull List<@NonNull TemplateFile> mTemplates;

    private static @NonNull CounterRecord createDummyCounterRecord(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull StockCounter.Combination combo) {
        return new CounterRecord(combo.stockCounter, "<dummy>", combo.stockCounter.getQualifiedName(combo.option, combo.counterSet), 0);
    }

    public @NonNull List<@NonNull TemplateFile> getTemplatesApplied() {
        return Collections.unmodifiableList(this.mTemplates);
    }

    public LiveCaptureDataProvider(@NonNull ICaptureInputSettings captureInputSettings, @NonNull ILiveAllBinDataProvider allBinDataProvider, @NonNull ILiveProcessDataProvider liveModelProc, @NonNull ICaptureDetails captureDetails, @NonNull ILiveAgentCapabilities liveAgentCapabilities, @NonNull VariableReplacer variableReplacer, @NonNull IClustersInfo clustersInfo, @NonNull CounterConfiguration counterConfig, @NonNull ProcessingElementReferenceSet processingElementsReferenceSet) {
        this.mTemplates = new ArrayList<TemplateFile>(counterConfig.getConfigurations().getTemplates());
        this.mCaptureSettings = captureInputSettings;
        this.mAgentCapabilities = liveAgentCapabilities;
        this.mLiveModelProcessMonitor = liveModelProc;
        this.mAllBinDataProvider = allBinDataProvider;
        this.mScales = new Scales((IScaleChangeListener)this, Scales.LIVE_CAPTURE_ZOOM_LEVEL, new ZoomLevel[]{Scales.LIVE_CAPTURE_ZOOM_LEVEL});
        this.mSeriesRangeCalculator = new SeriesRangeCalculator(this, this.mAllBinDataProvider, false);
        this.mDefaultTimelineConfiguration = ChartUtility.createTimelineConfig(this.mAllBinDataProvider.getAllSelectedProviders(), p -> true);
        this.mCaptureDetails = captureDetails;
        this.mVariableReplacer = variableReplacer;
        this.mClustersInfo = clustersInfo;
        this.mCrossSectionMarker = new CrossSectionMarker(this);
        this.mCalipers = new Calipers(this);
        this.processingElementsReferenceSet = processingElementsReferenceSet;
        this.mConfigurationsListener = new ConfigurationsListener(counterConfig);
        this.mDynamicSourceListener = new LiveAllBinDataProvider.IDynamicSourceListener(){

            @Override
            public void handleBinDataProvider(@NonNull LiveBinDataProvider provider) {
                Task.scheduleOnUIThread(() -> LiveCaptureDataProvider.this.addDynamicSeries(provider));
            }

            @Override
            public void handleVisualSource(@NonNull IUniqueThread uniqueThread) {
                Task.scheduleOnUIThread(() -> LiveCaptureDataProvider.this.addVisualChart(uniqueThread));
            }
        };
        allBinDataProvider.addDynamicSourceListener(this.mDynamicSourceListener);
        this.focusedEventSource = new ICaptureDataProvider.IFocusedEventSource(processingElementsReferenceSet){
            private final @NonNull Collection<@NonNull ICaptureDataProvider.IFocusedEventSourceCore> cores;
            {
                this.cores = Collections.unmodifiableList(Arrays.asList(new ICaptureDataProvider.IFocusedEventSourceCore(){

                    @Override
                    public int getColourIndex() {
                        return 0;
                    }

                    @Override
                    public @NonNull String getDescriptiveLabel() {
                        return "";
                    }

                    @Override
                    public @NonNull String getNumericLabel() {
                        return "";
                    }

                    @Override
                    public @NonNull ProcessingElementReference getProcessingElementReference() {
                        return processingElementReferenceSet.get(DeviceType.CPU, 0L, 0);
                    }
                }));
            }

            @Override
            public int getClusterCount() {
                return 1;
            }

            @Override
            public @NonNull String getClusterDescription(int clusterId) {
                return "Cluster support not yet implemented in Live";
            }

            @Override
            public int getClusterID(int index) {
                return 0;
            }

            @Override
            public int getCoreCount() {
                return this.cores.size();
            }

            @Override
            public @NonNull String getCoreDescription(int index) {
                return "";
            }

            @Override
            public @NonNull Collection<@NonNull ICaptureDataProvider.IFocusedEventSourceCore> getCores() {
                return this.cores;
            }
        };
    }

    @Override
    public synchronized void addDynamicChartListener(IChartAndSeriesListener listener) {
        this.mListeners.add(listener);
    }

    public void addDynamicSeries(@NonNull IBinDataProvider source) {
        Object hash = source.getSeriesHash();
        Optional<@NonNull IChartDataProvider> existingChart = this.mCharts.stream().filter(chart -> chart.getSeries().stream().flatMap(series -> series.getSources().stream().map(series::getBinData)).allMatch(binData -> binData.getSeriesHash().equals(hash))).findAny();
        if (this.mTemplates.isEmpty()) {
            CommonPlugin.info((String)"Using default template while adding dynamic series.");
        }
        Optional<ChartAndSeriesConfig> csWithwildCardTemplateMatched = this.mTemplates.stream().flatMap(t -> TemplateUtils.getChartAndSeriesConfigsToBeApplied(t, false, true, new ArrayList<String>(source.getAllUniqueSourceNames())).stream()).findFirst();
        Optional<@NonNull IChartDataProvider> existingChartWithWildCardMatched = ChartUtility.findExisitingChartForWildCardSeries(csWithwildCardTemplateMatched, this.mCharts, this.mTemplates);
        OptionalUtils.ifPresentOrElse((Optional)OptionalUtils.or(existingChartWithWildCardMatched, () -> existingChart), chart -> {
            if (existingChartWithWildCardMatched.isPresent()) {
                List<SeriesConfig> allExpandedSeries = ((ChartAndSeriesConfig)csWithwildCardTemplateMatched.get()).getAllExpandedSeries(this.getAllBinData(), i -> true);
                ChartUtility.addWildCardSeriesToExistingChart(csWithwildCardTemplateMatched, (IChartDataProvider)existingChartWithWildCardMatched.get(), allExpandedSeries, wildCardSeries -> wildCardSeries.createSeriesFromSources(this.getAllBinData()), expandedSeries -> this.notifySeriesAdded((IChartDataProvider)existingChartWithWildCardMatched.get(), (ISeriesDataProvider)expandedSeries));
            } else {
                List<@NonNull AbstractSeriesConfig> existingConfigs = chart.getSeries().stream().map(ISeriesDataProvider::getConfig).collect(Collectors.toList());
                SeriesConfig seriesConfig = ChartUtility.createSeriesConfig(source, existingConfigs);
                ISeriesDataProvider series = chart.createSeries(seriesConfig);
                this.notifySeriesAdded((IChartDataProvider)chart, series);
            }
        }, () -> {
            @NonNull TimelineConfig timelineConfig = !csWithwildCardTemplateMatched.isEmpty() ? ChartUtility.createChartForWildCard((ChartAndSeriesConfig)csWithwildCardTemplateMatched.get()) : ChartUtility.createChartFromSingleSource(source);
            for (ChartAndSeriesConfig chartAndSeriesConfig : timelineConfig.getCharts()) {
                LiveChartDataProvider liveChart = new LiveChartDataProvider(this, chartAndSeriesConfig.getChart(), this.processingElementsReferenceSet);
                IChartDataProvider chart = ChartUtility.addNewChartToChartDataProvider(chartAndSeriesConfig, liveChart, this);
                this.mCharts.add(chart);
                this.notifyChartAdded(chart);
            }
        });
        this.mDefaultTimelineConfiguration = ChartUtility.createTimelineConfig(this.mAllBinDataProvider.getAllSelectedProviders(), p -> true);
        this.providersBeingUsedChanged();
    }

    @Override
    public void addListener(@NonNull Runnable listener) {
        this.mBadgesListener.add(listener);
    }

    @Override
    public IChartDataProvider addNewChart(@NonNull ChartAndSeriesConfig chartAndSeriesConfig) {
        IChartDataProvider chart;
        ChartConfig configChart = chartAndSeriesConfig.getChart();
        if (configChart.getSeriesComposition() == SeriesComposition.VISUAL_ANNOTATION) {
            chart = new VisualChartDataProvider(this, configChart);
        } else {
            LiveChartDataProvider liveChart = new LiveChartDataProvider(this, configChart, this.processingElementsReferenceSet);
            chart = ChartUtility.addNewChartToChartDataProvider(chartAndSeriesConfig, liveChart, this);
        }
        this.mCharts.add(chart);
        this.providersBeingUsedChanged();
        return chart;
    }

    @Override
    public boolean isDuplicateChart(@NonNull ChartAndSeriesConfig chartAndSeriesConfig) {
        return ChartUtility.isDuplicateChart(chartAndSeriesConfig, this.mAllBinDataProvider, this.mCharts);
    }

    public void addStaticCharts(@Nullable TimelineConfig startingConfiguration) {
        if (!this.mTemplates.isEmpty()) {
            this.addCapturedTemplatesCharts(startingConfiguration);
        } else {
            this.addDefaultCharts(startingConfiguration);
        }
        this.providersBeingUsedChanged();
    }

    private void addDefaultCharts(@Nullable TimelineConfig startingConfiguration) {
        TimelineConfig timelineConfiguration = (TimelineConfig)NullChecking.neverNullOr((Object)startingConfiguration, (Object)this.mDefaultTimelineConfiguration);
        this.addCharts(timelineConfiguration.getCharts());
    }

    private void addCapturedTemplatesCharts(@Nullable TimelineConfig startingConfiguration) {
        @NonNull List<@NonNull ChartAndSeriesConfig> templateCharts = this.mTemplates.stream().flatMap(t -> {
            IntPredicate clusterFilter = TemplateUtils.makeClusterFilterPredicate(t, this.getClustersInfo());
            return TemplateUtils.getChartAndSeriesConfigsToBeApplied(t, false, this.getAllBinData(), clusterFilter).stream();
        }).collect(Collectors.toList());
        if (templateCharts.isEmpty()) {
            this.addDefaultCharts(startingConfiguration);
        } else {
            templateCharts.addAll(ChartUtility.diffChartsAndSeries(templateCharts, this.mDefaultTimelineConfiguration.getCharts(), this));
            this.addCharts(templateCharts);
        }
    }

    private void addCharts(@NonNull Collection<@NonNull ChartAndSeriesConfig> charts) {
        for (ChartAndSeriesConfig chartAndSeriesConfig : charts) {
            LiveChartDataProvider chart = new LiveChartDataProvider(this, chartAndSeriesConfig.getChart(), this.processingElementsReferenceSet);
            ChartUtility.addNewChartToChartDataProvider(chartAndSeriesConfig, chart, this);
            this.mCharts.add(chart);
        }
    }

    public void addVisualChart(@NonNull IUniqueThread uniqueThread) {
        ChartConfig chartConfig = new ChartConfig();
        chartConfig.setTitle(uniqueThread.getNameOrUnknown());
        chartConfig.setID(new AbstractPerVmId.PerVmNonUniquePid(uniqueThread.getVmUID(), uniqueThread.getOriginalID()));
        VisualChartDataProvider chart = new VisualChartDataProvider(this, chartConfig);
        this.mCharts.add(chart);
        this.mDefaultTimelineConfiguration.addNewChartConfiguration(new ChartAndSeriesConfig(chartConfig.clone()));
        this.mVisualAnnotationsPresent = true;
        this.notifyChartAdded(chart);
        this.providersBeingUsedChanged();
    }

    public void adjustToNewScale(ZoomLevel oldZoomLevel, ZoomLevel newZoomLevel) {
        this.getCalipers().adjustToNewScale(oldZoomLevel, newZoomLevel);
    }

    @Override
    public TIntHashSet convertToThreadUIDs(@Nullable TIntSet uids) {
        if (uids == null) {
            return null;
        }
        return new TIntHashSet();
    }

    public void dispose() {
        Task.scheduleOnUIThread(this.mConfigurationsListener::stop);
        this.mAllBinDataProvider.removeDynamicSourceListener(this.mDynamicSourceListener);
    }

    @Override
    public @NonNull ILiveAllBinDataProvider getAllBinData() {
        return this.mAllBinDataProvider;
    }

    @Override
    public int getBinCount() {
        return this.mAllBinDataProvider.getBinCount();
    }

    @Override
    public int getBinCountForDensestScale() {
        return this.getBinCount();
    }

    @Override
    public @NonNull List<Bookmark> getBookmarks() {
        return this.mBookmarks;
    }

    @Override
    public Calipers getCalipers() {
        return this.mCalipers;
    }

    @Override
    public @NonNull List<@NonNull ICAMDataProvider> getCAMDataProviders() {
        return Collections.emptyList();
    }

    public ICaptureInputSettings getCaptureSettings() {
        return this.mCaptureSettings;
    }

    @Override
    public @NonNull CaptureSubType getCaptureSubType() {
        return this.mCaptureDetails.getCaptureSubType();
    }

    @Override
    public List<@NonNull IChartDataProvider> getChartList() {
        return Collections.unmodifiableList(this.mCharts);
    }

    @Override
    public @NonNull IClustersInfo getClustersInfo() {
        return this.mClustersInfo;
    }

    @Override
    public @NonNull List<@NonNull ContentProposal> getContentProposals() {
        return this.mAllBinDataProvider.getContentProposals();
    }

    @Override
    public CrossSectionMarker getCrossSectionMarker() {
        return this.mCrossSectionMarker;
    }

    @Override
    public @NonNull TimelineConfig getDefaultTimelineConfiguration(boolean empty) {
        return (TimelineConfig)NullChecking.neverNull((Object)this.mDefaultTimelineConfiguration.clone());
    }

    @Override
    public EventBasedSampleInfo getEventBasedSampleInfo() {
        return this.mCaptureDetails.getEBSInfo();
    }

    @Override
    public @NonNull ICaptureDataProvider.IFocusedEventSource getFocusedEventSource() {
        return this.focusedEventSource;
    }

    @Override
    public String getFocusSource() {
        return "CPU Activity";
    }

    @Override
    public @NonNull List<@NonNull String> getFocusSources() {
        return new ArrayList<String>();
    }

    @Override
    public int getLastBinCount() {
        return this.mLastBinCount;
    }

    @Override
    public @NonNull ITimelineMapProvider getMapProvider() {
        throw new AssertionError();
    }

    @Override
    public @NonNull ILiveProcessDataProvider getProcessDataProvider() {
        return this.mLiveModelProcessMonitor;
    }

    @Override
    public @NonNull ProtocolType getProtocolType() {
        return this.mCaptureDetails.getProtocolInfo().getType();
    }

    @Override
    public Scales getScales() {
        return this.mScales;
    }

    @Override
    public SeriesRangeCalculator getSeriesRangeCalculator() {
        return this.mSeriesRangeCalculator;
    }

    @Override
    public @NonNull TimeUnit getTimeUnit() {
        return this.mCaptureDetails.getTimeUnit();
    }

    @Override
    public VariableReplacer getVariableReplacer() {
        return this.mVariableReplacer;
    }

    @Override
    public @NonNull IWarnings getWarnings() {
        return (IWarnings)NullChecking.neverNull((Object)this.mWarnings.get());
    }

    @Override
    public boolean isApplicationTracingMode() {
        return this.mIsApplicationTracingMode.get();
    }

    @Override
    public boolean isLive() {
        return true;
    }

    public void notifyApplicationTracingMode(long vmUID, boolean applicationTracingMode) {
        if (applicationTracingMode && this.mIsApplicationTracingMode.compareAndSet(false, true)) {
            this.mBadgesListener.forEach(Runnable::run);
        }
    }

    public void providersBeingUsedChanged() {
        this.mConfigurationsListener.handleProvidersBeingUsedChanged();
    }

    public void refreshWarnings() {
        for (IChartDataProvider chart : this.mCharts) {
            for (ISeriesDataProvider series : chart.getSeries()) {
                series.refreshWarnings();
            }
        }
    }

    @Override
    public void removeChart(@NonNull IChartDataProvider chart) {
        this.mCharts.remove(chart);
        this.providersBeingUsedChanged();
    }

    @Override
    public synchronized void removeDynamicChartListener(IChartAndSeriesListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public void removeListener(@NonNull Runnable listener) {
        this.mBadgesListener.remove(listener);
    }

    public void removeSeriesUsing(@NonNull Collection<@NonNull String> sources) {
        Iterator<IChartDataProvider> i = this.mCharts.iterator();
        while (i.hasNext()) {
            IChartDataProvider chart = i.next();
            Iterator<ISeriesDataProvider> j = chart.getSeries().iterator();
            while (j.hasNext()) {
                ISeriesDataProvider series = j.next();
                if (Collections.disjoint(series.getSources(), sources)) continue;
                j.remove();
                this.notifySeriesRemoved(chart, series);
            }
            if (!chart.getSeries().isEmpty()) continue;
            i.remove();
            this.notifyChartRemoved(chart);
        }
        this.providersBeingUsedChanged();
    }

    @Override
    public void saveBookmarks() {
        Bookmark.save(new File(this.mCaptureDetails.getPath(), "bookmarks.xml"), this.mBookmarks);
    }

    @Override
    public void setFilterRange(@NonNull ZoomLevel zoomLevel, long from, long to) {
    }

    @Override
    public void setFocusSource(String focusSource) {
    }

    @Override
    public void setSamplesRange(@NonNull ZoomLevel zoomLevel, long from, long to, @NonNull IProgressMonitorFactory progressMonitorFactory, ISamplesCallback callback) {
    }

    public void setWarnings(@NonNull IWarnings warnings) {
        this.mWarnings.set(warnings);
        this.mBadgesListener.forEach(Runnable::run);
    }

    @Override
    public boolean showClusterMap() {
        return false;
    }

    @Override
    public boolean showCoreMap() {
        return false;
    }

    @Override
    public void showPathSubstitutionDialog() {
        assert (false);
    }

    public boolean supportsRetrieveImage(@NonNull TargetAddressString targetAddress) {
        return this.mAgentCapabilities.supportsRetrieveImage(targetAddress);
    }

    @Override
    public void updateLastBinCount() {
        this.mLastBinCount = this.getBinCount();
    }

    @Override
    public boolean visualAnnotationsPresent() {
        return this.mVisualAnnotationsPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChartAdded(@NonNull IChartDataProvider chart) {
        IChartAndSeriesListener[] listeners;
        LiveCaptureDataProvider liveCaptureDataProvider = this;
        synchronized (liveCaptureDataProvider) {
            listeners = this.mListeners.toArray(new IChartAndSeriesListener[this.mListeners.size()]);
        }
        IChartAndSeriesListener[] iChartAndSeriesListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IChartAndSeriesListener listener = iChartAndSeriesListenerArray[n2];
            listener.chartWasAdded(chart);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChartRemoved(@NonNull IChartDataProvider chart) {
        IChartAndSeriesListener[] listeners;
        LiveCaptureDataProvider liveCaptureDataProvider = this;
        synchronized (liveCaptureDataProvider) {
            listeners = this.mListeners.toArray(new IChartAndSeriesListener[this.mListeners.size()]);
        }
        IChartAndSeriesListener[] iChartAndSeriesListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IChartAndSeriesListener listener = iChartAndSeriesListenerArray[n2];
            listener.chartWasRemoved(chart);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySeriesAdded(@NonNull IChartDataProvider chart, @NonNull ISeriesDataProvider series) {
        IChartAndSeriesListener[] listeners;
        LiveCaptureDataProvider liveCaptureDataProvider = this;
        synchronized (liveCaptureDataProvider) {
            listeners = this.mListeners.toArray(new IChartAndSeriesListener[this.mListeners.size()]);
        }
        IChartAndSeriesListener[] iChartAndSeriesListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IChartAndSeriesListener listener = iChartAndSeriesListenerArray[n2];
            listener.seriesWasAdded(chart, series);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySeriesRemoved(@NonNull IChartDataProvider chart, @NonNull ISeriesDataProvider series) {
        IChartAndSeriesListener[] listeners;
        LiveCaptureDataProvider liveCaptureDataProvider = this;
        synchronized (liveCaptureDataProvider) {
            listeners = this.mListeners.toArray(new IChartAndSeriesListener[this.mListeners.size()]);
        }
        IChartAndSeriesListener[] iChartAndSeriesListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IChartAndSeriesListener listener = iChartAndSeriesListenerArray[n2];
            listener.seriesWasRemoved(chart, series);
            ++n2;
        }
    }

    @Override
    public @NonNull String computeFullPath(@NonNull SourceFile sourceFile) {
        return sourceFile.filePath;
    }

    @Override
    public void setFilterThreads(@NonNull TIntSet selection) {
    }

    @Override
    public void notifyChartsChanged() {
        ILiveProcessDataProvider pdp = (ILiveProcessDataProvider)NullChecking.nullable((Object)this.mLiveModelProcessMonitor);
        if (pdp != null) {
            pdp.notifyChartsChanged();
        }
    }

    static /* synthetic */ CounterRecord access$2(StockCounter.Combination combination) {
        return LiveCaptureDataProvider.createDummyCounterRecord(combination);
    }

    private class ConfigurationsListener
    implements Configurations.IListener {
        private @NonNull Configurations configurations;
        private boolean handlingAddSources;
        private @NonNull Map<@NonNull String, // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull StockCounter.Combination> sourceToComboMap;

        public ConfigurationsListener(CounterConfiguration counterConfig) {
            this.configurations = counterConfig.getConfigurations();
            this.sourceToComboMap = counterConfig.getEvents().getSourceToComboMap();
            this.sourceToComboMap.entrySet().stream().filter(e -> !((StockCounter.Combination)e.getValue()).stockCounter.isDynamic() && !LiveCaptureDataProvider.this.mAllBinDataProvider.hasBinDataSource((String)e.getKey())).map(e -> LiveCaptureDataProvider.createDummyCounterRecord((StockCounter.Combination)e.getValue())).collect(Collectors.toList()).forEach(LiveCaptureDataProvider.this.mAllBinDataProvider::addDummyCounterSource);
            this.handleReload();
            Task.scheduleOnUIThread(() -> this.configurations.addListener(this));
        }

        @Override
        public void handleEbsChanged(@Nullable TargetCounter counter) {
        }

        @Override
        public void handleEventsAdded(@NonNull Collection<@NonNull SpeFilterConfiguration> filterConfigs, @NonNull Collection<@NonNull TargetCounter> counters) {
            Set<@NonNull String> validSources = LiveCaptureDataProvider.this.mAllBinDataProvider.getInvalidSources();
            counters.stream().map(TargetCounter::getUniqueSourceName).forEach(validSources::remove);
            if (!this.handlingAddSources) {
                try {
                    this.handlingAddSources = true;
                    for (TargetCounter counter : counters) {
                        @NonNull String source = counter.getUniqueSourceName();
                        NullChecking.consumeIfNonNull((Object)LiveCaptureDataProvider.this.mAllBinDataProvider.getBinData(source), LiveCaptureDataProvider.this::addDynamicSeries);
                    }
                }
                finally {
                    this.handlingAddSources = false;
                }
            }
            LiveCaptureDataProvider.this.refreshWarnings();
        }

        @Override
        public void handleEventsRemoved(@NonNull Collection<@NonNull SpeFilterConfiguration> filterConfigs, @NonNull Collection<@NonNull TargetCounter> counters) {
            Set<@NonNull String> removedSources = counters.stream().map(TargetCounter::getUniqueSourceName).collect(Collectors.toSet());
            LiveCaptureDataProvider.this.mAllBinDataProvider.getInvalidSources().addAll(removedSources);
            LiveCaptureDataProvider.this.removeSeriesUsing(removedSources);
            LiveCaptureDataProvider.this.refreshWarnings();
        }

        @Override
        public void handleListenersChanged() {
        }

        @Override
        public void handleReload() {
            Set<@NonNull String> invalidSources = LiveCaptureDataProvider.this.mAllBinDataProvider.getInvalidSources();
            invalidSources.clear();
            this.sourceToComboMap.entrySet().stream().filter(e -> !((StockCounter.Combination)e.getValue()).stockCounter.isDynamic() && !this.configurations.isInUse((StockCounter.Combination)e.getValue())).map(Map.Entry::getKey).forEach(invalidSources::add);
            LiveCaptureDataProvider.this.refreshWarnings();
        }

        @Override
        public boolean isSynchronized(@NonNull Category category) {
            return !category.isDynamic();
        }

        public void stop() {
            this.configurations.removeListener(this);
        }

        void handleProvidersBeingUsedChanged() {
            Set<@NonNull T> used = LiveCaptureDataProvider.this.mCharts.stream().flatMap(c -> c.getSeries().stream()).flatMap(s -> s.getSources().stream()).collect(Collectors.toSet());
            if (!this.handlingAddSources) {
                List<@NonNull TargetCounter> unneededTargetCounters = this.configurations.getAllCounters().filter(t -> !t.getDerivedFrom().isDynamic() && !used.contains(t.getUniqueSourceName())).collect(Collectors.toList());
                this.configurations.removeCounters(unneededTargetCounters);
                Stream<// Could not load outer class - annotation placement on inner may be incorrect
                 @NonNull StockCounter.Combination> combos = StreamUtils.filterOutNull(used.stream().map(this.sourceToComboMap::get)).filter(c -> !c.stockCounter.isDynamic());
                try {
                    this.handlingAddSources = true;
                    this.configurations.addCombinations(combos);
                }
                finally {
                    this.handlingAddSources = false;
                }
            }
        }
    }
}

