/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.live;

import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.model.bindata.BinDataSourceMap;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.live.ILiveAllBinDataProvider;
import com.arm.streamline.model.live.ILiveProcessDataProvider;
import com.arm.streamline.model.live.LiveBinDataProvider;
import com.arm.streamline.report.model.VariableReplacer;
import com.arm.utils.NullChecking;
import com.arm.utils.StreamUtils;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.fieldassist.ContentProposal;

public class LiveAllBinDataProvider
implements ILiveAllBinDataProvider {
    private final @NonNull BinDataSourceMap<LiveBinDataProvider> mSourceMap;
    private final @NonNull Set<@NonNull String> mInvalidSources = ConcurrentHashMap.newKeySet();
    private final @NonNull TIntObjectMap<@NonNull LiveBinDataProvider> mKeyToProviderMap = new TIntObjectHashMap();
    private final int mDuration;
    private int mBinsCommitted;
    private final boolean mDiscard;
    private final TIntObjectHashMap<String> mCoreNames = new TIntObjectHashMap();
    private final @NonNull ILiveProcessDataProvider mProcessData;
    private List<ICommitListener> mCommitListeners = new ArrayList<ICommitListener>();
    private List<@NonNull IDynamicSourceListener> mDynamicSourceListeners = new ArrayList<IDynamicSourceListener>();
    private final int mNumCPUCores;
    private TIntHashSet mVisualUids = new TIntHashSet();
    private final @NonNull Set<@NonNull IUniqueThread> mVisualUnknownThreads = new HashSet<IUniqueThread>();
    private final @NonNull IntSupplier dummyKeySupplier;
    private final @NonNull VariableReplacer mVariableReplacer;
    private final @NonNull ProcessingElementReferenceSet processingElementsReferenceSet;
    private final @NonNull TIntSet warnedMissingchartKeys;

    public LiveAllBinDataProvider(@NonNull IntSupplier dummyKeySupplier, int numCores, int duration, boolean discard, @NonNull VariableReplacer variableReplacer, @NonNull ILiveProcessDataProvider processDataProvider, @NonNull ProcessingElementReferenceSet processingElementsReferenceSet, @NonNull TIntSet warnedMissingchartKeys) {
        this.mSourceMap = new BinDataSourceMap(false);
        this.mDuration = duration;
        this.mDiscard = discard;
        this.mNumCPUCores = numCores;
        this.mVariableReplacer = variableReplacer;
        this.mProcessData = processDataProvider;
        this.dummyKeySupplier = dummyKeySupplier;
        this.processingElementsReferenceSet = processingElementsReferenceSet;
        this.warnedMissingchartKeys = warnedMissingchartKeys;
    }

    @Override
    public synchronized void addCommitListener(ICommitListener listener) {
        this.mCommitListeners.add(listener);
    }

    @Override
    public synchronized void addDynamicSourceListener(IDynamicSourceListener listener) {
        this.mDynamicSourceListeners.add(listener);
    }

    @Override
    public void addCoreName(int core, String label) {
        this.mCoreNames.put(core, (Object)label);
    }

    @Override
    public void addCounterSource(CounterRecord record) {
        this.addSource(record, false);
    }

    @Override
    public LiveBinDataProvider addDummyCounterSource(CounterRecord record) {
        record.setKey(this.dummyKeySupplier.getAsInt());
        record.setCores(record.isPerCPU() ? this.mNumCPUCores : 1);
        return (LiveBinDataProvider)NullChecking.neverNull((Object)this.addSource(record, true));
    }

    @Override
    public void addData(CounterDisplay display, int core, int key, long value) {
        LiveBinDataProvider source = this.getProvider(key);
        if (source == null || core >= source.getCounterRecord().getCores()) {
            return;
        }
        source.addValue(display, core, value);
    }

    @Override
    public void addData(CounterDisplay display, int key, long value) {
        this.addData(display, 0, key, value);
    }

    @Override
    public boolean addVisualChart(@NonNull IUniqueThread uniqueThread) {
        int uid = this.mProcessData.getProcessUIDFor(uniqueThread);
        if (uid == -1) {
            this.mVisualUnknownThreads.add(uniqueThread);
            return false;
        }
        if (!this.mVisualUids.add(uid)) {
            return false;
        }
        this.getDynamicSourceListeners().forEach(l -> l.handleVisualSource(uniqueThread));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitOccurred() {
        ICommitListener[] listeners;
        LiveAllBinDataProvider uniqueThread;
        Iterator<IUniqueThread> it = this.mVisualUnknownThreads.iterator();
        while (it.hasNext()) {
            uniqueThread = it.next();
            if (!this.addVisualChart((IUniqueThread)uniqueThread)) continue;
            it.remove();
        }
        uniqueThread = this;
        synchronized (uniqueThread) {
            listeners = this.mCommitListeners.toArray(new ICommitListener[this.mCommitListeners.size()]);
        }
        ICommitListener[] iCommitListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ICommitListener listener = iCommitListenerArray[n2];
            listener.commitOccurred();
            ++n2;
        }
    }

    private synchronized @NonNull Stream<@NonNull IDynamicSourceListener> getDynamicSourceListeners() {
        return Stream.of(this.mDynamicSourceListeners.toArray(new IDynamicSourceListener[this.mDynamicSourceListeners.size()]));
    }

    @Override
    public void gatorDataReceived() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<@NonNull IBinDataProvider> getAllProviders() {
        BinDataSourceMap<LiveBinDataProvider> binDataSourceMap = this.mSourceMap;
        synchronized (binDataSourceMap) {
            return new ArrayList<IBinDataProvider>(this.mSourceMap.getAllProviders());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<@NonNull LiveBinDataProvider> getAllSelectedProviders() {
        BinDataSourceMap<LiveBinDataProvider> binDataSourceMap = this.mSourceMap;
        synchronized (binDataSourceMap) {
            return new ArrayList<LiveBinDataProvider>(this.mSourceMap.getAllSelectedProviders());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDummySource(@NonNull String source) {
        BinDataSourceMap<LiveBinDataProvider> binDataSourceMap = this.mSourceMap;
        synchronized (binDataSourceMap) {
            return this.mSourceMap.isInactiveSource(source);
        }
    }

    @Override
    public int getBinCount() {
        if (this.mDuration > 0 && this.mBinsCommitted > 10 * this.mDuration) {
            return 10 * this.mDuration;
        }
        return this.mBinsCommitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable LiveBinDataProvider getBinData(@NonNull String source) {
        BinDataSourceMap<LiveBinDataProvider> binDataSourceMap = this.mSourceMap;
        synchronized (binDataSourceMap) {
            return this.mSourceMap.getProvider(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull List<@NonNull ContentProposal> getContentProposals() {
        BinDataSourceMap<LiveBinDataProvider> binDataSourceMap = this.mSourceMap;
        synchronized (binDataSourceMap) {
            return this.mSourceMap.getContentProposals(arg_0 -> ((VariableReplacer)this.mVariableReplacer).replace(arg_0));
        }
    }

    @Override
    public int getCPUCoreCount() {
        return this.mNumCPUCores;
    }

    @Override
    public String getCPUCoreName(int core) {
        return (String)this.mCoreNames.get(core);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumSources() {
        BinDataSourceMap<LiveBinDataProvider> binDataSourceMap = this.mSourceMap;
        synchronized (binDataSourceMap) {
            return this.mSourceMap.getNumSources();
        }
    }

    @Override
    public @Nullable LiveBinDataProvider getProvider(int key) {
        return (LiveBinDataProvider)this.mKeyToProviderMap.get(key);
    }

    @Override
    public void incrementBin() {
        ++this.mBinsCommitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeData(int key, int numBins) {
        LiveBinDataProvider source = this.getProvider(key);
        if (source != null) {
            int cores = source.getCounterRecord().getCores();
            long[] values = new long[numBins];
            int core = 0;
            while (core < cores) {
                source.addValues(core, values);
                ++core;
            }
            this.getDynamicSourceListeners().forEach(l -> l.handleBinDataProvider(source));
        } else {
            TIntSet tIntSet = this.warnedMissingchartKeys;
            synchronized (tIntSet) {
                if (this.warnedMissingchartKeys.add(key)) {
                    StdLog.warning((Plugin)StreamlinePlugin.getInstance(), (String)("Missing chart for key " + key), null);
                }
            }
        }
    }

    @Override
    public boolean isDiscard() {
        return this.mDiscard;
    }

    @Override
    public void prepareRange(ZoomLevel zoomLevel, long start, long end) {
    }

    @Override
    public void prepareRange(ZoomLevel zoomLevel, long start, long end, Set<String> sources) {
    }

    @Override
    public synchronized void removeCommitListener(ICommitListener listener) {
        this.mCommitListeners.remove(listener);
    }

    @Override
    public synchronized void removeDynamicSourceListener(IDynamicSourceListener listener) {
        this.mDynamicSourceListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable LiveBinDataProvider addSource(@NonNull CounterRecord record, boolean isDummy) {
        int key = record.getKey();
        if (key == 0) {
            StreamlinePlugin.warning("Invalid Live counter key. Not all charts will be displayed in the Live view.");
            return null;
        }
        if (this.getProvider(key) != null) {
            StreamlinePlugin.warning("Conflicting Live counter keys. Not all charts will be displayed in the Live view.");
            return null;
        }
        LiveBinDataProvider source = new LiveBinDataProvider(record, this.processingElementsReferenceSet);
        BinDataSourceMap<LiveBinDataProvider> binDataSourceMap = this.mSourceMap;
        synchronized (binDataSourceMap) {
            if (this.mSourceMap.addSource(source, !isDummy)) {
                this.mKeyToProviderMap.put(key, (Object)source);
                return source;
            }
            StreamlinePlugin.warning(String.format("Failed to add source %s, it has no valid names.", record.getAlias()));
            return null;
        }
    }

    @Override
    public String getCPUCoreName(ProcessingElementReference peReference) {
        assert (peReference.vmUID == 0L);
        return this.getCPUCoreName(peReference.deviceNumber);
    }

    @Override
    public Set<@NonNull String> getInvalidSources() {
        return this.mInvalidSources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasBinDataSource(String key) {
        BinDataSourceMap<LiveBinDataProvider> binDataSourceMap = this.mSourceMap;
        synchronized (binDataSourceMap) {
            return this.mSourceMap.getProvider(key) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValidSource(@NonNull String source, @NonNull IntPredicate clusterFilter) {
        BinDataSourceMap<LiveBinDataProvider> binDataSourceMap = this.mSourceMap;
        synchronized (binDataSourceMap) {
            return this.mSourceMap.isActiveSource(source, clusterFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Set<@NonNull String> filterAndNormalizeSourceNames(@NonNull Set<@NonNull String> variableSetFromExpression) {
        BinDataSourceMap<LiveBinDataProvider> binDataSourceMap = this.mSourceMap;
        synchronized (binDataSourceMap) {
            return StreamUtils.filterOutNull(variableSetFromExpression.stream().map(s -> this.mSourceMap.getProviderAndProperName((String)s, true))).map(p -> (String)p.first).collect(Collectors.toSet());
        }
    }

    public static interface ICommitListener {
        public void commitOccurred();
    }

    public static interface IDynamicSourceListener {
        public void handleBinDataProvider(@NonNull LiveBinDataProvider var1);

        public void handleVisualSource(@NonNull IUniqueThread var1);
    }
}

