/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.iterable;

import com.arm.streamline.jni.apcdbgen.proto.CallPathNode;
import com.arm.streamline.jni.apcdbgen.proto.IBasicSourceReference;
import com.arm.streamline.jni.apcdbgen.proto.IExtractable;
import com.arm.streamline.jni.apcdbgen.proto.ISourceLineReference;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueProcessID;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueThreadID;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.apcdbgen.proto.SourceFile;
import com.arm.streamline.jni.apcdbgen.proto.Symbol;
import com.arm.streamline.model.iterable.SelectionIterator;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;

public class TimelineSelectionIterator
extends SelectionIterator<IUniqueThreadID> {
    private static @Nullable CallPathNode getOwningThreadOrProcessNode(@Nullable CallPathNode node) {
        while (node != null) {
            switch (node.type) {
                case PROCESS: 
                case THREAD: {
                    return node;
                }
                case SYMBOL: {
                    node = node.parent;
                    break;
                }
                case VMUID: {
                    return null;
                }
                default: {
                    throw new AssertionError(node.type);
                }
            }
        }
        return null;
    }

    public TimelineSelectionIterator(ISelection selection) {
        super(selection);
    }

    @Override
    protected void extract(@NonNull IExtractable extractable, final @NonNull List<@NonNull IUniqueThreadID> list) {
        extractable.accept((IExtractable.IExtractableVisitor)new IExtractable.IExtractableVisitor<Void, RuntimeException>(){

            public Void visit(@NonNull CallPathNode value) throws RuntimeException {
                IUniqueThreadID utid;
                CallPathNode root = TimelineSelectionIterator.getOwningThreadOrProcessNode(value);
                if (root != null && (utid = root.thread) != null) {
                    list.add(utid);
                }
                return null;
            }

            public Void visit(@NonNull IBasicSourceReference value) throws RuntimeException {
                return null;
            }

            public Void visit(@NonNull ISourceLineReference value) throws RuntimeException {
                return null;
            }

            public Void visit(@NonNull IUniqueProcessID value) throws RuntimeException {
                return null;
            }

            public Void visit(@NonNull IUniqueThreadID value) throws RuntimeException {
                list.add(value);
                return null;
            }

            public Void visit(@NonNull ReferencedSymbol value) throws RuntimeException {
                return null;
            }

            public Void visit(@NonNull ReferencedSymbol value, @NonNull Collection<@NonNull CallPathNode> associatedPaths) throws RuntimeException {
                for (CallPathNode node : associatedPaths) {
                    IUniqueThreadID utid;
                    CallPathNode root = TimelineSelectionIterator.getOwningThreadOrProcessNode(node);
                    if (root == null || (utid = root.thread) == null) continue;
                    list.add(utid);
                }
                return null;
            }

            public Void visit(@NonNull SourceFile value) throws RuntimeException {
                return null;
            }

            public Void visit(@NonNull Symbol value) throws RuntimeException {
                return null;
            }
        });
    }
}

