/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.chart;

import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.utility.expression2.ExpressionData;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SeriesRangeInfo {
    private final @NonNull CounterDisplay mDisplay;
    private final @NonNull ExpressionData mExpression;
    private final boolean mAverageCores;
    private final boolean mAverageSelection;
    private @Nullable TIntHashSet mUtids;
    private @Nullable ZoomLevel mUIZoomLevelOverride;
    private final @NonNull Set<@NonNull String> mExpressionSources;
    private final boolean mExpressionComplex;
    private final @NonNull ProcessingElementReference @NonNull [] mChannelDescriptors;

    public SeriesRangeInfo(@NonNull CounterDisplay display, @NonNull ExpressionData expression, boolean averageCores, boolean averageSelection, TIntHashSet utids, @NonNull ProcessingElementReference @NonNull [] channelDescriptors, @NonNull Set<@NonNull String> expressionSources, boolean expressionComplex) {
        this.mDisplay = display;
        this.mExpression = expression;
        this.mAverageCores = averageCores;
        this.mAverageSelection = averageSelection;
        this.mUtids = utids;
        this.mChannelDescriptors = channelDescriptors;
        this.mExpressionSources = expressionSources;
        this.mExpressionComplex = expressionComplex;
    }

    public SeriesRangeInfo(ISeriesDataProvider series, TIntHashSet utids, @NonNull Set<@NonNull String> expressionSources, boolean expressionComplex) {
        @NonNull Set<@NonNull ProcessingElementReference> channelDescriptors = series.getCoreInformationProvider().getChannelDescriptors();
        SeriesConfig config = series.getConfig();
        this.mDisplay = config.getDisplay();
        this.mExpression = config.getExpression();
        IChartDataProvider chart = series.getChart();
        this.mAverageCores = chart.isAverageCores();
        this.mAverageSelection = chart.isAverageSelection();
        this.mUtids = utids;
        this.mChannelDescriptors = channelDescriptors.toArray(new ProcessingElementReference[channelDescriptors.size()]);
        this.mExpressionSources = expressionSources;
        this.mExpressionComplex = expressionComplex;
    }

    public @NonNull ProcessingElementReference @NonNull [] getChannelDescriptors() {
        return this.mChannelDescriptors;
    }

    public @NonNull CounterDisplay getDisplay() {
        return this.mDisplay;
    }

    public @NonNull ExpressionData getExpression() {
        return this.mExpression;
    }

    public @NonNull Set<@NonNull String> getExpressionSources() {
        return this.mExpressionSources;
    }

    public @Nullable ZoomLevel getUIZoomLevelOverride() {
        return this.mUIZoomLevelOverride;
    }

    public @Nullable TIntHashSet getUtids() {
        return this.mUtids;
    }

    public boolean isAverageCores() {
        return this.mAverageCores;
    }

    public boolean isAverageSelection() {
        return this.mAverageSelection;
    }

    public boolean isExpressionComplex() {
        return this.mExpressionComplex;
    }

    public void setUIZoomLevelOverride(@Nullable ZoomLevel override) {
        this.mUIZoomLevelOverride = override;
    }

    public void setUtids(@Nullable TIntHashSet utids) {
        this.mUtids = utids;
    }
}

