/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.chart;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.ChartConfig;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.TimelineConfig;
import com.arm.streamline.model.chart.ChartUtility;
import com.arm.streamline.model.chart.VisualChartDataProvider;
import com.arm.streamline.model.templates.TemplateUtils;
import com.arm.streamline.model.timeline.TimelineChartDataProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Charts {
    public static final String CPU_ACTIVITY_USER_NAME = "CPUActivityUser";
    public static final String CPU_ACTIVITY_SYSTEM_NAME = "CPUActivitySystem";
    private final @NonNull Analysis mAnalysis;
    private final @NonNull List<@NonNull IChartDataProvider> mCharts = new ArrayList<IChartDataProvider>();
    private final @NonNull List<@NonNull IChartDataProvider> mProcCharts = new ArrayList<IChartDataProvider>();

    public Charts(@NonNull Analysis analysis) {
        this.mAnalysis = analysis;
        switch (this.mAnalysis.getDefaultTemplateMode()) {
            case FORCE_PROVIDED: {
                this.loadFromTimelineConfiguration(false);
                break;
            }
            case USE_DEFAULT_BASIC: {
                this.loadFromDefaultConfiguration(true);
                break;
            }
            case USE_DEFAULT_WITH_METRICS: {
                this.loadFromDefaultConfiguration(false);
                break;
            }
            case USE_PROVIDED_OR_PREFER_BASIC: {
                if (analysis.isTimelineConfigurationLoadedFromFile()) {
                    this.loadFromTimelineConfiguration(true);
                    break;
                }
                this.loadFromCapturedTemplates(true);
                break;
            }
            case USE_PROVIDED_OR_PREFER_METRICS: {
                if (analysis.isTimelineConfigurationLoadedFromFile()) {
                    this.loadFromTimelineConfiguration(false);
                    break;
                }
                this.loadFromCapturedTemplates(false);
                break;
            }
            default: {
                throw new AssertionError((Object)this.mAnalysis.getDefaultTemplateMode());
            }
        }
    }

    private void loadFromDefaultConfiguration(boolean empty) {
        for (ChartAndSeriesConfig configChart : this.mAnalysis.getDefaultTimelineConfiguration(empty).getCharts()) {
            this.addNewChart(configChart);
        }
    }

    private void loadFromTimelineConfiguration(boolean preferEmpty) {
        TimelineConfig timelineConfig = this.mAnalysis.getTimelineConfiguration(preferEmpty);
        for (ChartAndSeriesConfig configChart : timelineConfig.getCharts()) {
            this.addNewChart(configChart);
        }
    }

    private void loadFromCapturedTemplates(boolean preferEmpty) {
        List<ChartAndSeriesConfig> templateCharts = this.mAnalysis.getTemplates().stream().flatMap(t -> {
            IntPredicate clusterFilter = TemplateUtils.makeClusterFilterPredicate(t, this.mAnalysis.getClustersInfo());
            return TemplateUtils.getChartAndSeriesConfigsToBeApplied(t, false, this.mAnalysis.getAllBinData(), clusterFilter).stream();
        }).collect(Collectors.toList());
        if (templateCharts.isEmpty()) {
            this.loadFromTimelineConfiguration(preferEmpty);
        } else {
            TimelineConfig timelineConfig = this.mAnalysis.getTimelineConfiguration(preferEmpty);
            templateCharts.addAll(ChartUtility.diffChartsAndSeries(templateCharts, timelineConfig.getCharts(), this.mAnalysis));
            for (ChartAndSeriesConfig configChart : templateCharts) {
                this.addNewChart(configChart);
            }
        }
    }

    public @Nullable IChartDataProvider addNewChart(@NonNull ChartAndSeriesConfig chartAndSeriesConfig) {
        ChartConfig configChart;
        IChartDataProvider chart;
        block4: {
            chart = null;
            configChart = chartAndSeriesConfig.getChart();
            if (configChart.getSeriesComposition() == SeriesComposition.VISUAL_ANNOTATION) {
                chart = new VisualChartDataProvider(this.mAnalysis, configChart);
                break block4;
            }
            TimelineChartDataProvider timelineChart = new TimelineChartDataProvider(this.mAnalysis, configChart);
            chart = ChartUtility.addNewChartToChartDataProvider(chartAndSeriesConfig, timelineChart, this.mAnalysis);
            if (!chart.getSeries().isEmpty() || chartAndSeriesConfig.getUnexpandedSeries().isEmpty()) break block4;
            return null;
        }
        try {
            this.mCharts.add(chart);
        }
        catch (Exception exception) {
            CommonPlugin.error((String)("Failed adding chart " + configChart.getTitle()), (Throwable)exception);
        }
        return chart;
    }

    public boolean isDuplicateChart(@NonNull ChartAndSeriesConfig chartAndSeriesConfig) {
        return ChartUtility.isDuplicateChart(chartAndSeriesConfig, this.mAnalysis.getAllBinData(), this.mCharts);
    }

    public Analysis getAnalysis() {
        return this.mAnalysis;
    }

    public @NonNull List<@NonNull IChartDataProvider> getCharts() {
        return this.mCharts;
    }

    public int getProcChartCount() {
        return this.mProcCharts.size();
    }
}

