/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.capture;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.editortabs.timeline.common.charts.WildcardSeriesConfigUtility;
import com.arm.streamline.model.bindata.IAllBinDataProvider;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.capture.AbstractSeriesConfig;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.model.capture.SeriesConfigUtility;
import com.arm.streamline.model.templates.TemplateUtils;
import com.arm.streamline.utility.RGBUtils;
import com.arm.streamline.utility.expression2.ExpressionData;
import com.arm.utils.NullChecking;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;

public class WildcardSeriesConfig
extends AbstractSeriesConfig
implements Cloneable {
    private @NonNull String matchWith = "";
    private final boolean optional;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getDescriptionFormat().hashCode();
        result = 31 * result + this.getDisplay().hashCode();
        result = 31 * result + this.matchWith.hashCode();
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + this.getColor().hashCode();
        result = 31 * result + this.getUnits().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WildcardSeriesConfig other = (WildcardSeriesConfig)obj;
        if (!this.getDescriptionFormat().equals(other.getDescriptionFormat())) {
            return false;
        }
        if (this.getDisplay() != other.getDisplay()) {
            return false;
        }
        if (!this.matchWith.equals(other.matchWith)) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getColor().equals((Object)other.getColor())) {
            return false;
        }
        return this.getUnits().equals(other.getUnits());
    }

    public WildcardSeriesConfig(boolean optional) {
        this.optional = optional;
    }

    public WildcardSeriesConfig() {
        this(false);
    }

    @Override
    public final @NonNull WildcardSeriesConfig clone() {
        WildcardSeriesConfig series = new WildcardSeriesConfig(this.optional);
        series.setName(this.getName());
        series.matchWith = this.matchWith;
        series.setDisplay(this.getDisplay());
        series.setDescriptionFormat(this.getDescriptionFormat());
        series.setColor(this.getColor());
        series.setUnits(this.getUnits());
        series.setAutoRotateColor(this.isAutoRotateColor());
        series.setColorList(this.getColorList());
        return series;
    }

    public final String toString() {
        return "Wildcard Series Config: " + this.getName();
    }

    @Override
    public @NonNull String getMatchWith() {
        return this.matchWith;
    }

    public void setMatchWith(@NonNull String matchWith) {
        if (!this.matchWith.equals(matchWith.trim())) {
            this.matchWith = matchWith.trim();
        }
    }

    public boolean isValidMatchWithPattern() {
        return this.matchWith.startsWith("$") && this.matchWith.endsWith("*");
    }

    private @NonNull List<@NonNull SeriesConfig> deriveMatchingConfigs(@NonNull Set<@NonNull String> sourceNames) {
        if (this.isValidMatchWithPattern()) {
            List filter = sourceNames.stream().filter(src -> src.startsWith(SeriesConfigUtility.getMatchPrefix(this.getMatchWith()))).collect(Collectors.toList());
            if (filter.size() == 1) {
                return List.of(SeriesConfig.create(SeriesConfigUtility.deriveSeriesConfNameFromWildcard(this.getName(), (String)filter.get(0), this.getMatchWith()), this.getDescriptionFormat(), "$" + (String)filter.get(0), this.getDisplay(), this.getUnits(), this.getColorList().size() > 0 ? SeriesConfigUtility.getNextColorFromColorList(this.getColorList(), 0) : this.getColor(), this.optional, this));
            }
            if (!this.isAutoRotateColor() && this.getColorList().size() > 0) {
                return IntStream.range(0, filter.size()).mapToObj(i -> SeriesConfig.create(SeriesConfigUtility.deriveSeriesConfNameFromWildcard(this.getName(), (String)filter.get(i), this.getMatchWith()), this.getDescriptionFormat(), "$" + (String)filter.get(i), this.getDisplay(), this.getUnits(), SeriesConfigUtility.getNextColorFromColorList(this.getColorList(), i), this.optional, this)).collect(Collectors.toList());
            }
            AtomicInteger colorCount = new AtomicInteger(0);
            return sourceNames.stream().filter(src -> src.startsWith(SeriesConfigUtility.getMatchPrefix(this.getMatchWith()))).map(m -> SeriesConfig.create(SeriesConfigUtility.deriveSeriesConfNameFromWildcard(this.getName(), m, this.getMatchWith()), this.getDescriptionFormat(), "$" + m, this.getDisplay(), this.getUnits(), this.isAutoRotateColor() ? SeriesConfigUtility.getNextColor(colorCount.getAndIncrement()) : this.getColor(), this.optional, this)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private @NonNull List<@NonNull SeriesConfig> determineApplicableSeriesConfigs(@NonNull IAllBinDataProvider allBinDataProvider, @NonNull IntPredicate clusterFilter) {
        if (this.isValidMatchWithPattern()) {
            List<? extends IBinDataProvider> allProviders = allBinDataProvider.getAllProviders();
            Set<String> allSourceNames = allProviders.stream().flatMap(p -> p.getAllUniqueSourceNames().stream()).collect(Collectors.toSet());
            List<@NonNull SeriesConfig> deriveMatchingConfigs = this.deriveMatchingConfigs(allSourceNames);
            return deriveMatchingConfigs.stream().filter(s -> TemplateUtils.hasAllSources(s, allBinDataProvider, clusterFilter)).distinct().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static @NonNull WildcardSeriesConfig create(@NonNull String name, @NonNull String descp, @NonNull String matchwith, @Nullable CounterDisplay counterDisplay, @NonNull String units, @Nullable RGB color, boolean autoRotate, @NonNull String colorList, boolean optional) {
        WildcardSeriesConfig config = new WildcardSeriesConfig(optional);
        config.setName(name);
        config.setDescriptionFormat(descp);
        config.setMatchWith(matchwith);
        config.setDisplay(counterDisplay);
        config.setUnits(units);
        config.setColor(color == null ? (RGB)NullChecking.neverNull((Object)RGBUtils.decode("60,150,251")) : color);
        config.setAutoRotateColor(autoRotate);
        try {
            config.setColorList(WildcardSeriesConfigUtility.getColorList(colorList));
        }
        catch (Exception e) {
            CommonPlugin.warning((String)("Error while adding color list : " + e.getMessage()));
        }
        return config;
    }

    public static @NonNull WildcardSeriesConfig create(@NonNull String name, @NonNull String descp, @NonNull String matchwith, @Nullable CounterDisplay counterDisplay, @NonNull String units, @Nullable RGB color, boolean autoRotate, @NonNull String colorList) {
        return WildcardSeriesConfig.create(name, descp, matchwith, counterDisplay, units, color, autoRotate, colorList, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean matchesTyped(@NonNull AbstractSeriesConfig o) {
        AbstractSeriesConfig abstractSeriesConfig = o;
        if (abstractSeriesConfig instanceof WildcardSeriesConfig) {
            void that;
            WildcardSeriesConfig wildcardSeriesConfig = (WildcardSeriesConfig)abstractSeriesConfig;
            WildcardSeriesConfig cfr_ignored_0 = (WildcardSeriesConfig)abstractSeriesConfig;
            return this.matchWith.equals(that.matchWith);
        }
        return false;
    }

    @Override
    public void addListener(@NonNull SeriesConfig.IListener listener) {
    }

    @Override
    public void removeListener(@NonNull SeriesConfig.IListener listener) {
    }

    @Override
    public void notifyListeners() {
    }

    @Override
    public boolean isExpandedSeries() {
        return false;
    }

    @Override
    public @Nullable ExpressionData getExpression() {
        return null;
    }

    @Override
    public @NonNull List<@NonNull SeriesConfig> createSeriesFromSources(@NonNull IAllBinDataProvider allBinDataProvider) {
        return this.createSeriesFromSources(allBinDataProvider, i -> true);
    }

    @Override
    public @NonNull List<@NonNull SeriesConfig> createSeriesFromSources(@NonNull IAllBinDataProvider allBinDataProvider, @NonNull IntPredicate clusterFilter) {
        return this.determineApplicableSeriesConfigs(allBinDataProvider, clusterFilter);
    }

    @Override
    public void setExpression(@NonNull String expression) {
        throw new AssertionError((Object)"Cannot set expression in wildcard series");
    }

    @Override
    public boolean isWildcardSeries() {
        return true;
    }

    @Override
    public @NonNull List<@NonNull SeriesConfig> createSeriesFromSources(@NonNull List<@NonNull String> sources) {
        Set<String> sourceListWithoutDuplicates = sources.stream().distinct().collect(Collectors.toSet());
        return this.deriveMatchingConfigs(sourceListWithoutDuplicates);
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }
}

