/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.capture;

import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.model.bindata.IAllBinDataProvider;
import com.arm.streamline.model.capture.AbstractSeriesConfig;
import com.arm.streamline.model.capture.WildcardSeriesConfig;
import com.arm.streamline.model.templates.TemplateUtils;
import com.arm.streamline.utility.expression2.ExpressionData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.IntPredicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;

public class SeriesConfig
extends AbstractSeriesConfig
implements Cloneable {
    private @Nullable WildcardSeriesConfig expandedFromWildCard;
    private @NonNull ExpressionData mExpression = new ExpressionData("");
    private @NonNull List<@NonNull IListener> mListeners = new ArrayList<IListener>();
    private final boolean optional;

    public static @NonNull SeriesConfig create(String name, String description, String expression, CounterDisplay display, String units, RGB color, boolean optional) {
        SeriesConfig config = new SeriesConfig(optional);
        config.setName(name);
        config.setDescriptionFormat(description);
        config.setExpression(expression);
        config.setDisplay(display);
        config.setUnits(units);
        config.setColor(color);
        return config;
    }

    public static @NonNull SeriesConfig create(String name, String description, String expression, CounterDisplay display, String units, RGB color) {
        return SeriesConfig.create(name, description, expression, display, units, color, false);
    }

    public static @NonNull SeriesConfig create(String name, String description, String expression, CounterDisplay display, String units, RGB color, boolean optional, @Nullable WildcardSeriesConfig expandedfrom) {
        SeriesConfig config = new SeriesConfig(optional);
        config.setName(name);
        config.setDescriptionFormat(description);
        config.setExpression(expression);
        config.setDisplay(display);
        config.setUnits(units);
        config.setColor(color);
        config.setExpandedFromWildCard(expandedfrom);
        return config;
    }

    public static @NonNull SeriesConfig create(String name, String description, String expression, CounterDisplay display, String units, RGB color, @Nullable WildcardSeriesConfig expandedfrom) {
        return SeriesConfig.create(name, description, expression, display, units, color, false, expandedfrom);
    }

    public SeriesConfig(boolean optional) {
        this.optional = optional;
    }

    public SeriesConfig() {
        this(false);
    }

    @Override
    public final synchronized void addListener(IListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public final @NonNull SeriesConfig clone() {
        SeriesConfig series = new SeriesConfig(this.optional);
        series.setName(this.getName());
        series.expandedFromWildCard = this.expandedFromWildCard;
        series.mExpression = this.mExpression;
        series.setDisplay(this.getDisplay());
        series.setUnits(this.getUnits());
        series.setDescriptionFormat(this.getDescriptionFormat());
        series.setColor(this.getColor());
        series.mListeners = new ArrayList<IListener>();
        return series;
    }

    @Override
    public @NonNull List<@NonNull SeriesConfig> createSeriesFromSources(@NonNull IAllBinDataProvider allBinDataProvider, @NonNull IntPredicate clusterFilter) {
        return TemplateUtils.hasAllSources(this, allBinDataProvider, clusterFilter) ? List.of(this) : Collections.emptyList();
    }

    @Override
    public @NonNull List<@NonNull SeriesConfig> createSeriesFromSources(@NonNull List<@NonNull String> sources) {
        return List.of(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SeriesConfig other = (SeriesConfig)obj;
        if (this.getDisplay() != other.getDisplay()) {
            return false;
        }
        return this.mExpression.equals(other.mExpression);
    }

    public @Nullable WildcardSeriesConfig getExpandedFromWildCard() {
        return this.expandedFromWildCard;
    }

    @Override
    public final @NonNull ExpressionData getExpression() {
        return this.mExpression;
    }

    @Override
    public @Nullable String getMatchWith() {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getDisplay().hashCode();
        result = 31 * result + this.mExpression.hashCode();
        return result;
    }

    @Override
    public boolean isExpandedSeries() {
        return this.getExpandedFromWildCard() != null;
    }

    @Override
    public boolean isWildcardSeries() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean matchesTyped(@NonNull AbstractSeriesConfig o) {
        AbstractSeriesConfig abstractSeriesConfig = o;
        if (abstractSeriesConfig instanceof SeriesConfig) {
            void that;
            SeriesConfig seriesConfig = (SeriesConfig)abstractSeriesConfig;
            SeriesConfig cfr_ignored_0 = (SeriesConfig)abstractSeriesConfig;
            return this.mExpression.equals(that.mExpression);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void notifyListeners() {
        IListener[] listeners;
        SeriesConfig seriesConfig = this;
        synchronized (seriesConfig) {
            listeners = this.mListeners.toArray(new IListener[this.mListeners.size()]);
        }
        IListener[] iListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IListener listener = iListenerArray[n2];
            listener.expressionOrDisplayModified();
            ++n2;
        }
    }

    @Override
    public final synchronized void removeListener(IListener listener) {
        this.mListeners.remove(listener);
    }

    public void setExpandedFromWildCard(@Nullable WildcardSeriesConfig expandedFromWildCard) {
        this.expandedFromWildCard = expandedFromWildCard;
    }

    @Override
    public final void setExpression(@NonNull String expression) {
        expression = expression.trim();
        if (!this.mExpression.getString().equals(expression)) {
            this.mExpression = new ExpressionData(expression);
            this.notifyListeners();
        }
    }

    public final String toString() {
        return "Series Config: " + this.getName();
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    public static interface IListener {
        public void expressionOrDisplayModified();
    }
}

