/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.capture;

import com.arm.streamline.common.model.Position;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.model.capture.ICalipersListener;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.TimelineConfig;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class Calipers {
    private ICaptureDataProvider mDataProvider;
    private long mLeft = -1L;
    private long mRight = -1L;
    private List<ICalipersListener> mListeners = new ArrayList<ICalipersListener>();

    public Calipers(ICaptureDataProvider dataProvider) {
        this.mDataProvider = dataProvider;
    }

    public final synchronized void addListener(ICalipersListener listener) {
        this.mListeners.add(listener);
    }

    public final void adjustToNewScale(@NonNull ZoomLevel oldZoomLevel, @NonNull ZoomLevel zoomLevel) {
        if (this.mLeft >= 0L) {
            this.adjust(Position.scale((long)this.mLeft, (ZoomLevel)oldZoomLevel, (ZoomLevel)zoomLevel), Position.scale((long)this.mRight, (ZoomLevel)oldZoomLevel, (ZoomLevel)zoomLevel));
        }
    }

    public final boolean canBeReset() {
        return this.mLeft != -1L;
    }

    public final ICaptureDataProvider getDataProvider() {
        return this.mDataProvider;
    }

    public final long getLeft() {
        return this.mLeft >= 0L ? this.mLeft : 0L;
    }

    public final long getMax() {
        return this.mDataProvider.getLastBinCount();
    }

    public final long getRight() {
        return this.mRight >= 0L ? this.mRight : this.getMax();
    }

    public final void load(TimelineConfig config) {
        if (config.getCalipersLeft() < 0L) {
            this.mLeft = -1L;
            this.mRight = -1L;
        } else {
            @NonNull ZoomLevel zoomLevel = this.mDataProvider.getScales().getZoomLevel();
            this.mLeft = Position.scale((long)config.getCalipersLeft(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)zoomLevel);
            this.mRight = Position.scale((long)config.getCalipersRight(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)zoomLevel);
            this.mDataProvider.setFilterRange(zoomLevel, this.getLeft(), this.getRight());
        }
    }

    public final synchronized void removeListener(ICalipersListener listener) {
        this.mListeners.remove(listener);
    }

    public final void reset() {
        this.adjust(0L, this.getMax());
    }

    public final void save(TimelineConfig config) {
        if (this.mLeft == -1L) {
            config.setCalipersLeft(-1L);
            config.setCalipersRight(-1L);
        } else {
            @NonNull ZoomLevel zoomLevel = this.mDataProvider.getScales().getZoomLevel();
            config.setCalipersLeft(Position.scale((long)this.mLeft, (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL));
            config.setCalipersRight(Position.scale((long)this.mRight, (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL));
        }
    }

    public final void set(long left, long right) {
        if ((left = this.fitToRange(left)) > (right = this.fitToRange(right))) {
            long tmp = left;
            left = right;
            right = tmp;
        }
        this.adjust(left, right);
    }

    public final void setLeft(long left) {
        left = this.fitToRange(left);
        long right = this.getRight();
        this.adjust(left, this.fitToRange(right <= left ? left + 1L : right));
    }

    public final void setRight(long right) {
        right = this.fitToRange(right);
        long left = this.getLeft();
        this.adjust(this.fitToRange(left >= right ? right - 1L : left), right);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void adjust(long left, long right) {
        if (left == right) {
            if (right < this.getMax()) {
                right = left + 1L;
            } else if (left > 0L) {
                --left;
            }
        }
        if (left == 0L && right == this.getMax()) {
            left = -1L;
            right = -1L;
        }
        if (this.mLeft != left || this.mRight != right) {
            ICalipersListener[] listeners;
            this.mLeft = left;
            this.mRight = right;
            Calipers calipers = this;
            synchronized (calipers) {
                listeners = this.mListeners.toArray(new ICalipersListener[this.mListeners.size()]);
            }
            ICalipersListener[] iCalipersListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                ICalipersListener listener = iCalipersListenerArray[n2];
                listener.calipersChanged(this);
                ++n2;
            }
            @NonNull ZoomLevel zoomLevel = this.mDataProvider.getScales().getZoomLevel();
            this.mDataProvider.setFilterRange(zoomLevel, this.getLeft(), this.getRight());
        }
    }

    private final long fitToRange(long value) {
        if (value < 0L) {
            value = 0L;
        } else {
            long max = this.getMax();
            if (value > max) {
                value = max;
            }
        }
        return value;
    }
}

