/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.capture;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public class CAMConfig
implements Cloneable {
    public static final String TAG = "cam";
    private static final String ATTR_VIEW_ID = "view_id";
    private static final String ATTR_SHOW_CONNECTIONS = "show_cam_connections";
    private static final String TAG_DISABLED_TRACKS = "disabled_tracks";
    private static final String TAG_TRACK = "track";
    private static final String ATTR_TRACK_ID = "track_id";
    private boolean mShowCamConnections;
    private String mViewId;
    private final @NonNull Set<@NonNull Integer> mDisabledTracks;

    public CAMConfig() {
        this.mDisabledTracks = new HashSet<Integer>();
    }

    public CAMConfig(boolean showConnections) {
        this.mShowCamConnections = showConnections;
        this.mDisabledTracks = new HashSet<Integer>();
    }

    public CAMConfig(String viewId, boolean showConnections, @NonNull Set<@NonNull Integer> disabledtracks) {
        this.mShowCamConnections = showConnections;
        this.mViewId = viewId;
        this.mDisabledTracks = disabledtracks;
    }

    public @NonNull CAMConfig clone() {
        CAMConfig result = new CAMConfig();
        result.mShowCamConnections = this.mShowCamConnections;
        result.mViewId = this.mViewId;
        return result;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void loadDisabledTracks(XMLParser in) throws IOException {
        while ((tag = in.nextTag("cam")) != null) {
            var3_3 = tag;
            tmp = -1;
            switch (var3_3.hashCode()) {
                case 1546418091: {
                    if (!var3_3.equals("disabled_tracks")) break;
                    tmp = 1;
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    if (true) ** GOTO lbl30
                }
            }
            continue;
            block13: do {
                var4_4 = tag;
                tmp = -1;
                switch (var4_4.hashCode()) {
                    case 110621003: {
                        if (!var4_4.equals("track")) break;
                        tmp = 1;
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        id = in.getIntegerAttribute("track_id", -1);
                        if (id == -1) continue block13;
                        this.mDisabledTracks.add(id);
                        break;
                    }
                }
lbl30:
                // 4 sources

            } while ((tag = in.nextTag("disabled_tracks")) != null);
            ** break;
lbl32:
            // 1 sources

        }
    }

    public void load(XMLParser in) {
        this.reset();
        this.mViewId = in.getAttribute(ATTR_VIEW_ID, "");
        this.mShowCamConnections = in.isAttributeSet(ATTR_SHOW_CONNECTIONS, false);
        try {
            this.loadDisabledTracks(in);
        }
        catch (IOException e) {
            CommonPlugin.error((Throwable)e);
        }
    }

    private void reset() {
        this.mViewId = "";
        this.mShowCamConnections = false;
        this.mDisabledTracks.clear();
    }

    public Object save(XMLGenerator xml) throws IOException {
        xml.startTag(TAG);
        xml.addAttribute(ATTR_VIEW_ID, this.mViewId);
        xml.addAttributeBool(ATTR_SHOW_CONNECTIONS, this.mShowCamConnections);
        xml.startTag(TAG_DISABLED_TRACKS);
        for (Integer id : this.mDisabledTracks) {
            xml.startTag(TAG_TRACK);
            xml.addAttribute(ATTR_TRACK_ID, id.intValue());
            xml.endTag();
        }
        xml.endTag();
        xml.endTag();
        return null;
    }

    public boolean showAllCAMConnections() {
        return this.mShowCamConnections;
    }

    public String getViewId() {
        return this.mViewId;
    }

    public @NonNull Set<@NonNull Integer> getDisabledTracks() {
        return Collections.unmodifiableSet(this.mDisabledTracks);
    }
}

