/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.cam;

import com.arm.streamline.analysis.model.cam.ICAMDetailPanelInfo;
import com.arm.streamline.analysis.model.cam.ICAMJobSelection;
import com.arm.streamline.editortabs.timeline.common.cam.DebugLabelFormatter;
import com.arm.streamline.jni.apcdbgen.proto.ICAMDataProvider;
import com.arm.streamline.jni.apcdbgen.proto.ICAMJob;
import com.arm.streamline.jni.apcdbgen.proto.ICAMTrack;
import com.arm.streamline.jni.apcdbgen.proto.IGPUWorkloadJob;
import com.arm.streamline.jni.apcdbgen.proto.StageType;
import com.arm.streamline.jni.apcdbgen.proto.TimelineWorkload;
import com.arm.utils.NullChecking;
import gnu.trove.iterator.TObjectDoubleIterator;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;

public class CAMMaliTimeLineInfoModel
implements ICAMDetailPanelInfo {
    private static final int MAX_WORK_LOADS = 5;
    private static final double NANO_TIME = 1.0E9;
    private static final double MILLI_TIME = 1000000.0;
    private final @NonNull String ACTIVE_REGION = "Active region:";
    private final @NonNull String START = "Start";
    private final @NonNull String DURATION = "Duration";
    private final @NonNull String NEW_LINE = "\n";
    private final @NonNull String UTILIZATION = "Utilization";
    private final @NonNull String FRAMES = "Frames";
    private final @NonNull String PERFORMANCE = "Performance";
    private final @NonNull String NAME = "Name";
    private final @NonNull String STREAM = "Stream";
    private final @NonNull String STAGE = "Stage";
    private final @NonNull String ACTIVE_WORKLOAD_RUNTIME = "Active workload runtime:";
    private final @NonNull String WORKLOAD_RUNTIME = "Workload runtime:";
    private final @NonNull String WORKLOAD_PROPERTIES = "Workload properties:";
    private final @NonNull String TOP_WORKLOAD_RUNTIME = "Top %s workload runtimes:";
    private final @NonNull String FPS = " FPS";
    private final @NonNull String API_WORKLOADS = "API workloads";
    private final @NonNull String HW_WORKLOADS = "Hardware workloads";
    private final @NonNull ICAMDataProvider provider;
    private final @NonNull ICAMJobSelection camJobSelectionModel;
    private final @NonNull DebugLabelFormatter debugLabelFormatter;

    public CAMMaliTimeLineInfoModel(@NonNull ICAMDataProvider provider, @NonNull ICAMJobSelection selectionModel, @NonNull DebugLabelFormatter debugLabelFormatter) {
        this.provider = provider;
        this.camJobSelectionModel = selectionModel;
        this.debugLabelFormatter = debugLabelFormatter;
    }

    public @NonNull String getActiveRegionStats(long startTime, long endTime) {
        StringBuilder stats = new StringBuilder();
        long duration = endTime - startTime;
        stats.append("Active region:").append("\n");
        stats.append(String.format(" %s: %.2f s", "Start", (double)startTime / 1.0E9)).append("\n");
        stats.append(String.format(" %s: %.2f ms", "Duration", (double)duration / 1000000.0)).append("\n");
        if (duration > 0L) {
            List<ICAMTrack> allLeafTracks = CAMMaliTimeLineInfoModel.getAllLeafTracks(this.provider.getTracks());
            Map<ICAMTrack, List<ICAMJob>> trackToJobsMap = allLeafTracks.stream().collect(Collectors.toMap(track -> track, track -> track.getJobs(startTime, endTime)));
            if (!trackToJobsMap.isEmpty()) {
                this.computeFrameRateReport(stats, startTime, duration, trackToJobsMap);
                stats.append("\n");
                this.computeUtilizationReport(stats, startTime, duration, trackToJobsMap);
                stats.append("\n");
            }
            @NonNull Set<@NonNull ICAMJob> jobsInRange = CAMMaliTimeLineInfoModel.getActiveJobsInTimeRange(allLeafTracks, startTime, endTime);
            stats.append(this.getActiveEventStatsForJobs(jobsInRange));
        }
        return stats.toString();
    }

    private static @NonNull Set<@NonNull ICAMJob> getActiveJobsInTimeRange(@NonNull List<@NonNull ICAMTrack> tracks, long startTime, long endTime) {
        return tracks.stream().flatMap(track -> track.getJobs(startTime, endTime).stream()).filter(job -> job.getStartTime() >= startTime && job.getStopTime() <= endTime).collect(Collectors.toSet());
    }

    private static @NonNull List<@NonNull ICAMTrack> getAllLeafTracks(@NonNull List<@NonNull ICAMTrack> list) {
        return list.stream().flatMap(CAMMaliTimeLineInfoModel::flattenTracks).filter(track -> track.getChildren().isEmpty()).collect(Collectors.toList());
    }

    private static @NonNull Stream<@NonNull ICAMTrack> flattenTracks(@NonNull ICAMTrack track) {
        return Stream.concat(Stream.of(track), track.getChildren().stream().flatMap(CAMMaliTimeLineInfoModel::flattenTracks));
    }

    public @NonNull String getActiveEventStats() {
        return this.getActiveEventStatsForJobs(this.camJobSelectionModel.getSelectedJobs());
    }

    public @NonNull String getActiveEventStatsForJobs(@NonNull Set<@NonNull ICAMJob> jobs) {
        StringBuilder stats = new StringBuilder();
        Set<ICAMJob> selectedJobs = jobs;
        if (selectedJobs.size() == 1) {
            this.computeActiveEventStatsSingle(stats, selectedJobs.iterator().next());
        } else if (selectedJobs.size() > 1) {
            this.computeActiveEventStatsMulti(stats, selectedJobs);
        }
        return stats.toString();
    }

    private void computeActiveEventStatsSingle(@NonNull StringBuilder stats, @NonNull ICAMJob camJob) {
        boolean isWorkLoadType = camJob instanceof IGPUWorkloadJob;
        stats.append("Active workload runtime:").append("\n");
        stats.append(String.format(" %s: %s", "API workloads", isWorkLoadType ? "1" : "0")).append("\n");
        stats.append(String.format(" %s: %s", "Hardware workloads", "1")).append("\n");
        stats.append(String.format(" %s: %.2f ms", camJob.getTrack().getTitle(), (double)(camJob.getStopTime() - camJob.getStartTime()) / 1000000.0)).append("\n");
        stats.append("\n");
        if (isWorkLoadType) {
            stats.append("Workload properties:").append("\n");
            IGPUWorkloadJob gpuJob = (IGPUWorkloadJob)camJob;
            List debugLabels = gpuJob.getTimelineWorkload().getDebugLabels();
            if (!debugLabels.isEmpty()) {
                stats.append(String.format(" %s: %s", "Name", this.debugLabelFormatter.formatLabels(debugLabels))).append("\n");
            } else {
                stats.append(String.format(" %s: <%s #%d>", "Name", gpuJob.getTimelineWorkload().getName(), gpuJob.getTimelineWorkload().getId())).append("\n");
            }
            stats.append(String.format(" %s: %s", "Stream", camJob.getTrack().getTitle())).append("\n");
            StageType stageType = gpuJob.getPerfettoWorkload().getStageTypeAsEnum();
            if (stageType != null) {
                stats.append(String.format(" %s: %s", "Stage", stageType.stageName())).append("\n");
            }
            stats.append(String.format(" %s: %.2f ms", "Duration", (double)(camJob.getStopTime() - camJob.getStartTime()) / 1000000.0)).append("\n");
            Map properties = gpuJob.getTimelineWorkload().getProperties();
            properties.entrySet().stream().forEach(entry -> stats.append(String.format(" %s: %s", entry.getKey(), entry.getValue())).append("\n"));
        } else {
            stats.append("Workload properties:").append("-").append("\n");
        }
    }

    private void computeActiveEventStatsMulti(@NonNull StringBuilder stats, @NonNull Set<@NonNull ICAMJob> selectedJobs) {
        stats.append("Active workload runtime:").append("\n");
        Map<TimelineWorkload, Map<String, Double>> tagStreamTimeMap = CAMMaliTimeLineInfoModel.getAllTagStreamTimeMap(selectedJobs);
        stats.append(String.format(" %s: %s", "API workloads", Integer.toString(tagStreamTimeMap.size()))).append("\n");
        stats.append(String.format(" %s: %s", "Hardware workloads", Integer.toString(selectedJobs.size()))).append("\n");
        TObjectDoubleIterator activeStreamsIterator = CAMMaliTimeLineInfoModel.getActiveStreamTimeMap(selectedJobs).iterator();
        while (activeStreamsIterator.hasNext()) {
            activeStreamsIterator.advance();
            stats.append(String.format(" %s: %.2f ms", activeStreamsIterator.key(), activeStreamsIterator.value())).append("\n");
        }
        stats.append("\n");
        int limit = Math.min(tagStreamTimeMap.size(), 5);
        Map<TimelineWorkload, Map<String, Double>> activeTopTags = CAMMaliTimeLineInfoModel.getTopTagTimeMap(tagStreamTimeMap, limit);
        if (activeTopTags.size() == 0) {
            stats.append("Workload runtime:").append("-").append("\n");
        } else if (activeTopTags.size() > 1) {
            stats.append(String.format("Top %s workload runtimes:", String.valueOf(activeTopTags.size()))).append("\n");
            this.appendWorkloads(stats, activeTopTags);
        } else {
            stats.append("Workload runtime:").append("\n");
            this.appendWorkloads(stats, activeTopTags);
        }
    }

    private void appendWorkloads(@NonNull StringBuilder stats, @NonNull Map<@NonNull TimelineWorkload, @NonNull Map<@NonNull String, @NonNull Double>> activeTopTags) {
        for (Map.Entry<TimelineWorkload, Map<String, Double>> tags : activeTopTags.entrySet()) {
            TimelineWorkload properties = tags.getKey();
            if (!properties.getDebugLabels().isEmpty()) {
                stats.append(String.format(" %s: %s", "Name", this.debugLabelFormatter.formatLabels(properties.getDebugLabels()))).append("\n");
            } else {
                stats.append(String.format(" %s: <%s #%d>", "Name", properties.getName(), properties.getId())).append("\n");
            }
            for (Map.Entry<String, Double> streamTime : tags.getValue().entrySet()) {
                stats.append(String.format("    %s: %.2f ms", streamTime.getKey(), streamTime.getValue() / 1000000.0)).append("\n");
            }
        }
    }

    private static @NonNull Map<@NonNull TimelineWorkload, @NonNull Map<@NonNull String, @NonNull Double>> getTopTagTimeMap(@NonNull Map<@NonNull TimelineWorkload, @NonNull Map<@NonNull String, @NonNull Double>> tagTimeMap, int limit) {
        PriorityQueue<TimelineWorkloadItem> topQueue = new PriorityQueue<TimelineWorkloadItem>(Comparator.comparingDouble(a -> a.sum).thenComparingLong(a -> a.workload().getId()));
        for (Map.Entry<TimelineWorkload, Map<String, Double>> entry : tagTimeMap.entrySet()) {
            TimelineWorkload workload = entry.getKey();
            Map<String, Double> tagMap = entry.getValue();
            double sum = tagMap.values().stream().mapToDouble(Double::doubleValue).sum();
            topQueue.offer(new TimelineWorkloadItem(workload, tagMap, sum));
            if (topQueue.size() <= limit) continue;
            topQueue.poll();
        }
        return topQueue.stream().sorted(Comparator.comparingDouble(item -> item.sum).reversed().thenComparingLong(item -> item.workload().getId())).collect(Collectors.toMap(TimelineWorkloadItem::workload, TimelineWorkloadItem::tagMap, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private static @NonNull Map<@NonNull TimelineWorkload, @NonNull Map<@NonNull String, @NonNull Double>> getAllTagStreamTimeMap(Set<@NonNull ICAMJob> selectedJobs) {
        @NonNull HashMap<@NonNull TimelineWorkload, @NonNull Map<@NonNull String, @NonNull Double>> tagTimeMap = new HashMap<TimelineWorkload, Map<String, Double>>();
        for (ICAMJob job : selectedJobs) {
            Map<String, Double> streamTimeMap;
            if (!(job instanceof IGPUWorkloadJob)) continue;
            TimelineWorkload properties = ((IGPUWorkloadJob)job).getTimelineWorkload();
            String stream = job.getTrack().getTitle();
            long duration = job.getStopTime() - job.getStartTime();
            if (tagTimeMap.containsKey(properties)) {
                streamTimeMap = (Map)tagTimeMap.get(properties);
                if (streamTimeMap == null) continue;
                if (streamTimeMap.containsKey(stream)) {
                    Double durationAlready = (Double)streamTimeMap.get(stream);
                    streamTimeMap.put(stream, durationAlready != null ? Double.valueOf((Double)NullChecking.neverNull((Object)durationAlready) + (double)duration) : Double.valueOf(duration));
                    continue;
                }
                streamTimeMap.put(stream, Double.valueOf(duration));
                tagTimeMap.put(properties, streamTimeMap);
                continue;
            }
            streamTimeMap = new HashMap();
            streamTimeMap.put(stream, Double.valueOf(duration));
            tagTimeMap.put(properties, streamTimeMap);
        }
        return tagTimeMap;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @NonNull TObjectDoubleHashMap<@NonNull String> getActiveStreamTimeMap(@NonNull Set<@NonNull ICAMJob> selectedJobs) {
        @NonNull @NonNull TObjectDoubleHashMap streamTimeMap = new TObjectDoubleHashMap();
        for (ICAMJob job : selectedJobs) {
            String stream = job.getTrack().getTitle();
            double duration = (double)(job.getStopTime() - job.getStartTime()) / 1000000.0;
            streamTimeMap.put((Object)stream, streamTimeMap.get((Object)stream) + duration);
        }
        return streamTimeMap;
    }

    private void computeFrameRateReport(@NonNull StringBuilder stats, long startTime, long duration, Map<@NonNull ICAMTrack, ? extends List<? extends @NonNull ICAMJob>> jobsInRange) {
        @NonNull Map<@NonNull Long, @NonNull List<@NonNull T>> workloadsFromJob = jobsInRange.values().stream().flatMap(Collection::stream).filter(IGPUWorkloadJob.class::isInstance).map(IGPUWorkloadJob.class::cast).collect(Collectors.groupingBy(job -> job.getTimelineWorkload().getFrame(), Collectors.toList()));
        Map<Long, List> completeFrames = workloadsFromJob.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() == this.provider.getGPUWorkloadJobsAsList(((Long)entry.getKey()).longValue()).size()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        OptionalLong firstStartTime = completeFrames.values().stream().flatMap(Collection::stream).mapToLong(ICAMJob::getStartTime).min();
        OptionalLong lastEndTime = completeFrames.values().stream().flatMap(Collection::stream).mapToLong(ICAMJob::getStopTime).max();
        if (firstStartTime.isPresent() && lastEndTime.isPresent()) {
            long minTime = firstStartTime.getAsLong();
            long maxTime = lastEndTime.getAsLong();
            int numberOfWholeFramesInRange = completeFrames.size();
            long frameDuration = maxTime - minTime;
            double frameDurationInSeconds = (double)frameDuration / 1.0E9;
            stats.append(String.format(" %s: %s", "Frames", Integer.toString(numberOfWholeFramesInRange))).append("\n");
            if (numberOfWholeFramesInRange > 0) {
                double msf = frameDurationInSeconds * 1000.0 / (double)numberOfWholeFramesInRange;
                double fps = (double)(1000000000L * (long)numberOfWholeFramesInRange) / (double)frameDuration;
                stats.append(String.format(" %s: %.2f ms/frame (%.2f %s)", "Performance", msf, fps, " FPS")).append("\n");
            }
        }
    }

    private void computeUtilizationReport(@NonNull StringBuilder stats, long startTime, long duration, Map<@NonNull ICAMTrack, @NonNull List<@NonNull ICAMJob>> trackToJobsMap) {
        stats.append("Utilization").append("\n");
        long endTime = startTime + duration;
        Map<String, List> mergedTrackTitleToJobsMap = trackToJobsMap.entrySet().stream().collect(Collectors.toMap(entry -> ((ICAMTrack)entry.getKey()).getTitle(), Map.Entry::getValue, (list1, list2) -> {
            @NonNull ArrayList<@NonNull E> merged = new ArrayList(list1);
            merged.addAll(list2);
            return merged;
        }));
        for (String title : mergedTrackTitleToJobsMap.keySet()) {
            List list = mergedTrackTitleToJobsMap.get(title);
            if (list == null) continue;
            long sumOfDurationOfJobs = list.stream().mapToLong(c -> {
                long durForJob;
                long start = startTime;
                if (c.getStartTime() > startTime) {
                    start = c.getStartTime();
                }
                long end = endTime;
                if (c.getStopTime() < endTime) {
                    end = c.getStopTime();
                }
                return (durForJob = end - start) > duration ? duration : durForJob;
            }).sum();
            double trackUtilization = (double)(sumOfDurationOfJobs * 100L) / (double)duration;
            stats.append(String.format(" %s: %.2f %%", title, trackUtilization)).append("\n");
        }
    }

    private record TimelineWorkloadItem(@NonNull TimelineWorkload workload, @NonNull Map<@NonNull String, @NonNull Double> tagMap, double sum) {
    }
}

