/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.cam;

import com.arm.streamline.jni.apcdbgen.proto.ICAMJob;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;

public final class CAMJobListMerger {
    private final @NonNull List<@NonNull List<? extends @NonNull ICAMJob>> perTrackJobs;

    private static boolean betterMatch(@NonNull ICAMJob currentBest, @NonNull ICAMJob newJob) {
        if (currentBest.getStartTime() < newJob.getStartTime()) {
            return false;
        }
        if (currentBest.getStartTime() > newJob.getStartTime()) {
            return true;
        }
        if (currentBest.getStopTime() < newJob.getStopTime()) {
            return false;
        }
        if (currentBest.getStopTime() > newJob.getStopTime()) {
            return true;
        }
        return currentBest.getId() > newJob.getId();
    }

    public CAMJobListMerger(@NonNull List<@NonNull List<? extends @NonNull ICAMJob>> perTrackJobs) {
        this.perTrackJobs = perTrackJobs;
    }

    public void forEach(@NonNull Predicate<@NonNull ICAMJob> callback) {
        int[] indexes = new int[this.perTrackJobs.size()];
        while (true) {
            int bestIndex = -1;
            ICAMJob bestItem = null;
            int i = 0;
            while (i < indexes.length) {
                int li = indexes[i];
                List<? extends ICAMJob> l = this.perTrackJobs.get(i);
                if (li < l.size()) {
                    ICAMJob j = l.get(li);
                    if (bestItem == null || CAMJobListMerger.betterMatch(bestItem, j)) {
                        bestItem = j;
                        bestIndex = i;
                    }
                }
                ++i;
            }
            if (bestItem == null) {
                return;
            }
            if (!callback.test(bestItem)) {
                return;
            }
            int n = bestIndex;
            indexes[n] = indexes[n] + 1;
        }
    }
}

