/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.cam;

import com.arm.streamline.analysis.model.cam.ICAMDetailPanelInfo;
import com.arm.streamline.analysis.model.cam.ICAMJobSelection;
import com.arm.streamline.jni.apcdbgen.proto.ICAMDataProvider;
import com.arm.streamline.jni.apcdbgen.proto.ICAMJob;
import com.arm.streamline.jni.apcdbgen.proto.ICAMTrack;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;

public class CAMASTFSyscallsInfoModel
implements ICAMDetailPanelInfo {
    private static final double NANO_TIME = 1.0E9;
    private static final double MILLI_TIME = 1000000.0;
    private static final @NonNull String ACTIVE_REGION = "Active region:";
    private static final @NonNull String START = "Start";
    private static final @NonNull String DURATION = "Duration";
    private static final @NonNull String NEW_LINE = "\n";
    private final @NonNull ICAMDataProvider provider;
    private final @NonNull ICAMJobSelection camJobSelectionModel;

    public CAMASTFSyscallsInfoModel(@NonNull ICAMDataProvider provider, @NonNull ICAMJobSelection selectionModel) {
        this.provider = provider;
        this.camJobSelectionModel = selectionModel;
    }

    public @NonNull String getActiveRegionStats(long startTime, long endTime) {
        StringBuilder stats = new StringBuilder();
        long duration = endTime - startTime;
        stats.append(ACTIVE_REGION).append(NEW_LINE);
        stats.append(String.format(" %s: %.2f s", START, (double)startTime / 1.0E9)).append(NEW_LINE);
        stats.append(String.format(" %s: %.2f ms", DURATION, (double)duration / 1000000.0)).append(NEW_LINE);
        stats.append(NEW_LINE);
        if (duration > 0L) {
            List<ICAMTrack> allLeafTracks = CAMASTFSyscallsInfoModel.getAllLeafTracks(this.provider.getTracks());
            @NonNull Set<@NonNull ICAMJob> jobsInRange = CAMASTFSyscallsInfoModel.getActiveJobsInTimeRange(allLeafTracks, startTime, endTime);
            stats.append(this.getActiveEventStatsForJobs(jobsInRange));
        }
        return stats.toString();
    }

    private static @NonNull Set<@NonNull ICAMJob> getActiveJobsInTimeRange(@NonNull List<@NonNull ICAMTrack> tracks, long startTime, long endTime) {
        return tracks.stream().flatMap(track -> track.getJobs(startTime, endTime).stream()).filter(job -> job.getStartTime() >= startTime && job.getStopTime() <= endTime).collect(Collectors.toSet());
    }

    private static @NonNull List<@NonNull ICAMTrack> getAllLeafTracks(@NonNull List<@NonNull ICAMTrack> list) {
        return list.stream().flatMap(CAMASTFSyscallsInfoModel::flattenTracks).filter(track -> track.getChildren().isEmpty()).collect(Collectors.toList());
    }

    private static @NonNull Stream<@NonNull ICAMTrack> flattenTracks(@NonNull ICAMTrack track) {
        return Stream.concat(Stream.of(track), track.getChildren().stream().flatMap(CAMASTFSyscallsInfoModel::flattenTracks));
    }

    public @NonNull String getActiveEventStats() {
        return this.getActiveEventStatsForJobs(this.camJobSelectionModel.getSelectedJobs());
    }

    public @NonNull String getActiveEventStatsForJobs(@NonNull Set<@NonNull ICAMJob> jobs) {
        StringBuilder stats = new StringBuilder();
        Set<ICAMJob> selectedJobs = jobs;
        if (selectedJobs.size() == 1) {
            CAMASTFSyscallsInfoModel.computeActiveEventStatsSingle(stats, selectedJobs.iterator().next());
        } else if (selectedJobs.size() > 1) {
            CAMASTFSyscallsInfoModel.computeActiveEventStatsMulti(stats, selectedJobs);
        }
        return stats.toString();
    }

    private static void computeActiveEventStatsSingle(@NonNull StringBuilder stats, @NonNull ICAMJob camJob) {
        Double startTime = (double)camJob.getStartTime() / 1000000.0;
        stats.append(String.format("%s Initiated: %.2f ms", camJob.getName(), startTime));
    }

    private static void computeActiveEventStatsMulti(@NonNull StringBuilder stats, @NonNull Set<@NonNull ICAMJob> selectedJobs) {
        long total = selectedJobs.size();
        if (total == 0L) {
            return;
        }
        AtomicInteger rank = new AtomicInteger(0);
        selectedJobs.stream().collect(Collectors.groupingBy(ICAMJob::getName, Collectors.counting())).entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).forEach(e -> {
            double percent = ((Long)e.getValue()).doubleValue() * 100.0 / (double)total;
            int r = rank.incrementAndGet();
            stats.append(String.format("%d. %s: %d (%.2f%%)", r, e.getKey(), e.getValue(), percent)).append(NEW_LINE);
        });
    }
}

