/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.bindata;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.StateFile;
import com.arm.streamline.model.bindata.BinDataSourceMap;
import com.arm.streamline.model.bindata.IAllBinDataProvider;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.bindata.TimelineBinDataProvider;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.report.model.VariableReplacer;
import com.arm.utils.NullChecking;
import com.arm.utils.StreamUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.fieldassist.ContentProposal;

public class TimelineAllBinData
implements IAllBinDataProvider {
    private static final String COUNTERS_PATH = "timeline/counters";
    private final @NonNull Analysis mAnalysis;
    private long mPrevEnd;
    private long mPrevStart;
    private Set<@NonNull TimelineBinDataProvider> mPrevSources = new HashSet<TimelineBinDataProvider>();
    private @Nullable ZoomLevel mPrevZoomLevel;
    private final @NonNull BinDataSourceMap<TimelineBinDataProvider> sourceMap;

    public TimelineAllBinData(@NonNull Analysis analysis) {
        this.mAnalysis = analysis;
        this.sourceMap = new BinDataSourceMap(this.mAnalysis.getClusterCount() < 2);
        this.loadCounterSources(new File(this.mAnalysis.getReportDirectory(), COUNTERS_PATH), (StateFile)NullChecking.neverNull((Object)this.mAnalysis.getStateFile()));
    }

    public List<@NonNull IBinDataProvider> getAllProviders() {
        return new ArrayList<IBinDataProvider>(this.sourceMap.getAllProviders());
    }

    public List<@NonNull IBinDataProvider> getAllSelectedProviders() {
        return new ArrayList<IBinDataProvider>(this.sourceMap.getAllProviders());
    }

    @Override
    public @Nullable IBinDataProvider getBinData(@NonNull String source) {
        return this.sourceMap.getProvider(source);
    }

    @Override
    public @NonNull List<@NonNull ContentProposal> getContentProposals() {
        return this.sourceMap.getContentProposals(arg_0 -> ((VariableReplacer)this.mAnalysis.getVariableReplacer()).replace(arg_0));
    }

    @Override
    public boolean isValidSource(@NonNull String source, @NonNull IntPredicate clusterFilter) {
        return this.sourceMap.isActiveSource(source, clusterFilter);
    }

    @Override
    public void prepareRange(@NonNull ZoomLevel zoomLevel, long start, long end) {
        this.doPrepareRange(zoomLevel, start, end, this.sourceMap.getAllProviders());
    }

    @Override
    public void prepareRange(@NonNull ZoomLevel zoomLevel, long start, long end, @NonNull Set<@NonNull String> sources) {
        Set<TimelineBinDataProvider> providers = StreamUtils.filterOutNull(sources.stream().map(this.sourceMap::getProvider)).collect(Collectors.toSet());
        this.doPrepareRange(zoomLevel, start, end, providers);
    }

    private void doPrepareRange(@NonNull ZoomLevel zoomLevel, long start, long end, @NonNull Set<@NonNull TimelineBinDataProvider> sources) {
        boolean needsPreparing;
        boolean bl = needsPreparing = !zoomLevel.equals((Object)this.mPrevZoomLevel) || this.mPrevStart != start || this.mPrevEnd != end;
        if (needsPreparing) {
            this.mPrevSources = new HashSet<TimelineBinDataProvider>(sources);
        } else {
            HashSet<TimelineBinDataProvider> difference = new HashSet<TimelineBinDataProvider>(sources);
            difference.removeAll(this.mPrevSources);
            this.mPrevSources.addAll(sources);
            sources = difference;
            boolean bl2 = needsPreparing = !sources.isEmpty();
        }
        if (needsPreparing) {
            this.mPrevZoomLevel = zoomLevel;
            this.mPrevStart = start;
            this.mPrevEnd = end;
            if (end - start + 1L > 1024L) {
                StreamlinePlugin.info("Range (" + (end - start + 1L) + ") larger than cache size (1024) may result in poor performance", new Throwable());
                return;
            }
            ArrayList<Task> taskList = new ArrayList<Task>();
            for (TimelineBinDataProvider source : sources) {
                source.prepareRange(zoomLevel, start, end);
                taskList.add(Task.callOnAnotherThread((Runnable)source));
            }
            for (Task task : taskList) {
                task.join();
            }
        }
    }

    private void loadCounterSources(File file, @NonNull StateFile stateFile) {
        @NonNull File @Nullable [] candidates = file.listFiles();
        if (candidates == null || candidates.length == 0) {
            return;
        }
        ArrayList<String> fullSeriesNames = new ArrayList<String>();
        if (this.mAnalysis.isTimelineConfigurationLoadedFromFile()) {
            for (ChartAndSeriesConfig chart : this.mAnalysis.getTimelineConfiguration(false).getCharts()) {
                for (SeriesConfig series : chart.getAllExpandedSeries(this.mAnalysis.getAllBinData())) {
                    String fullSeriesName = String.format("%s %s", chart.getChart().getTitle(), series.getName());
                    fullSeriesNames.add(fullSeriesName);
                }
            }
        }
        File[] fileArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            File candidate = fileArray[n2];
            try {
                TimelineBinDataProvider source = new TimelineBinDataProvider(candidate, this.mAnalysis.getProcessingElementsReferenceSet(), stateFile);
                CounterRecord counter = source.getCounterRecord();
                boolean isSelected = counter.isSelected();
                String fullCounterName = String.format("%s %s", counter.getTitle(), counter.getName());
                boolean isUsedOnTimeline = fullSeriesNames.contains(fullCounterName);
                if (!this.sourceMap.addSource(source, isSelected || isUsedOnTimeline)) {
                    throw new IOException("Failed to add " + String.valueOf(candidate) + " to list of source");
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
    }

    @Override
    public @NonNull Set<@NonNull String> filterAndNormalizeSourceNames(@NonNull Set<@NonNull String> variableSetFromExpression) {
        return StreamUtils.filterOutNull(variableSetFromExpression.stream().map(s -> this.sourceMap.getProviderAndProperName((String)s, true))).map(p -> (String)p.first).collect(Collectors.toSet());
    }
}

