/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.bindata;

import com.arm.streamline.common.model.VariableReplacerConstants;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.chart.SeriesRangeCalculator;
import com.arm.utils.collections.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntPredicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.fieldassist.ContentProposal;

public final class BinDataSourceMap<T extends IBinDataProvider> {
    private static final @NonNull String CLUSTER_SUFFIX_ZERO = VariableReplacerConstants.clusterSuffixId((int)0);
    private final @NonNull Map<@NonNull String, @NonNull T> activeSources = new HashMap<String, T>();
    private final boolean allowCluster0Alias;
    private final @NonNull Map<@NonNull String, @NonNull T> allSources = new HashMap<String, T>();
    private final @NonNull Set<@NonNull T> allUniqueActiveSources = new HashSet<T>();
    private final @NonNull Set<@NonNull T> allUniqueInactiveSources = new HashSet<T>();
    private final @NonNull Set<@NonNull T> allUniqueSources = new HashSet<T>();

    private static boolean isCluster0AliasAllowed(@NonNull CounterRecord counterRecord) {
        @Nullable Integer cluster = counterRecord.getCluster();
        if (cluster != null && cluster != 0) {
            return false;
        }
        return counterRecord.getDeviceTypeOrDefault().isCPU();
    }

    private static @NonNull String swapCluster0Suffix(@NonNull String source) {
        if (source.endsWith(CLUSTER_SUFFIX_ZERO)) {
            return source.substring(0, source.length() - CLUSTER_SUFFIX_ZERO.length());
        }
        return source.concat(CLUSTER_SUFFIX_ZERO);
    }

    public BinDataSourceMap(boolean allowCluster0Alias) {
        this.allowCluster0Alias = allowCluster0Alias;
    }

    public boolean addSource(@NonNull T source, boolean active) {
        Set<String> names = source.getAllUniqueSourceNames();
        boolean addedAny = false;
        for (String name : names) {
            if (SeriesRangeCalculator.isPredefinedVariable(name)) continue;
            this.allSources.put(name, source);
            if (active) {
                this.activeSources.put(name, source);
            } else {
                this.activeSources.remove(name);
            }
            addedAny = true;
        }
        if (addedAny) {
            this.allUniqueSources.add(source);
            if (active) {
                this.allUniqueActiveSources.add(source);
                this.allUniqueInactiveSources.remove(source);
            } else {
                this.allUniqueActiveSources.remove(source);
                this.allUniqueInactiveSources.add(source);
            }
        } else {
            this.allUniqueSources.remove(source);
            this.allUniqueActiveSources.remove(source);
            this.allUniqueInactiveSources.remove(source);
        }
        return addedAny;
    }

    public @NonNull Set<@NonNull T> getAllProviders() {
        return Collections.unmodifiableSet(this.allUniqueSources);
    }

    public @NonNull Set<@NonNull T> getAllSelectedProviders() {
        return Collections.unmodifiableSet(this.allUniqueActiveSources);
    }

    public @NonNull Set<@NonNull T> getAllUnselectedProviders() {
        return Collections.unmodifiableSet(this.allUniqueInactiveSources);
    }

    public @NonNull List<@NonNull ContentProposal> getContentProposals(@NonNull Function<@NonNull String, @NonNull String> variableReplacer) {
        ArrayList<ContentProposal> contents = new ArrayList<ContentProposal>();
        for (IBinDataProvider provider : this.allUniqueActiveSources) {
            for (String expression : provider.getAllUniqueExpressionFormats()) {
                Object label = variableReplacer.apply(expression);
                if (!((String)label).contentEquals(expression)) {
                    label = expression + " (" + ((String)label).substring(1) + ")";
                }
                String description = provider.getCounterRecord().getDescription();
                contents.add(new ContentProposal(expression, (String)label, description));
            }
        }
        return contents;
    }

    public int getNumSources() {
        return this.allUniqueSources.size();
    }

    public @Nullable T getProvider(@NonNull String source) {
        Pair<String, T> pair = this.getProviderAndProperName(source, false);
        return (T)(pair != null ? (IBinDataProvider)pair.second : null);
    }

    public @Nullable Pair<@NonNull String, @NonNull T> getProviderAndProperName(@NonNull String source, boolean requireActive) {
        String mappedSource;
        IBinDataProvider mappedResult;
        Map<String, T> mapToSearch = requireActive ? this.activeSources : this.allSources;
        IBinDataProvider result = (IBinDataProvider)mapToSearch.get(source);
        if (result != null) {
            return new Pair((Object)source, (Object)result);
        }
        if (this.allowCluster0Alias && (mappedResult = (IBinDataProvider)mapToSearch.get(mappedSource = BinDataSourceMap.swapCluster0Suffix(source))) != null && BinDataSourceMap.isCluster0AliasAllowed(mappedResult.getCounterRecord())) {
            return new Pair((Object)mappedSource, (Object)mappedResult);
        }
        return null;
    }

    public boolean isActiveSource(@NonNull String source) {
        Pair<String, T> sourceToDataProviderPair = this.getProviderAndProperName(source, true);
        return sourceToDataProviderPair != null;
    }

    public boolean isActiveSource(@NonNull String source, @NonNull IntPredicate clusterFilter) {
        Pair<String, T> sourceToDataProviderPair = this.getProviderAndProperName(source, true);
        if (sourceToDataProviderPair == null) {
            return false;
        }
        CounterRecord cr = ((IBinDataProvider)sourceToDataProviderPair.second).getCounterRecord();
        Integer cluster = cr.getCluster();
        if (cluster == null) {
            return true;
        }
        return clusterFilter.test(cluster);
    }

    public boolean isInactiveSource(@NonNull String source) {
        Pair<String, T> sourceToDataProviderPair = this.getProviderAndProperName(source, false);
        return sourceToDataProviderPair != null && !this.activeSources.containsKey(sourceToDataProviderPair.first);
    }
}

