/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.annotation;

import com.arm.streamline.model.RGBString;
import com.arm.streamline.report.model.IIndexedDataProvider;
import com.arm.streamline.report.model.IndexedFile;
import com.arm.utils.collections.LRUCache;
import java.io.File;
import java.io.IOException;

public class AnnotationCache
implements IIndexedDataProvider<RGBString> {
    private IndexedFile<RGBString> mFile;
    private LRUCache<Integer, RGBString> mMessages = new LRUCache(10000);

    public AnnotationCache(File reportDir, String path) throws IOException {
        this.mFile = new IndexedFile(new File(reportDir, path), (IIndexedDataProvider)this, 1024);
    }

    public RGBString get(int id) throws IOException {
        if (id < 0 || id >= this.mFile.getDataBlockCount()) {
            return null;
        }
        Integer identifier = id;
        if (!this.mMessages.containsKey((Object)identifier)) {
            int SIZE = 100;
            if (id + 100 >= this.mFile.getDataBlockCount()) {
                RGBString message = (RGBString)this.mFile.getDataBlock((long)id);
                this.mMessages.put((Object)identifier, (Object)message);
                return message;
            }
            int base = id / 100 * 100;
            RGBString[] messages = this.mFile.getDataBlocks(base, 100).toArray(new RGBString[0]);
            int i = 0;
            while (i < 100) {
                Integer key = base + i;
                this.mMessages.put((Object)key, (Object)messages[i]);
                ++i;
            }
        }
        return (RGBString)this.mMessages.get((Object)identifier);
    }

    public RGBString loadData(byte[] data, boolean compressed) throws IOException {
        if (data == null || data.length == 0) {
            return new RGBString();
        }
        return new RGBString(data);
    }
}

