/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model;

import com.arm.streamline.common.model.CaptureSubType;
import com.arm.streamline.common.model.InvalidVersionException;
import com.arm.streamline.common.model.ProtocolType;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.jni.apcdbgen.ProfilingLoadOptions;
import com.arm.streamline.model.EventBasedSampleInfo;
import com.arm.streamline.model.session.SampleRate;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class StateFile {
    public static final String ATTR_64_BIT = "arch64";
    public static final String ATTR_APPLICATION_TRACING_MODE = "application_mode";
    public static final String ATTR_ARMNN_COUNTERS = "armnn_counters";
    public static final String ATTR_CAPTURE_SUB_TYPE = "sub_type";
    public static final String ATTR_CREATED = "created";
    public static final String ATTR_DURATION = "duration";
    public static final String ATTR_EBS_COUNTER = "ebs_counter";
    public static final String ATTR_EBS_THRESHOLD = "ebs_threshold";
    public static final String ATTR_EDITION = "edition";
    public static final String ATTR_FILTER_CALL_STACKS = "filter_call_stacks";
    public static final String ATTR_FILTER_KERNEL_ADDRESSES = "filter_kernel_addresses";
    public static final String ATTR_MALI_COUNTERS = "mali_counters";
    public static final String ATTR_PARSE_DEBUG_INFO = "parse_debug_info";
    public static final String ATTR_PROFILE_GROUPING_MODE = "profile_grouping_mode";
    public static final String ATTR_PROTOCOL_TYPE = "protocol_type";
    public static final String ATTR_RESOLUTION_MODE = "resolution";
    public static final String ATTR_SAMPLE_RATE = "sample_rate";
    public static final String ATTR_TARGET_ADDRESS = "target_address";
    public static final String ATTR_TARGET_NAME = "target_name";
    public static final String ATTR_TIME_BASE_UNIT_LONG = "time_base_unit_long";
    public static final String ATTR_TIME_BASE_UNIT_LONG_MANY = "time_base_unit_long_many";
    public static final String ATTR_TIME_BASE_UNIT_SHORT = "time_base_unit_short";
    public static final String ATTR_TIME_UNITS_PER_BASE = "time_units_per_base";
    public static final String ATTR_USE_INLINES = "use_inlines";
    public static final String ATTR_VERSION = "version";
    public static final int CURRENT_VERSION = 20250729;
    public static final String FILENAME = "state.xml";
    public static final int OLDEST_SUPPORTED_VERSION = 20250729;
    public static final String TAG_EBS = "ebs";
    public static final String TAG_STATE = "state";
    private final @NonNull CaptureSubType captureSubType;
    private final boolean mApplicationTracingMode;
    private final long mCreated;
    private final long mDuration;
    private final @Nullable EventBasedSampleInfo mEBSInfo;
    private boolean mFilterCallStacks;
    private boolean mFilterKernelAddresses;
    private final boolean mHasArmNNCounters;
    private final boolean mHasMaliCounters;
    private final InvalidVersionException mInvalid;
    private final boolean mIs64Bit;
    private boolean mParseDebugInfo;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ProfilingLoadOptions.GroupingMode mProfileGroupingMode;
    private final @NonNull ProtocolType mProtocolType;
    private final @NonNull ResolutionMode mResolution;
    private final @Nullable SampleRate mSampleRate;
    private final @Nullable String mTargetAddress;
    private final @Nullable String mTargetName;
    private final @NonNull TimeUnit mTimeUnit;
    private boolean mUseInlines;
    private final int mVersion;

    /*
     * Exception decompiling
     */
    public static @NonNull StateFile load(@NonNull File reportDir, @NonNull IProgressTracker tracker) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void save(@NonNull File outputPath, long duration, @NonNull ResolutionMode resolutionMode, boolean hasMaliCounters, boolean hasArmNNCounters, boolean is64bit, boolean applicationTracingMode, boolean filterCallStacks, boolean filterKernelAddresses, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ProfilingLoadOptions.GroupingMode profileGroupingMode, boolean useInlines, @Nullable String targetAddressStr, @Nullable String targetName, @Nullable SampleRate sampleRate, @NonNull ProtocolType protocolType, @NonNull CaptureSubType captureSubType, @NonNull TimeUnit timeUnit, @Nullable EventBasedSampleInfo eventBasedSampleInfo, boolean parseDebugInfo) throws IOException {
        Throwable throwable = null;
        Object var21_21 = null;
        try (XMLGenerator xml = XMLGenerator.create((File)new File(outputPath, FILENAME));){
            xml.startDocument();
            xml.startTag(TAG_STATE);
            xml.addAttribute(ATTR_VERSION, 20250729);
            xml.addAttribute(ATTR_CREATED, System.currentTimeMillis() / 1000L);
            xml.addAttribute(ATTR_DURATION, duration);
            xml.addAttribute(ATTR_RESOLUTION_MODE, resolutionMode.getStringValue());
            xml.addAttributeNot(ATTR_MALI_COUNTERS, hasMaliCounters, false);
            xml.addAttributeNot(ATTR_ARMNN_COUNTERS, hasArmNNCounters, false);
            xml.addAttributeNot(ATTR_64_BIT, is64bit, false);
            xml.addAttributeNot(ATTR_FILTER_CALL_STACKS, filterCallStacks, false);
            xml.addAttributeNot(ATTR_PARSE_DEBUG_INFO, parseDebugInfo, false);
            xml.addAttributeNot(ATTR_FILTER_KERNEL_ADDRESSES, filterKernelAddresses, false);
            xml.addAttribute(ATTR_PROFILE_GROUPING_MODE, StateFile.toString(profileGroupingMode));
            xml.addAttributeNot(ATTR_USE_INLINES, useInlines, false);
            if (targetAddressStr != null) {
                xml.addAttribute(ATTR_TARGET_ADDRESS, targetAddressStr);
            }
            if (targetName != null) {
                xml.addAttribute(ATTR_TARGET_NAME, targetName);
            }
            if (sampleRate != null) {
                xml.addAttribute(ATTR_SAMPLE_RATE, sampleRate.name());
            }
            xml.addAttribute(ATTR_PROTOCOL_TYPE, protocolType.xmlValue());
            xml.addAttributeNot(ATTR_CAPTURE_SUB_TYPE, captureSubType.xmlId, "");
            xml.addAttributeNot(ATTR_APPLICATION_TRACING_MODE, applicationTracingMode, false);
            xml.addAttribute(ATTR_TIME_BASE_UNIT_SHORT, timeUnit.getBaseSymbol());
            xml.addAttribute(ATTR_TIME_BASE_UNIT_LONG, timeUnit.getBaseText());
            xml.addAttribute(ATTR_TIME_BASE_UNIT_LONG_MANY, timeUnit.getBaseTextMany());
            xml.addAttribute(ATTR_TIME_UNITS_PER_BASE, timeUnit.getNumberPerBase());
            if (eventBasedSampleInfo != null) {
                for (EventBasedSampleInfo.Event event : eventBasedSampleInfo.getEvents()) {
                    xml.startEmptyTag(TAG_EBS);
                    xml.addAttribute(ATTR_EBS_COUNTER, event.getCounter());
                    xml.addAttribute(ATTR_EBS_THRESHOLD, event.getThreshold());
                }
            }
            xml.endTag();
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ProfilingLoadOptions.GroupingMode fromGroupingModeString(@Nullable String profileGroupingMode) {
        if (profileGroupingMode == null) {
            return ProfilingLoadOptions.GroupingMode.THREAD;
        }
        switch (profileGroupingMode) {
            case "inverted": {
                return ProfilingLoadOptions.GroupingMode.INVERTED_SYSTEM_WIDE;
            }
            case "process": {
                return ProfilingLoadOptions.GroupingMode.PROCESS;
            }
            case "system-wide": {
                return ProfilingLoadOptions.GroupingMode.SYSTEM_WIDE;
            }
            case "thread": {
                return ProfilingLoadOptions.GroupingMode.THREAD;
            }
        }
        throw new AssertionError((Object)profileGroupingMode);
    }

    private static @NonNull File getFile(@NonNull File reportDir) {
        return CommonFileUtils.getFile((File)new File(reportDir, FILENAME));
    }

    private static @NonNull StateFile load(XMLParser in) throws IOException {
        String unitBaseLongMany;
        String unitBaseShort;
        int version = in.getIntegerAttribute(ATTR_VERSION, 0);
        long created = in.getLongAttribute(ATTR_CREATED, System.currentTimeMillis() / 1000L);
        long duration = in.getLongAttribute(ATTR_DURATION, 0L);
        ResolutionMode resolutionMode = ResolutionMode.fromStringValue((String)in.getAttribute(ATTR_RESOLUTION_MODE));
        boolean hasMaliCounters = in.isAttributeSet(ATTR_MALI_COUNTERS, false);
        boolean hasArmNNCounters = in.isAttributeSet(ATTR_ARMNN_COUNTERS, false);
        @Nullable String targetAddress = in.getAttribute(ATTR_TARGET_ADDRESS);
        @Nullable String targetName = in.getAttribute(ATTR_TARGET_NAME);
        @NonNull SampleRate sampleRate = SampleRate.get(in.getAttribute(ATTR_SAMPLE_RATE));
        @NonNull ProtocolType protocolType = ProtocolType.get((String)in.getAttribute(ATTR_PROTOCOL_TYPE));
        @Nullable String captureSubTypeAttr = in.getAttribute(ATTR_CAPTURE_SUB_TYPE);
        @NonNull CaptureSubType captureSubType = captureSubTypeAttr != null ? CaptureSubType.get((String)captureSubTypeAttr) : CaptureSubType.DEFAULT;
        boolean is64Bit = in.isAttributeSet(ATTR_64_BIT, false);
        boolean applicationTracingMode = in.isAttributeSet(ATTR_APPLICATION_TRACING_MODE, false);
        boolean filterCallStacks = in.isAttributeSet(ATTR_FILTER_CALL_STACKS, true);
        boolean filterKernelAddresses = in.isAttributeSet(ATTR_FILTER_KERNEL_ADDRESSES, applicationTracingMode);
        boolean useInlines = in.isAttributeSet(ATTR_USE_INLINES, false);
        boolean parseDebugInfo = in.isAttributeSet(ATTR_PARSE_DEBUG_INFO, false);
        ProfilingLoadOptions.GroupingMode profileGroupingMode = StateFile.fromGroupingModeString(in.getAttribute(ATTR_PROFILE_GROUPING_MODE));
        @Nullable InvalidVersionException invalid = version > 20250729 ? InvalidVersionException.createReportDirectoryVersionTooNewException() : (version < 20250729 ? InvalidVersionException.createReportDirectoryVersionTooOldException() : null);
        int unitsPerBase = in.getIntegerAttribute(ATTR_TIME_UNITS_PER_BASE, TimeUnit.NANO_SECONDS.getNumberPerBase());
        String unitBaseLong = in.getAttribute(ATTR_TIME_BASE_UNIT_LONG, "");
        if (unitBaseLong.isEmpty()) {
            unitBaseLong = TimeUnit.NANO_SECONDS.getBaseText();
        }
        if ((unitBaseShort = in.getAttribute(ATTR_TIME_BASE_UNIT_SHORT, "")).isEmpty()) {
            unitBaseShort = unitBaseLong.substring(0, 1);
        }
        @NonNull TimeUnit timeUnit = (unitBaseLongMany = in.getAttribute(ATTR_TIME_BASE_UNIT_LONG_MANY, "")).isEmpty() ? new TimeUnit(unitsPerBase, unitBaseShort, unitBaseLong) : new TimeUnit(unitsPerBase, unitBaseShort, unitBaseLong, unitBaseLongMany);
        @Nullable EventBasedSampleInfo ebsInfo = StateFile.readEbsInfo(in);
        return new StateFile(version, created, duration, resolutionMode, hasMaliCounters, ebsInfo, targetAddress, targetName, sampleRate, protocolType, captureSubType, is64Bit, applicationTracingMode, invalid, timeUnit, hasArmNNCounters, filterCallStacks, filterKernelAddresses, profileGroupingMode, useInlines, parseDebugInfo);
    }

    private static final @Nullable EventBasedSampleInfo readEbsInfo(@NonNull XMLParser in) throws IOException {
        String tag;
        @NonNull ArrayList<@NonNull EventBasedSampleInfo.Event> ebsInfoEvents = new ArrayList<EventBasedSampleInfo.Event>();
        String nextMarker = in.getMarker();
        while ((tag = in.nextTag(nextMarker)) != null) {
            if (!tag.contentEquals(TAG_EBS)) continue;
            @NonNull String ebsCounter = (String)NullChecking.neverNull((Object)in.getAttribute(ATTR_EBS_COUNTER));
            int ebsThreshold = in.getIntegerAttribute(ATTR_EBS_THRESHOLD);
            assert (ebsThreshold > 0);
            ebsInfoEvents.add(new EventBasedSampleInfo.Event(ebsCounter, ebsThreshold));
        }
        if (ebsInfoEvents.isEmpty()) {
            return null;
        }
        return new EventBasedSampleInfo(ebsInfoEvents);
    }

    private static @NonNull String toString(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ProfilingLoadOptions.GroupingMode profileGroupingMode) {
        switch (profileGroupingMode) {
            case INVERTED_SYSTEM_WIDE: {
                return "inverted";
            }
            case PROCESS: {
                return "process";
            }
            case SYSTEM_WIDE: {
                return "system-wide";
            }
            case THREAD: {
                return "thread";
            }
        }
        throw new AssertionError(profileGroupingMode);
    }

    public StateFile(int version, long created, long duration, @NonNull ResolutionMode resolutionMode, boolean hasMaliCounters, @Nullable EventBasedSampleInfo ebsInfo, @Nullable String targetAddress, @Nullable String targetName, @NonNull SampleRate sampleRate, @NonNull ProtocolType protocolType, @NonNull CaptureSubType captureSubType, boolean is64Bit, boolean applicationTracingMode, @Nullable InvalidVersionException invalid, @NonNull TimeUnit timeUnit, boolean hasArmNNCounters, boolean filterCallStacks, boolean filterKernelAddresses, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ProfilingLoadOptions.GroupingMode profileGroupingMode, boolean useInlines, boolean parseDebugInfo) {
        this.captureSubType = captureSubType;
        this.mVersion = version;
        this.mCreated = created;
        this.mDuration = duration;
        this.mResolution = resolutionMode;
        this.mHasMaliCounters = hasMaliCounters;
        this.mEBSInfo = ebsInfo;
        this.mTargetAddress = targetAddress;
        this.mTargetName = targetName;
        this.mSampleRate = sampleRate;
        this.mProtocolType = protocolType;
        this.mIs64Bit = is64Bit;
        this.mApplicationTracingMode = applicationTracingMode;
        this.mInvalid = invalid;
        this.mTimeUnit = timeUnit;
        this.mHasArmNNCounters = hasArmNNCounters;
        this.mFilterCallStacks = filterCallStacks;
        this.mFilterKernelAddresses = filterKernelAddresses;
        this.mProfileGroupingMode = profileGroupingMode;
        this.mUseInlines = useInlines;
        this.mParseDebugInfo = parseDebugInfo;
    }

    public @NonNull CaptureSubType getCaptureSubType() {
        return this.captureSubType;
    }

    public long getCreated() {
        return this.mCreated;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public @Nullable EventBasedSampleInfo getEBSInfo() {
        return this.mEBSInfo;
    }

    public @NonNull ProtocolType getProtocolType() {
        return this.mProtocolType;
    }

    public @NonNull ResolutionMode getResolution() {
        return this.mResolution;
    }

    public SampleRate getSampleRate() {
        return this.mSampleRate;
    }

    public String getTargetAddress() {
        return this.mTargetAddress;
    }

    public String getTargetName() {
        return this.mTargetName;
    }

    public @NonNull TimeUnit getTimeUnit() {
        return this.mTimeUnit;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public boolean hasArmNNCounters() {
        return this.mHasArmNNCounters;
    }

    public boolean hasMaliCounters() {
        return this.mHasMaliCounters;
    }

    public String invalidReason() {
        if (this.mInvalid == null) {
            return null;
        }
        return this.mInvalid.getMessage();
    }

    public boolean is64Bit() {
        return this.mIs64Bit;
    }

    public boolean isApplicationTracingMode() {
        return this.mApplicationTracingMode;
    }

    public boolean isParseDebugInfoEnabled() {
        return this.mParseDebugInfo;
    }

    public boolean isVersionValid() {
        return this.mInvalid == null;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ProfilingLoadOptions.GroupingMode profileGroupingMode() {
        return this.mProfileGroupingMode;
    }

    public void save(@NonNull File mReportDirectory) throws IOException {
        StateFile.save(mReportDirectory, this.mDuration, this.mResolution, this.mHasMaliCounters, this.mHasArmNNCounters, this.mIs64Bit, this.mApplicationTracingMode, this.mFilterCallStacks, this.mFilterKernelAddresses, this.mProfileGroupingMode, this.mUseInlines, this.mTargetAddress, this.mTargetName, this.mSampleRate, this.mProtocolType, this.captureSubType, this.mTimeUnit, this.mEBSInfo, this.mParseDebugInfo);
    }

    public boolean setFilterCallStacks(boolean v) {
        if (this.mFilterCallStacks == v) {
            return false;
        }
        this.mFilterCallStacks = v;
        return true;
    }

    public boolean setFilterKernelAddresses(boolean v) {
        if (this.mFilterKernelAddresses == v) {
            return false;
        }
        this.mFilterKernelAddresses = v;
        return true;
    }

    public boolean setProfileGroupingMode(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ProfilingLoadOptions.GroupingMode profileGroupingMode) {
        if (this.mProfileGroupingMode.equals((Object)profileGroupingMode)) {
            return false;
        }
        this.mProfileGroupingMode = profileGroupingMode;
        return true;
    }

    public boolean setUseInlines(boolean v) {
        if (this.mUseInlines == v) {
            return false;
        }
        this.mUseInlines = v;
        return true;
    }

    public boolean shouldFilterCallStacks() {
        return this.mFilterCallStacks;
    }

    public boolean shouldFilterKernelAddresses() {
        return this.mFilterKernelAddresses;
    }

    public boolean shouldUseInlines() {
        return this.mUseInlines;
    }
}

